/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

public enum Space {
    WORLD,
    LOCAL,
    LOCAL_HORIZONTAL,
    LOCAL_HORIZONTAL_NORMALIZED,
    VELOCITY,
    VELOCITY_NORMALIZED,
    VELOCITY_HORIZONTAL,
    VELOCITY_HORIZONTAL_NORMALIZED;


    private static Matrix3f getBaseTransformMatrixFromNormalizedDirectionVector(class_243 vector, float yaw) {
        double xZ;
        double xX;
        double zX = 0.0;
        double zY = vector.method_10214();
        double zZ = 0.0;
        if (Math.abs(zY) != 1.0) {
            zX = vector.method_10216();
            zZ = vector.method_10215();
            xX = vector.method_10215();
            xZ = -vector.method_10216();
            float xFactor = (float)(1.0 / Math.sqrt(xX * xX + xZ * xZ));
            xX *= (double)xFactor;
            xZ *= (double)xFactor;
        } else {
            float trigonometricYaw = -yaw * ((float)Math.PI / 180);
            xX = class_3532.method_15362((float)trigonometricYaw);
            xZ = -class_3532.method_15374((float)trigonometricYaw);
        }
        Matrix3f res = new Matrix3f();
        res.set(0, 0, (float)xX);
        res.set(1, 0, 0.0f);
        res.set(2, 0, (float)xZ);
        res.set(0, 1, (float)(zY * xZ));
        res.set(1, 1, (float)(zZ * xX - zX * xZ));
        res.set(2, 1, (float)(-zY * xX));
        res.set(0, 2, (float)zX);
        res.set(1, 2, (float)zY);
        res.set(2, 2, (float)zZ);
        return res;
    }

    public static void transformVectorToBase(class_243 baseForwardVector, Vector3f vector, float baseYaw, boolean normalizeBase) {
        double baseScaleD = baseForwardVector.method_1033();
        if (baseScaleD <= 0.007) {
            vector.zero();
        } else {
            float baseScale = (float)baseScaleD;
            class_243 normalizedBase = baseForwardVector.method_1029();
            Matrix3f transformMatrix = Space.getBaseTransformMatrixFromNormalizedDirectionVector(normalizedBase, baseYaw);
            if (!normalizeBase) {
                transformMatrix.scale(baseScale, baseScale, baseScale);
            }
            vector.mulTranspose((Matrix3fc)transformMatrix);
        }
    }

    public void toGlobal(Vector3f vector, class_1297 entity) {
        switch (this.ordinal()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                class_243 baseForwardVector = entity.method_5720();
                if (this != LOCAL) {
                    baseForwardVector = new class_243(baseForwardVector.method_10216(), 0.0, baseForwardVector.method_10215());
                }
                Space.transformVectorToBase(baseForwardVector, vector, entity.method_36454(), this == LOCAL_HORIZONTAL_NORMALIZED);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                class_243 baseForwardVector = entity.method_18798();
                if (this == VELOCITY_HORIZONTAL || this == VELOCITY_HORIZONTAL_NORMALIZED) {
                    baseForwardVector = new class_243(baseForwardVector.method_10216(), 0.0, baseForwardVector.method_10215());
                }
                Space.transformVectorToBase(baseForwardVector, vector, entity.method_36454(), this == VELOCITY_NORMALIZED || this == VELOCITY_HORIZONTAL_NORMALIZED);
            }
        }
    }
}

