/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.data.DamageSourceDescription;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5362;
import net.minecraft.class_5425;
import net.minecraft.class_7923;
import net.minecraft.class_8109;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

public final class MiscUtil {
    public static void createExplosion(class_1937 world, class_243 pos, float power, boolean createFire, class_1927.class_4179 destructionType, class_5362 behavior) {
        MiscUtil.createExplosion(world, null, pos, power, createFire, destructionType, behavior);
    }

    public static void createExplosion(class_1937 world, class_1297 entity, class_243 pos, float power, boolean createFire, class_1927.class_4179 destructionType, class_5362 behavior) {
        MiscUtil.createExplosion(world, entity, world.method_48963().method_48807(null), pos.method_10216(), pos.method_10214(), pos.method_10215(), power, createFire, destructionType, behavior);
    }

    public static void createExplosion(class_1937 world, class_1297 entity, class_1282 damageSource, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType, class_5362 behavior) {
        class_1927 explosion = new class_1927(world, entity, damageSource, behavior, x, y, z, power, createFire, destructionType);
        explosion.method_8348();
        explosion.method_8350(world.field_9236);
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (!explosion.method_46667()) {
            explosion.method_8352();
        }
        for (class_3222 serverPlayerEntity : serverWorld.method_18456()) {
            if (!(serverPlayerEntity.method_5649(x, y, z) < 4096.0)) continue;
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2664(x, y, z, power, explosion.method_8346(), (class_243)explosion.method_8351().get(serverPlayerEntity)));
        }
    }

    @Nullable
    public static class_5362 getExplosionBehavior(final class_1937 world, final @Nullable Predicate<class_2694> indestructibleCondition) {
        return indestructibleCondition == null ? null : new class_5362(){

            public boolean method_29554(class_1927 explosion, class_1922 blockView, class_2338 pos, class_2680 state, float power) {
                return !indestructibleCondition.test(new class_2694((class_4538)world, pos, true));
            }
        };
    }

    public static Optional<class_1297> getEntityWithPassengers(class_1937 world, class_1299<?> entityType, @Nullable class_2487 entityNbt, class_243 pos, float yaw, float pitch) {
        if (world.field_9236) {
            return Optional.empty();
        }
        class_3218 serverWorld = (class_3218)world;
        class_2487 entityToSpawnNbt = new class_2487();
        if (entityNbt != null) {
            entityToSpawnNbt.method_10543(entityNbt);
        }
        entityToSpawnNbt.method_10582("id", class_7923.field_41177.method_10221(entityType).toString());
        class_1297 entityToSpawn = class_1299.method_17842((class_2487)entityToSpawnNbt, (class_1937)serverWorld, entity -> {
            entity.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, yaw, pitch);
            return entity;
        });
        if (entityToSpawn == null) {
            return Optional.empty();
        }
        if (entityNbt == null && entityToSpawn instanceof class_1308) {
            class_1308 mobToSpawn = (class_1308)entityToSpawn;
            mobToSpawn.method_5943((class_5425)serverWorld, serverWorld.method_8404(class_2338.method_49638((class_2374)pos)), class_3730.field_16462, null, null);
        }
        return Optional.of(entityToSpawn);
    }

    public static class_2680 getInWallBlockState(class_1309 playerEntity) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i < 8; ++i) {
            double d = playerEntity.method_23317() + (double)(((float)((i >> 0) % 2) - 0.5f) * playerEntity.method_17681() * 0.8f);
            double e = playerEntity.method_23320() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = playerEntity.method_23321() + (double)(((float)((i >> 2) % 2) - 0.5f) * playerEntity.method_17681() * 0.8f);
            mutable.method_10102(d, e, f);
            class_2680 blockState = playerEntity.method_37908().method_8320((class_2338)mutable);
            if (blockState.method_26217() == class_2464.field_11455 || !blockState.method_26230((class_1922)playerEntity.method_37908(), (class_2338)mutable)) continue;
            return blockState;
        }
        return null;
    }

    public static <T> Predicate<T> combineOr(Predicate<T> a, Predicate<T> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.or(b);
    }

    public static <T> Predicate<T> combineAnd(Predicate<T> a, Predicate<T> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.and(b);
    }

    public static class_1282 createDamageSource(class_8109 damageSources, @Nullable DamageSourceDescription damageSourceDescription, @Nullable class_5321<class_8110> damageType) {
        if (damageSourceDescription == null && damageType == null) {
            throw new JsonSyntaxException("Either a legacy damage source or an ID of a damage type must be specified");
        }
        return damageSourceDescription == null ? damageSources.method_48795(damageType) : damageSourceDescription.create(damageSources);
    }

    public static class_1282 createDamageSource(class_8109 damageSources, @Nullable DamageSourceDescription damageSourceDescription, @Nullable class_5321<class_8110> damageType, class_1297 attacker) {
        if (damageSourceDescription == null && damageType == null) {
            throw new JsonSyntaxException("Either a legacy damage source or an ID of a damage type must be specified");
        }
        return damageSourceDescription == null ? damageSources.method_48796(damageType, attacker) : damageSourceDescription.create(damageSources, attacker);
    }

    public static class_1282 createDamageSource(class_8109 damageSources, @Nullable DamageSourceDescription damageSourceDescription, @Nullable class_5321<class_8110> damageType, class_1297 source, class_1297 attacker) {
        if (damageSourceDescription == null && damageType == null) {
            throw new JsonSyntaxException("Either a legacy damage source or an ID of a damage type must be specified");
        }
        return damageSourceDescription == null ? damageSources.method_48797(damageType, source, attacker) : damageSourceDescription.create(damageSources, source, attacker);
    }
}

