/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.mixin.ItemSlotArgumentTypeAccessor;
import io.github.apace100.apoli.power.InventoryPower;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.util.ArgumentWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5630;

public class InventoryUtil {
    public static Set<Integer> getSlots(SerializableData.Instance data) {
        HashSet<Integer> slots = new HashSet<Integer>();
        data.ifPresent("slot", iaw -> slots.add((Integer)iaw.get()));
        data.ifPresent("slots", iaws -> slots.addAll(iaws.stream().map(ArgumentWrapper::get).toList()));
        if (slots.isEmpty()) {
            slots.addAll(ItemSlotArgumentTypeAccessor.getSlotMappings().values());
        }
        return slots;
    }

    public static int checkInventory(SerializableData.Instance data, class_1297 entity, InventoryPower inventoryPower, Function<class_1799, Integer> processor) {
        Predicate itemCondition = (Predicate)data.get("item_condition");
        Set<Integer> slots = InventoryUtil.getSlots(data);
        InventoryUtil.deduplicateSlots(entity, slots);
        int matches = 0;
        if (inventoryPower == null) {
            for (int slot : slots) {
                class_5630 stackReference = entity.method_32318(slot);
                if (stackReference == class_5630.field_27860) continue;
                class_1799 stack = stackReference.method_32327();
                if ((itemCondition != null || stack.method_7960()) && itemCondition != null && !itemCondition.test(stack)) continue;
                matches += processor.apply(stack).intValue();
            }
        } else {
            for (int slot : slots) {
                if (slot < 0 || slot >= inventoryPower.method_5439()) continue;
                class_1799 stack = inventoryPower.method_5438(slot);
                if ((itemCondition != null || stack.method_7960()) && itemCondition != null && !itemCondition.test(stack)) continue;
                matches += processor.apply(stack).intValue();
            }
        }
        return matches;
    }

    public static void modifyInventory(SerializableData.Instance data, class_1297 entity, InventoryPower inventoryPower, Function<class_1799, Integer> processor, int limit) {
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        Set<Integer> slots = InventoryUtil.getSlots(data);
        InventoryUtil.deduplicateSlots(entity, slots);
        Consumer entityAction = (Consumer)data.get("entity_action");
        Predicate itemCondition = (Predicate)data.get("item_condition");
        ActionFactory.Instance itemAction = (ActionFactory.Instance)data.get("item_action");
        int counter = 0;
        if (inventoryPower == null) {
            for (int slot2 : slots) {
                class_1799 itemStack;
                class_5630 stackReference = entity.method_32318(slot2);
                if (stackReference == class_5630.field_27860 || (itemStack = stackReference.method_32327()).method_7960() || itemCondition != null && !itemCondition.test(itemStack)) continue;
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                int amount = processor.apply(itemStack);
                for (int i = 0; i < amount; ++i) {
                    itemAction.accept(new class_3545((Object)entity.method_37908(), (Object)itemStack));
                    if (++counter >= limit) break;
                }
                if (counter < limit) continue;
                break;
            }
        } else {
            slots.removeIf(slot -> slot < 0 || slot >= inventoryPower.method_5439());
            for (int slot3 : slots) {
                class_1799 itemStack = inventoryPower.method_5438(slot3);
                if (itemStack.method_7960() || itemCondition != null && !itemCondition.test(itemStack)) continue;
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                int amount = processor.apply(itemStack);
                for (int i = 0; i < amount; ++i) {
                    itemAction.accept(new class_3545((Object)entity.method_37908(), (Object)itemStack));
                    if (++counter >= limit) break;
                }
                if (counter < limit) continue;
                break;
            }
        }
    }

    public static void replaceInventory(SerializableData.Instance data, class_1297 entity, InventoryPower inventoryPower) {
        Set<Integer> slots = InventoryUtil.getSlots(data);
        InventoryUtil.deduplicateSlots(entity, slots);
        Consumer entityAction = (Consumer)data.get("entity_action");
        Predicate itemCondition = (Predicate)data.get("item_condition");
        Consumer itemAction = (Consumer)data.get("item_action");
        class_1799 replacementStack = (class_1799)data.get("stack");
        boolean mergeNbt = data.getBoolean("merge_nbt");
        if (inventoryPower == null) {
            slots.forEach(slot -> {
                class_5630 stackReference = entity.method_32318(slot.intValue());
                if (stackReference == class_5630.field_27860) {
                    return;
                }
                class_1799 itemStack = stackReference.method_32327();
                if (itemCondition != null && !itemCondition.test(itemStack)) {
                    return;
                }
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                class_1799 stackAfterReplacement = replacementStack.method_7972();
                if (mergeNbt && itemStack.method_7985()) {
                    itemStack.method_7948().method_10543(stackAfterReplacement.method_7948());
                    stackAfterReplacement.method_7980(itemStack.method_7948());
                }
                stackReference.method_32332(stackAfterReplacement);
                if (itemAction != null) {
                    itemAction.accept(new class_3545((Object)entity.method_37908(), (Object)stackAfterReplacement));
                }
            });
        } else {
            slots.removeIf(slot -> slot < 0 || slot >= inventoryPower.method_5439());
            slots.forEach(slot -> {
                class_1799 itemStack = inventoryPower.method_5438((int)slot);
                if (itemCondition != null && !itemCondition.test(itemStack)) {
                    return;
                }
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                class_1799 stackAfterReplacement = replacementStack.method_7972();
                if (mergeNbt && itemStack.method_7985()) {
                    itemStack.method_7948().method_10543(stackAfterReplacement.method_7948());
                    stackAfterReplacement.method_7980(itemStack.method_7948());
                }
                inventoryPower.method_5447((int)slot, stackAfterReplacement);
                if (itemAction != null) {
                    itemAction.accept(new class_3545((Object)entity.method_37908(), (Object)stackAfterReplacement));
                }
            });
        }
    }

    public static void dropInventory(SerializableData.Instance data, class_1297 entity, InventoryPower inventoryPower) {
        Set<Integer> slots = InventoryUtil.getSlots(data);
        InventoryUtil.deduplicateSlots(entity, slots);
        int amount = data.getInt("amount");
        boolean throwRandomly = data.getBoolean("throw_randomly");
        boolean retainOwnership = data.getBoolean("retain_ownership");
        Consumer entityAction = (Consumer)data.get("entity_action");
        Predicate itemCondition = (Predicate)data.get("item_condition");
        Consumer itemAction = (Consumer)data.get("item_action");
        if (inventoryPower == null) {
            slots.forEach(slot -> {
                class_5630 stackReference = entity.method_32318(slot.intValue());
                if (stackReference == class_5630.field_27860) {
                    return;
                }
                class_1799 itemStack = stackReference.method_32327();
                if (itemStack.method_7960()) {
                    return;
                }
                if (itemCondition != null && !itemCondition.test(itemStack)) {
                    return;
                }
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                if (itemAction != null) {
                    itemAction.accept(new class_3545((Object)entity.method_37908(), (Object)itemStack));
                }
                if (amount != 0) {
                    int newAmount = amount < 0 ? amount * -1 : amount;
                    class_1799 droppedStack = itemStack.method_7971(newAmount);
                    InventoryUtil.throwItem(entity, droppedStack, throwRandomly, retainOwnership);
                    stackReference.method_32332(itemStack);
                } else {
                    InventoryUtil.throwItem(entity, itemStack, throwRandomly, retainOwnership);
                    stackReference.method_32332(class_1799.field_8037);
                }
            });
        } else {
            slots.removeIf(slot -> slot < 0 || slot >= inventoryPower.method_5439());
            slots.forEach(slot -> {
                class_1799 itemStack = inventoryPower.method_5438((int)slot);
                if (itemStack.method_7960()) {
                    return;
                }
                if (itemCondition != null && !itemCondition.test(itemStack)) {
                    return;
                }
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                if (itemAction != null) {
                    itemAction.accept(new class_3545((Object)entity.method_37908(), (Object)itemStack));
                }
                if (amount != 0) {
                    int newAmount = amount < 0 ? amount * -1 : amount;
                    class_1799 droppedStack = itemStack.method_7971(newAmount);
                    InventoryUtil.throwItem(entity, droppedStack, throwRandomly, retainOwnership);
                    inventoryPower.method_5447((int)slot, itemStack);
                } else {
                    InventoryUtil.throwItem(entity, itemStack, throwRandomly, retainOwnership);
                    inventoryPower.method_5447((int)slot, class_1799.field_8037);
                }
            });
        }
    }

    public static void throwItem(class_1297 thrower, class_1799 itemStack, boolean throwRandomly, boolean retainOwnership) {
        if (itemStack.method_7960()) {
            return;
        }
        if (thrower instanceof class_1657) {
            class_1657 playerEntity = (class_1657)thrower;
            if (playerEntity.method_37908().field_9236) {
                playerEntity.method_6104(class_1268.field_5808);
            }
        }
        double yOffset = thrower.method_23320() - (double)0.3f;
        class_1542 itemEntity = new class_1542(thrower.method_37908(), thrower.method_23317(), yOffset, thrower.method_23321(), itemStack);
        itemEntity.method_6982(40);
        Random random = new Random();
        if (retainOwnership) {
            itemEntity.method_6981(thrower.method_5667());
        }
        if (throwRandomly) {
            float f = random.nextFloat() * 0.5f;
            float g = random.nextFloat() * ((float)Math.PI * 2);
            itemEntity.method_18800((double)(-class_3532.method_15374((float)g) * f), (double)0.2f, (double)(class_3532.method_15362((float)g) * f));
        } else {
            float f = 0.3f;
            float g = class_3532.method_15374((float)(thrower.method_36455() * ((float)Math.PI / 180)));
            float h = class_3532.method_15362((float)(thrower.method_36455() * ((float)Math.PI / 180)));
            float i = class_3532.method_15374((float)(thrower.method_36454() * ((float)Math.PI / 180)));
            float j = class_3532.method_15362((float)(thrower.method_36454() * ((float)Math.PI / 180)));
            float k = random.nextFloat() * ((float)Math.PI * 2);
            float l = 0.02f * random.nextFloat();
            itemEntity.method_18800((double)(-i * h * f) + Math.cos(k) * (double)l, (double)(-g * f + 0.1f + (random.nextFloat() - random.nextFloat()) * 0.1f), (double)(j * h * f) + Math.sin(k) * (double)l);
        }
        thrower.method_37908().method_8649((class_1297)itemEntity);
    }

    public static void forEachStack(class_1297 entity, Consumer<class_1799> itemStackConsumer) {
        int skip = InventoryUtil.getDuplicatedSlotIndex(entity);
        for (int slot : ItemSlotArgumentTypeAccessor.getSlotMappings().values()) {
            class_1799 itemStack;
            if (slot == skip) {
                skip = Integer.MIN_VALUE;
                continue;
            }
            class_5630 stackReference = entity.method_32318(slot);
            if (stackReference == class_5630.field_27860 || (itemStack = stackReference.method_32327()).method_7960()) continue;
            itemStackConsumer.accept(itemStack);
        }
        Optional optionalPowerHolderComponent = PowerHolderComponent.KEY.maybeGet((Object)entity);
        if (optionalPowerHolderComponent.isPresent()) {
            PowerHolderComponent phc = (PowerHolderComponent)optionalPowerHolderComponent.get();
            List<InventoryPower> inventoryPowers = phc.getPowers(InventoryPower.class);
            for (InventoryPower inventoryPower : inventoryPowers) {
                for (int index = 0; index < inventoryPower.method_5439(); ++index) {
                    class_1799 stack = inventoryPower.method_5438(index);
                    if (stack.method_7960()) continue;
                    itemStackConsumer.accept(stack);
                }
            }
        }
    }

    private static void deduplicateSlots(class_1297 entity, Set<Integer> slots) {
        int hotbarSlot = InventoryUtil.getDuplicatedSlotIndex(entity);
        if (hotbarSlot != Integer.MIN_VALUE && slots.contains(hotbarSlot)) {
            Integer mainHandSlot = ItemSlotArgumentTypeAccessor.getSlotMappings().get("weapon.mainhand");
            slots.remove(mainHandSlot);
        }
    }

    private static int getDuplicatedSlotIndex(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            int selectedSlot = player.method_31548().field_7545;
            return ItemSlotArgumentTypeAccessor.getSlotMappings().get("hotbar." + selectedSlot);
        }
        return Integer.MIN_VALUE;
    }

    public static enum ProcessMode {
        STACKS(stack -> 1),
        ITEMS(class_1799::method_7947);

        private final Function<class_1799, Integer> processor;

        private ProcessMode(Function<class_1799, Integer> processor) {
            this.processor = processor;
        }

        public Function<class_1799, Integer> getProcessor() {
            return this.processor;
        }
    }

    public static enum InventoryType {
        INVENTORY,
        POWER;

    }
}

