/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition.bientity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3545;

public class RelativeRotationCondition {
    public static boolean condition(SerializableData.Instance data, class_3545<class_1297, class_1297> pair) {
        RotationType actorRotation = (RotationType)((Object)data.get("actor_rotation"));
        RotationType targetRotation = (RotationType)((Object)data.get("target_rotation"));
        class_243 vec0 = actorRotation.getRotation((class_1297)pair.method_15442());
        class_243 vec1 = targetRotation.getRotation((class_1297)pair.method_15441());
        EnumSet axes = (EnumSet)data.get("axes");
        vec0 = RelativeRotationCondition.reduceAxes(vec0, axes);
        vec1 = RelativeRotationCondition.reduceAxes(vec1, axes);
        double angle = RelativeRotationCondition.getAngleBetween(vec0, vec1);
        Comparison comparison = (Comparison)((Object)data.get("comparison"));
        double compareTo = data.getDouble("compare_to");
        return comparison.compare(angle, compareTo);
    }

    private static double getAngleBetween(class_243 a, class_243 b) {
        double dot = a.method_1026(b);
        return dot / (a.method_1033() * b.method_1033());
    }

    private static class_243 reduceAxes(class_243 vector, EnumSet<class_2350.class_2351> axesToKeep) {
        return new class_243(axesToKeep.contains(class_2350.class_2351.field_11048) ? vector.field_1352 : 0.0, axesToKeep.contains(class_2350.class_2351.field_11052) ? vector.field_1351 : 0.0, axesToKeep.contains(class_2350.class_2351.field_11051) ? vector.field_1350 : 0.0);
    }

    public static ConditionFactory<class_3545<class_1297, class_1297>> getFactory() {
        return new ConditionFactory<class_3545<class_1297, class_1297>>(Apoli.identifier("relative_rotation"), new SerializableData().add("axes", SerializableDataTypes.AXIS_SET, EnumSet.allOf(class_2350.class_2351.class)).add("actor_rotation", SerializableDataType.enumValue(RotationType.class), (Object)RotationType.HEAD).add("target_rotation", SerializableDataType.enumValue(RotationType.class), (Object)RotationType.BODY).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.DOUBLE), RelativeRotationCondition::condition);
    }

    private static class_243 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }

    public static enum RotationType {
        HEAD(e -> e.method_5828(1.0f)),
        BODY(e -> {
            if (e instanceof class_1309) {
                class_1309 l = (class_1309)e;
                return RelativeRotationCondition.getRotationVector(0.0f, l.field_6283);
            }
            return e.method_5828(1.0f);
        });

        private final Function<class_1297, class_243> function;

        private RotationType(Function<class_1297, class_243> function) {
            this.function = function;
        }

        public class_243 getRotation(class_1297 entity) {
            return this.function.apply(entity);
        }
    }
}

