/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.BiomeWeatherAccess;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeConditions {
    public static void register() {
        BiomeConditions.register(new ConditionFactory<class_6880<class_1959>>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, biome) -> data.getBoolean("value")));
        BiomeConditions.register(new ConditionFactory<class_6880<class_1959>>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.BIOME_CONDITIONS), (data, biome) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(biome))));
        BiomeConditions.register(new ConditionFactory<class_6880<class_1959>>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.BIOME_CONDITIONS), (data, biome) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(biome))));
        BiomeConditions.register(new ConditionFactory<class_6880<class_1959>>(Apoli.identifier("high_humidity"), new SerializableData(), (data, biome) -> ((BiomeWeatherAccess)biome.comp_349()).getDownfall() > 0.85f));
        BiomeConditions.register(new ConditionFactory<class_6880<class_1959>>(Apoli.identifier("temperature"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, biome) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(((class_1959)biome.comp_349()).method_8712(), data.getFloat("compare_to"))));
        BiomeConditions.register(new ConditionFactory<class_6880<class_1959>>(Apoli.identifier("category"), new SerializableData().add("category", SerializableDataTypes.STRING), (data, biome) -> {
            class_2960 tagId = Apoli.identifier("category/" + data.getString("category"));
            class_6862 biomeTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tagId);
            return biome.method_40220(biomeTag);
        }));
        BiomeConditions.register(new ConditionFactory<class_6880<class_1959>>(Apoli.identifier("precipitation"), new SerializableData().add("precipitation", SerializableDataType.enumValue(class_1959.class_1963.class)), (data, biome) -> ((class_1959)biome.comp_349()).method_48162(new class_2338(0, 64, 0)).equals(data.get("precipitation"))));
        BiomeConditions.register(new ConditionFactory<class_6880<class_1959>>(Apoli.identifier("in_tag"), new SerializableData().add("tag", SerializableDataTypes.BIOME_TAG), (data, biome) -> {
            class_6862 biomeTag = (class_6862)data.get("tag");
            return biome.method_40220(biomeTag);
        }));
    }

    private static void register(ConditionFactory<class_6880<class_1959>> conditionFactory) {
        class_2378.method_10230(ApoliRegistries.BIOME_CONDITION, (class_2960)conditionFactory.getSerializerId(), conditionFactory);
    }
}

