/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.TogglePower;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.action.entity.AreaOfEffectAction;
import io.github.apace100.apoli.power.factory.action.entity.CraftingTableAction;
import io.github.apace100.apoli.power.factory.action.entity.DamageAction;
import io.github.apace100.apoli.power.factory.action.entity.DropInventoryAction;
import io.github.apace100.apoli.power.factory.action.entity.EnderChestAction;
import io.github.apace100.apoli.power.factory.action.entity.ExplodeAction;
import io.github.apace100.apoli.power.factory.action.entity.FireProjectileAction;
import io.github.apace100.apoli.power.factory.action.entity.GrantAdvancementAction;
import io.github.apace100.apoli.power.factory.action.entity.ModifyDeathTicksAction;
import io.github.apace100.apoli.power.factory.action.entity.ModifyInventoryAction;
import io.github.apace100.apoli.power.factory.action.entity.ModifyResourceAction;
import io.github.apace100.apoli.power.factory.action.entity.ModifyStatAction;
import io.github.apace100.apoli.power.factory.action.entity.RaycastAction;
import io.github.apace100.apoli.power.factory.action.entity.ReplaceInventoryAction;
import io.github.apace100.apoli.power.factory.action.entity.RevokeAdvancementAction;
import io.github.apace100.apoli.power.factory.action.entity.SelectorAction;
import io.github.apace100.apoli.power.factory.action.entity.SpawnEntityAction;
import io.github.apace100.apoli.power.factory.action.entity.SpawnParticlesAction;
import io.github.apace100.apoli.power.factory.action.entity.SwingHandAction;
import io.github.apace100.apoli.power.factory.action.meta.AndAction;
import io.github.apace100.apoli.power.factory.action.meta.ChanceAction;
import io.github.apace100.apoli.power.factory.action.meta.ChoiceAction;
import io.github.apace100.apoli.power.factory.action.meta.DelayAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseListAction;
import io.github.apace100.apoli.power.factory.action.meta.NothingAction;
import io.github.apace100.apoli.power.factory.action.meta.SideAction;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.ResourceOperation;
import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5712;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Vector3f;

public class EntityActions {
    public static void register() {
        EntityActions.register(AndAction.getFactory(ApoliDataTypes.ENTITY_ACTIONS));
        EntityActions.register(ChanceAction.getFactory(ApoliDataTypes.ENTITY_ACTION));
        EntityActions.register(IfElseAction.getFactory(ApoliDataTypes.ENTITY_ACTION, ApoliDataTypes.ENTITY_CONDITION));
        EntityActions.register(ChoiceAction.getFactory(ApoliDataTypes.ENTITY_ACTION));
        EntityActions.register(IfElseListAction.getFactory(ApoliDataTypes.ENTITY_ACTION, ApoliDataTypes.ENTITY_CONDITION));
        EntityActions.register(DelayAction.getFactory(ApoliDataTypes.ENTITY_ACTION));
        EntityActions.register(NothingAction.getFactory());
        EntityActions.register(SideAction.getFactory(ApoliDataTypes.ENTITY_ACTION, entity -> !entity.method_37908().field_9236));
        EntityActions.register(DamageAction.getFactory());
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("heal"), new SerializableData().add("amount", SerializableDataTypes.FLOAT), (data, entity) -> {
            if (entity instanceof class_1309) {
                ((class_1309)entity).method_6025(data.getFloat("amount"));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("play_sound"), new SerializableData().add("sound", SerializableDataTypes.SOUND_EVENT).add("volume", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("pitch", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)), (data, entity) -> {
            class_3419 category = entity instanceof class_1657 ? class_3419.field_15248 : (entity instanceof class_1588 ? class_3419.field_15251 : class_3419.field_15254);
            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)data.get("sound"), category, data.getFloat("volume"), data.getFloat("pitch"));
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("exhaust"), new SerializableData().add("amount", SerializableDataTypes.FLOAT), (data, entity) -> {
            if (entity instanceof class_1657) {
                ((class_1657)entity).method_7344().method_7583(data.getFloat("amount"));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("apply_effect"), new SerializableData().add("effect", SerializableDataTypes.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataTypes.STATUS_EFFECT_INSTANCES, null), (data, entity) -> {
            if (entity instanceof class_1309) {
                class_1309 le = (class_1309)entity;
                if (!entity.method_37908().field_9236) {
                    if (data.isPresent("effect")) {
                        class_1293 effect = (class_1293)data.get("effect");
                        le.method_6092(new class_1293(effect));
                    }
                    if (data.isPresent("effects")) {
                        ((List)data.get("effects")).forEach(e -> le.method_6092(new class_1293(e)));
                    }
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("clear_effect"), new SerializableData().add("effect", SerializableDataTypes.STATUS_EFFECT, null), (data, entity) -> {
            if (entity instanceof class_1309) {
                class_1309 le = (class_1309)entity;
                if (data.isPresent("effect")) {
                    le.method_6016((class_1291)data.get("effect"));
                } else {
                    le.method_6012();
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("set_on_fire"), new SerializableData().add("duration", SerializableDataTypes.INT), (data, entity) -> entity.method_5639(data.getInt("duration"))));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("add_velocity"), new SerializableData().add("x", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("y", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("z", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("space", ApoliDataTypes.SPACE, (Object)Space.WORLD).add("client", SerializableDataTypes.BOOLEAN, (Object)true).add("server", SerializableDataTypes.BOOLEAN, (Object)true).add("set", SerializableDataTypes.BOOLEAN, (Object)false), (data, entity) -> {
            if (entity instanceof class_1657 && (entity.method_37908().field_9236 ? !data.getBoolean("client") : !data.getBoolean("server"))) {
                return;
            }
            Space space = (Space)((Object)((Object)data.get("space")));
            Vector3f vec = new Vector3f(data.getFloat("x"), data.getFloat("y"), data.getFloat("z"));
            TriConsumer method = (arg_0, arg_1, arg_2) -> ((class_1297)entity).method_5762(arg_0, arg_1, arg_2);
            if (data.getBoolean("set")) {
                method = (arg_0, arg_1, arg_2) -> ((class_1297)entity).method_18800(arg_0, arg_1, arg_2);
            }
            space.toGlobal(vec, (class_1297)entity);
            method.accept((Object)Float.valueOf(vec.x), (Object)Float.valueOf(vec.y), (Object)Float.valueOf(vec.z));
            entity.field_6037 = true;
        }));
        EntityActions.register(SpawnEntityAction.getFactory());
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("gain_air"), new SerializableData().add("value", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof class_1309) {
                class_1309 le = (class_1309)entity;
                le.method_5855(Math.min(le.method_5669() + data.getInt("value"), le.method_5748()));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("block_action_at"), new SerializableData().add("block_action", ApoliDataTypes.BLOCK_ACTION), (data, entity) -> ((ActionFactory.Instance)data.get("block_action")).accept(Triple.of((Object)entity.method_37908(), (Object)entity.method_24515(), (Object)class_2350.field_11036))));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("spawn_effect_cloud"), new SerializableData().add("radius", SerializableDataTypes.FLOAT, (Object)Float.valueOf(3.0f)).add("radius_on_use", SerializableDataTypes.FLOAT, (Object)Float.valueOf(-0.5f)).add("wait_time", SerializableDataTypes.INT, (Object)10).add("effect", SerializableDataTypes.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataTypes.STATUS_EFFECT_INSTANCES, null), (data, entity) -> {
            class_1295 areaEffectCloudEntity = new class_1295(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321());
            if (entity instanceof class_1309) {
                areaEffectCloudEntity.method_5607((class_1309)entity);
            }
            areaEffectCloudEntity.method_5603(data.getFloat("radius"));
            areaEffectCloudEntity.method_5609(data.getFloat("radius_on_use"));
            areaEffectCloudEntity.method_5595(data.getInt("wait_time"));
            areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
            LinkedList<class_1293> effects = new LinkedList<class_1293>();
            if (data.isPresent("effect")) {
                effects.add((class_1293)data.get("effect"));
            }
            if (data.isPresent("effects")) {
                effects.addAll((Collection)data.get("effects"));
            }
            areaEffectCloudEntity.method_5602(class_1844.method_8055(effects));
            effects.forEach(arg_0 -> ((class_1295)areaEffectCloudEntity).method_5610(arg_0));
            entity.method_37908().method_8649((class_1297)areaEffectCloudEntity);
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("extinguish"), new SerializableData(), (data, entity) -> entity.method_5646()));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("execute_command"), new SerializableData().add("command", SerializableDataTypes.STRING), (data, entity) -> {
            MinecraftServer server = entity.method_37908().method_8503();
            if (server != null) {
                boolean validOutput = !(entity instanceof class_3222) || ((class_3222)entity).field_13987 != null;
                class_2168 source = new class_2168((class_2165)(Apoli.config.executeCommand.showOutput && validOutput ? entity : class_2165.field_17395), entity.method_19538(), entity.method_5802(), entity.method_37908() instanceof class_3218 ? (class_3218)entity.method_37908() : null, Apoli.config.executeCommand.permissionLevel, entity.method_5477().getString(), entity.method_5476(), entity.method_37908().method_8503(), entity);
                server.method_3734().method_44252(source, data.getString("command"));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("change_resource"), new SerializableData().add("resource", ApoliDataTypes.POWER_TYPE).add("change", SerializableDataTypes.INT).add("operation", ApoliDataTypes.RESOURCE_OPERATION, (Object)ResourceOperation.ADD), (data, entity) -> {
            if (entity instanceof class_1309) {
                PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get(entity);
                PowerType powerType = (PowerType)data.get("resource");
                Object p = component.getPower(powerType);
                ResourceOperation operation = (ResourceOperation)((Object)((Object)data.get("operation")));
                int change = data.getInt("change");
                if (p instanceof VariableIntPower) {
                    VariableIntPower vip = (VariableIntPower)p;
                    if (operation == ResourceOperation.ADD) {
                        int newValue = vip.getValue() + change;
                        vip.setValue(newValue);
                    } else if (operation == ResourceOperation.SET) {
                        vip.setValue(change);
                    }
                    PowerHolderComponent.syncPower(entity, powerType);
                } else if (p instanceof CooldownPower) {
                    CooldownPower cp = (CooldownPower)p;
                    if (operation == ResourceOperation.ADD) {
                        cp.modify(change);
                    } else if (operation == ResourceOperation.SET) {
                        cp.setCooldown(change);
                    }
                    PowerHolderComponent.syncPower(entity, powerType);
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("feed"), new SerializableData().add("food", SerializableDataTypes.INT).add("saturation", SerializableDataTypes.FLOAT), (data, entity) -> {
            if (entity instanceof class_1657) {
                ((class_1657)entity).method_7344().method_7585(data.getInt("food"), data.getFloat("saturation"));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("add_xp"), new SerializableData().add("points", SerializableDataTypes.INT, (Object)0).add("levels", SerializableDataTypes.INT, (Object)0), (data, entity) -> {
            if (entity instanceof class_1657) {
                int points = data.getInt("points");
                int levels = data.getInt("levels");
                if (points > 0) {
                    ((class_1657)entity).method_7255(points);
                }
                ((class_1657)entity).method_7316(levels);
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("set_fall_distance"), new SerializableData().add("fall_distance", SerializableDataTypes.FLOAT), (data, entity) -> {
            entity.field_6017 = data.getFloat("fall_distance");
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("give"), new SerializableData().add("stack", SerializableDataTypes.ITEM_STACK).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("preferred_slot", SerializableDataTypes.EQUIPMENT_SLOT, null), (data, entity) -> {
            if (!entity.method_37908().method_8608()) {
                class_1799 stack = (class_1799)data.get("stack");
                if (stack.method_7960()) {
                    return;
                }
                stack = stack.method_7972();
                if (data.isPresent("item_action")) {
                    ActionFactory.Instance action = (ActionFactory.Instance)data.get("item_action");
                    action.accept(new class_3545((Object)entity.method_37908(), (Object)stack));
                }
                if (data.isPresent("preferred_slot") && entity instanceof class_1309) {
                    class_1309 living = (class_1309)entity;
                    class_1304 slot = (class_1304)data.get("preferred_slot");
                    class_1799 stackInSlot = living.method_6118(slot);
                    if (stackInSlot.method_7960()) {
                        living.method_5673(slot, stack);
                        return;
                    }
                    if (class_1799.method_31577((class_1799)stackInSlot, (class_1799)stack) && stackInSlot.method_7947() < stackInSlot.method_7914()) {
                        int fit = Math.min(stackInSlot.method_7914() - stackInSlot.method_7947(), stack.method_7947());
                        stackInSlot.method_7933(fit);
                        stack.method_7934(fit);
                        if (stack.method_7960()) {
                            return;
                        }
                    }
                }
                if (entity instanceof class_1657) {
                    ((class_1657)entity).method_31548().method_7398(stack);
                } else {
                    entity.method_37908().method_8649((class_1297)new class_1542(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), stack));
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("equipped_item_action"), new SerializableData().add("equipment_slot", SerializableDataTypes.EQUIPMENT_SLOT).add("action", ApoliDataTypes.ITEM_ACTION), (data, entity) -> {
            if (entity instanceof class_1309) {
                class_1799 stack = ((class_1309)entity).method_6118((class_1304)data.get("equipment_slot"));
                ActionFactory.Instance action = (ActionFactory.Instance)data.get("action");
                action.accept(new class_3545((Object)entity.method_37908(), (Object)stack));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("trigger_cooldown"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE), (data, entity) -> {
            PowerHolderComponent component;
            Object p;
            if (entity instanceof class_1309 && (p = (component = (PowerHolderComponent)PowerHolderComponent.KEY.get(entity)).getPower((PowerType)data.get("power"))) instanceof CooldownPower) {
                CooldownPower cp = (CooldownPower)p;
                cp.use();
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("toggle"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE), (data, entity) -> {
            PowerHolderComponent component;
            Object p;
            if (entity instanceof class_1309 && (p = (component = (PowerHolderComponent)PowerHolderComponent.KEY.get(entity)).getPower((PowerType)data.get("power"))) instanceof TogglePower) {
                ((TogglePower)p).onUse();
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("emit_game_event"), new SerializableData().add("event", SerializableDataTypes.GAME_EVENT), (data, entity) -> entity.method_32876((class_5712)data.get("event"))));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("set_resource"), new SerializableData().add("resource", ApoliDataTypes.POWER_TYPE).add("value", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof class_1309) {
                PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get(entity);
                PowerType powerType = (PowerType)data.get("resource");
                Object p = component.getPower(powerType);
                int value = data.getInt("value");
                if (p instanceof VariableIntPower) {
                    VariableIntPower vip = (VariableIntPower)p;
                    vip.setValue(value);
                    PowerHolderComponent.syncPower(entity, powerType);
                } else if (p instanceof CooldownPower) {
                    CooldownPower cp = (CooldownPower)p;
                    cp.setCooldown(value);
                    PowerHolderComponent.syncPower(entity, powerType);
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("grant_power"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE).add("source", SerializableDataTypes.IDENTIFIER), (data, entity) -> PowerHolderComponent.KEY.maybeGet(entity).ifPresent(component -> {
            component.addPower((PowerType)data.get("power"), data.getId("source"));
            component.sync();
        })));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("revoke_power"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE).add("source", SerializableDataTypes.IDENTIFIER), (data, entity) -> PowerHolderComponent.KEY.maybeGet(entity).ifPresent(component -> {
            component.removePower((PowerType)data.get("power"), data.getId("source"));
            component.sync();
        })));
        EntityActions.register(ExplodeAction.getFactory());
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("dismount"), new SerializableData(), (data, entity) -> entity.method_5848()));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("passenger_action"), new SerializableData().add("action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("recursive", SerializableDataTypes.BOOLEAN, (Object)false), (data, entity) -> {
            Consumer entityAction = (Consumer)data.get("action");
            Consumer bientityAction = (Consumer)data.get("bientity_action");
            Predicate cond = (Predicate)data.get("bientity_condition");
            if (!entity.method_5782() || entityAction == null && bientityAction == null) {
                return;
            }
            Iterable passengers = data.getBoolean("recursive") ? entity.method_5736() : entity.method_5685();
            for (class_1297 passenger : passengers) {
                if (cond != null && !cond.test(new class_3545((Object)passenger, entity))) continue;
                if (entityAction != null) {
                    entityAction.accept(passenger);
                }
                if (bientityAction == null) continue;
                bientityAction.accept(new class_3545((Object)passenger, entity));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Apoli.identifier("riding_action"), new SerializableData().add("action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("recursive", SerializableDataTypes.BOOLEAN, (Object)false), (data, entity) -> {
            Consumer entityAction = (Consumer)data.get("action");
            Consumer bientityAction = (Consumer)data.get("bientity_action");
            Predicate cond = (Predicate)data.get("bientity_condition");
            if (!entity.method_5765() || entityAction == null && bientityAction == null) {
                return;
            }
            if (data.getBoolean("recursive")) {
                for (class_1297 vehicle = entity.method_5854(); vehicle != null; vehicle = vehicle.method_5854()) {
                    if (cond != null && !cond.test(new class_3545(entity, (Object)vehicle))) continue;
                    if (entityAction != null) {
                        entityAction.accept(vehicle);
                    }
                    if (bientityAction == null) continue;
                    bientityAction.accept(new class_3545(entity, (Object)vehicle));
                }
            } else {
                class_1297 vehicle = entity.method_5854();
                if (cond == null || cond.test(new class_3545(entity, (Object)vehicle))) {
                    if (entityAction != null) {
                        entityAction.accept(vehicle);
                    }
                    if (bientityAction != null) {
                        bientityAction.accept(new class_3545(entity, (Object)vehicle));
                    }
                }
            }
        }));
        EntityActions.register(AreaOfEffectAction.getFactory());
        EntityActions.register(CraftingTableAction.getFactory());
        EntityActions.register(EnderChestAction.getFactory());
        EntityActions.register(SwingHandAction.getFactory());
        EntityActions.register(RaycastAction.getFactory());
        EntityActions.register(SpawnParticlesAction.getFactory());
        EntityActions.register(ModifyInventoryAction.getFactory());
        EntityActions.register(ReplaceInventoryAction.getFactory());
        EntityActions.register(DropInventoryAction.getFactory());
        EntityActions.register(ModifyDeathTicksAction.getFactory());
        EntityActions.register(ModifyResourceAction.getFactory());
        EntityActions.register(ModifyStatAction.getFactory());
        EntityActions.register(FireProjectileAction.getFactory());
        EntityActions.register(SelectorAction.getFactory());
        EntityActions.register(GrantAdvancementAction.getFactory());
        EntityActions.register(RevokeAdvancementAction.getFactory());
    }

    private static void register(ActionFactory<class_1297> actionFactory) {
        class_2378.method_10230(ApoliRegistries.ENTITY_ACTION, (class_2960)actionFactory.getSerializerId(), actionFactory);
    }
}

