/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class TooltipPower
extends Power {
    private final Predicate<class_1799> itemCondition;
    private final List<class_2561> texts = new LinkedList<class_2561>();
    private final int order;

    public TooltipPower(PowerType<?> type, class_1309 entity, Predicate<class_1799> itemCondition, int order) {
        super(type, entity);
        this.itemCondition = itemCondition;
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void addText(class_2561 text) {
        this.texts.add(text);
    }

    public void addToTooltip(List<class_2561> tooltip) {
        tooltip.addAll(this.texts);
    }

    public boolean doesApply(class_1799 stack) {
        return this.itemCondition == null || this.itemCondition.test(stack);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("tooltip"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("text", SerializableDataTypes.TEXT, null).add("texts", SerializableDataType.list((SerializableDataType)SerializableDataTypes.TEXT), null).add("order", SerializableDataTypes.INT, (Object)0), data -> (type, player) -> {
            TooltipPower ttp = new TooltipPower((PowerType<?>)type, (class_1309)player, data.isPresent("item_condition") ? (Predicate)data.get("item_condition") : null, (Integer)data.get("order"));
            data.ifPresent("text", ttp::addText);
            data.ifPresent("texts", t -> t.forEach(ttp::addText));
            return ttp;
        }).allowCondition();
    }
}

