/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.StatusEffectPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2497;
import net.minecraft.class_2520;

public class StackingStatusEffectPower
extends StatusEffectPower {
    private final int minStack;
    private final int maxStack;
    private final int durationPerStack;
    private final int tickRate;
    private int currentStack;

    public StackingStatusEffectPower(PowerType<?> type, class_1309 entity, int minStack, int maxStack, int durationPerStack, int tickRate) {
        super(type, entity);
        this.minStack = minStack;
        this.maxStack = maxStack;
        this.durationPerStack = durationPerStack;
        this.tickRate = tickRate;
        this.setTicking(true);
    }

    @Override
    public void tick() {
        if (this.entity.field_6012 % this.tickRate == 0) {
            if (this.isActive()) {
                ++this.currentStack;
                if (this.currentStack > this.maxStack) {
                    this.currentStack = this.maxStack;
                }
                if (this.currentStack > 0) {
                    this.applyEffects();
                }
            } else {
                --this.currentStack;
                if (this.currentStack < this.minStack) {
                    this.currentStack = this.minStack;
                }
            }
        }
    }

    @Override
    public void applyEffects() {
        this.effects.forEach(sei -> {
            int duration = this.durationPerStack * this.currentStack;
            if (duration > 0) {
                class_1293 applySei = new class_1293(sei.method_5579(), duration, sei.method_5578(), sei.method_5591(), sei.method_5581(), sei.method_5592());
                this.entity.method_6092(applySei);
            }
        });
    }

    @Override
    public class_2520 toTag() {
        return class_2497.method_23247((int)this.currentStack);
    }

    @Override
    public void fromTag(class_2520 tag) {
        this.currentStack = ((class_2497)tag).method_10701();
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("stacking_status_effect"), new SerializableData().add("min_stacks", SerializableDataTypes.INT).add("max_stacks", SerializableDataTypes.INT).add("duration_per_stack", SerializableDataTypes.INT).add("tick_rate", SerializableDataTypes.INT, (Object)10).add("effect", SerializableDataTypes.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataTypes.STATUS_EFFECT_INSTANCES, null), data -> (type, player) -> {
            StackingStatusEffectPower power = new StackingStatusEffectPower((PowerType<?>)type, (class_1309)player, data.getInt("min_stacks"), data.getInt("max_stacks"), data.getInt("duration_per_stack"), data.getInt("tick_rate"));
            if (data.isPresent("effect")) {
                power.addEffect((class_1293)data.get("effect"));
            }
            if (data.isPresent("effects")) {
                ((List)data.get("effects")).forEach(power::addEffect);
            }
            return power;
        }).allowCondition();
    }
}

