/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.IdentifiedLootTable;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.ClassUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_52;

public class ReplaceLootTablePower
extends Power {
    public static final class_2960 REPLACED_TABLE_UTIL_ID = new class_2960("apoli", "replaced_loot_table");
    public static class_2960 LAST_REPLACED_TABLE_ID;
    private static Stack<class_52> REPLACEMENT_STACK;
    private static Stack<class_52> BACKTRACK_STACK;
    private final Map<String, class_2960> replacements;
    private final int priority;
    private final Predicate<class_1799> itemCondition;
    private final Predicate<class_3545<class_1297, class_1297>> biEntityCondition;
    private final Predicate<class_2694> blockCondition;
    private static final SerializableDataType<Map<String, class_2960>> REPLACEMENTS_DATA_TYPE;

    public ReplaceLootTablePower(PowerType<?> type, class_1309 entity, Map<String, class_2960> replacements, int priority, Predicate<class_1799> itemCondition, Predicate<class_3545<class_1297, class_1297>> biEntityCondition, Predicate<class_2694> blockCondition) {
        super(type, entity);
        this.replacements = replacements;
        this.priority = priority;
        this.itemCondition = itemCondition;
        this.biEntityCondition = biEntityCondition;
        this.blockCondition = blockCondition;
    }

    public boolean hasReplacement(class_2960 id) {
        String idString = id.toString();
        if (this.replacements.containsKey(idString)) {
            return true;
        }
        return this.replacements.keySet().stream().anyMatch(idString::matches);
    }

    public boolean doesApply(class_47 lootContext) {
        if (this.biEntityCondition != null && !this.biEntityCondition.test((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)((class_1297)lootContext.method_296(class_181.field_1226))))) {
            return false;
        }
        if (this.itemCondition != null && lootContext.method_300(class_181.field_1229) && !this.itemCondition.test((class_1799)lootContext.method_296(class_181.field_1229))) {
            return false;
        }
        if (this.blockCondition != null && lootContext.method_300(class_181.field_24424)) {
            class_2338 blockPos = class_2338.method_49638((class_2374)((class_2374)lootContext.method_296(class_181.field_24424)));
            class_2694 cbp = new class_2694((class_4538)lootContext.method_299(), blockPos, true);
            if (!this.blockCondition.test(cbp)) {
                return false;
            }
        }
        return true;
    }

    public class_2960 getReplacement(class_2960 id) {
        String idString = id.toString();
        if (this.replacements.containsKey(idString)) {
            return this.replacements.get(idString);
        }
        Set<String> keys = this.replacements.keySet();
        for (String s : keys) {
            if (!idString.matches(s)) continue;
            return this.replacements.get(s);
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public static void clearStack() {
        REPLACEMENT_STACK.clear();
        BACKTRACK_STACK.clear();
    }

    public static void addToStack(class_52 lootTable) {
        REPLACEMENT_STACK.add(lootTable);
    }

    public static class_52 pop() {
        if (REPLACEMENT_STACK.isEmpty()) {
            return class_52.field_948;
        }
        class_52 table = REPLACEMENT_STACK.pop();
        BACKTRACK_STACK.push(table);
        return table;
    }

    public static class_52 restore() {
        if (BACKTRACK_STACK.isEmpty()) {
            return class_52.field_948;
        }
        class_52 table = BACKTRACK_STACK.pop();
        REPLACEMENT_STACK.push(table);
        return table;
    }

    public static class_52 peek() {
        if (REPLACEMENT_STACK.isEmpty()) {
            return class_52.field_948;
        }
        return REPLACEMENT_STACK.peek();
    }

    private static void printStacks() {
        class_52 t;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int count = 0;
        while (!REPLACEMENT_STACK.isEmpty()) {
            t = ReplaceLootTablePower.pop();
            stringBuilder.append((Object)(t == null ? "null" : ((IdentifiedLootTable)t).getId()));
            if (!REPLACEMENT_STACK.isEmpty()) {
                stringBuilder.append(", ");
            }
            ++count;
        }
        stringBuilder.append("], [");
        while (count > 0) {
            ReplaceLootTablePower.restore();
            --count;
        }
        while (BACKTRACK_STACK.size() > 0) {
            t = ReplaceLootTablePower.restore();
            stringBuilder.append((Object)(t == null ? "null" : ((IdentifiedLootTable)t).getId()));
            if (!BACKTRACK_STACK.isEmpty()) {
                stringBuilder.append(", ");
            }
            ++count;
        }
        while (count > 0) {
            ReplaceLootTablePower.pop();
            --count;
        }
        stringBuilder.append("]");
        Apoli.LOGGER.info(stringBuilder.toString());
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(new class_2960("apoli", "replace_loot_table"), new SerializableData().add("replace", REPLACEMENTS_DATA_TYPE).add("priority", SerializableDataTypes.INT, (Object)0).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null), data -> (type, player) -> new ReplaceLootTablePower((PowerType<?>)type, (class_1309)player, (Map)data.get("replace"), (Integer)data.get("priority"), (Predicate)data.get("item_condition"), (Predicate)data.get("bientity_condition"), (Predicate)data.get("block_condition"))).allowCondition();
    }

    static {
        REPLACEMENT_STACK = new Stack();
        BACKTRACK_STACK = new Stack();
        REPLACEMENTS_DATA_TYPE = new SerializableDataType(ClassUtil.castClass(Map.class), (packetByteBuf, stringIdentifierMap) -> {
            packetByteBuf.writeInt(stringIdentifierMap.size());
            stringIdentifierMap.forEach((s, identifier) -> {
                packetByteBuf.method_10814(s);
                packetByteBuf.method_10812(identifier);
            });
        }, packetByteBuf -> {
            int count = packetByteBuf.readInt();
            LinkedHashMap<String, class_2960> map = new LinkedHashMap<String, class_2960>();
            for (int i = 0; i < count; ++i) {
                String s = packetByteBuf.method_19772();
                class_2960 id = packetByteBuf.method_10810();
                map.put(s, id);
            }
            return map;
        }, jsonElement -> {
            if (jsonElement.isJsonObject()) {
                JsonObject jo = jsonElement.getAsJsonObject();
                LinkedHashMap<String, class_2960> map = new LinkedHashMap<String, class_2960>();
                for (String s : jo.keySet()) {
                    JsonPrimitive jp;
                    JsonElement ele = jo.get(s);
                    if (!ele.isJsonPrimitive() || !(jp = ele.getAsJsonPrimitive()).isString()) continue;
                    class_2960 id = new class_2960(jp.getAsString());
                    map.put(s, id);
                }
                return map;
            }
            throw new JsonParseException("Expected a JSON object");
        });
    }
}

