/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.InteractionPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3545;

public class PreventEntityUsePower
extends InteractionPower {
    private final Consumer<class_3545<class_1297, class_1297>> biEntityAction;
    private final Predicate<class_3545<class_1297, class_1297>> bientityCondition;

    public PreventEntityUsePower(PowerType<?> type, class_1309 entity, EnumSet<class_1268> hands, class_1269 actionResult, Predicate<class_1799> itemCondition, Consumer<class_3545<class_1937, class_1799>> heldItemAction, class_1799 itemResult, Consumer<class_3545<class_1937, class_1799>> itemAction, Consumer<class_3545<class_1297, class_1297>> biEntityAction, Predicate<class_3545<class_1297, class_1297>> bientityCondition) {
        super(type, entity, hands, actionResult, itemCondition, heldItemAction, itemResult, itemAction);
        this.biEntityAction = biEntityAction;
        this.bientityCondition = bientityCondition;
    }

    public boolean doesApply(class_1297 other, class_1268 hand, class_1799 heldStack) {
        if (!this.shouldExecute(hand, heldStack)) {
            return false;
        }
        return this.bientityCondition == null || this.bientityCondition.test((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)other));
    }

    public class_1269 executeAction(class_1297 other, class_1268 hand) {
        if (this.biEntityAction != null) {
            this.biEntityAction.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)other));
        }
        this.performActorItemStuff(this, (class_1657)this.entity, hand);
        return this.getActionResult();
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("prevent_entity_use"), new SerializableData().add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("hands", SerializableDataTypes.HAND_SET, EnumSet.allOf(class_1268.class)).add("result_stack", SerializableDataTypes.ITEM_STACK, null).add("held_item_action", ApoliDataTypes.ITEM_ACTION, null).add("result_item_action", ApoliDataTypes.ITEM_ACTION, null), data -> (type, player) -> new PreventEntityUsePower((PowerType<?>)type, (class_1309)player, (EnumSet)data.get("hands"), class_1269.field_5814, (Predicate)data.get("item_condition"), (Consumer)data.get("held_item_action"), (class_1799)data.get("result_stack"), (Consumer)data.get("result_item_action"), (Consumer)data.get("bientity_action"), (ConditionFactory.Instance)data.get("bientity_condition"))).allowCondition();
    }
}

