/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.integration.AdditionalPowerDataCallback;
import io.github.apace100.apoli.integration.PostPowerLoadCallback;
import io.github.apace100.apoli.integration.PostPowerReloadCallback;
import io.github.apace100.apoli.integration.PowerReloadCallback;
import io.github.apace100.apoli.integration.PrePowerLoadCallback;
import io.github.apace100.apoli.integration.PrePowerReloadCallback;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.ApoliResourceConditions;
import io.github.apace100.apoli.util.NamespaceAlias;
import io.github.apace100.calio.data.MultiJsonDataLoader;
import io.github.apace100.calio.data.SerializableData;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import org.jetbrains.annotations.Nullable;

public class PowerTypes
extends MultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    public static final Set<class_2960> DEPENDENCIES = new HashSet<class_2960>();
    public static final Set<String> LOADED_NAMESPACES = new HashSet<String>();
    private static final class_2960 MULTIPLE = Apoli.identifier("multiple");
    private static final class_2960 SIMPLE = Apoli.identifier("simple");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final HashMap<class_2960, Integer> LOADING_PRIORITIES = new HashMap();
    private static final HashMap<String, AdditionalPowerDataCallback> ADDITIONAL_DATA = new HashMap();

    public PowerTypes() {
        super(GSON, "powers");
    }

    protected void apply(Map<class_2960, List<JsonElement>> loader, class_3300 manager, class_3695 profiler) {
        PowerTypeRegistry.reset();
        LOADING_PRIORITIES.clear();
        LOADED_NAMESPACES.clear();
        LOADED_NAMESPACES.addAll(manager.method_14487());
        ((PowerReloadCallback)PowerReloadCallback.EVENT.invoker()).onPowerReload();
        ((PrePowerReloadCallback)PrePowerReloadCallback.EVENT.invoker()).onPrePowerReload();
        loader.forEach((id, jel) -> {
            for (JsonElement je : jel) {
                try {
                    SerializableData.CURRENT_NAMESPACE = id.method_12836();
                    SerializableData.CURRENT_PATH = id.method_12832();
                    JsonObject jo = je.getAsJsonObject();
                    ((PrePowerLoadCallback)PrePowerLoadCallback.EVENT.invoker()).onPrePowerLoad((class_2960)id, jo);
                    class_2960 factoryId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jo, (String)"type"));
                    if (this.isMultiple(factoryId)) {
                        LinkedList<class_2960> subPowers = new LinkedList<class_2960>();
                        for (Map.Entry entry : jo.entrySet()) {
                            if (((String)entry.getKey()).equals("type") || ((String)entry.getKey()).equals("loading_priority") || ((String)entry.getKey()).equals("name") || ((String)entry.getKey()).equals("description") || ((String)entry.getKey()).equals("hidden") || ((String)entry.getKey()).equals("condition") || ((String)entry.getKey()).startsWith("$") || ADDITIONAL_DATA.containsKey(entry.getKey()) || ((String)entry.getKey()).equals("fabric:load_conditions")) continue;
                            class_2960 subId = new class_2960(String.valueOf(id) + "_" + (String)entry.getKey());
                            try {
                                PowerType subPower = this.readPower(subId, (JsonElement)entry.getValue(), true);
                                if (subPower == null) continue;
                                subPowers.add(subId);
                            }
                            catch (Exception e) {
                                Apoli.LOGGER.error("There was a problem reading sub-power \"" + String.valueOf(subId) + "\" in power file \"" + String.valueOf(id) + "\": " + e.getMessage());
                            }
                        }
                        MultiplePowerType superPower = (MultiplePowerType)this.readPower((class_2960)id, je, false, MultiplePowerType::new);
                        if (superPower != null) {
                            superPower.setSubPowers(subPowers);
                        } else {
                            subPowers.forEach(PowerTypeRegistry::disable);
                        }
                        this.handleAdditionalData((class_2960)id, factoryId, false, jo, superPower);
                        ((PostPowerLoadCallback)PostPowerLoadCallback.EVENT.invoker()).onPostPowerLoad((class_2960)id, factoryId, false, jo, superPower);
                        continue;
                    }
                    this.readPower((class_2960)id, je, false);
                }
                catch (Exception e) {
                    Apoli.LOGGER.error("There was a problem reading power file " + id.toString() + " (skipping): " + e.getMessage());
                }
            }
        });
        ((PostPowerReloadCallback)PostPowerReloadCallback.EVENT.invoker()).onPostPowerReload();
        LOADING_PRIORITIES.clear();
        LOADED_NAMESPACES.clear();
        SerializableData.CURRENT_NAMESPACE = null;
        SerializableData.CURRENT_PATH = null;
        Apoli.LOGGER.info("Finished loading powers from data files. Registry contains " + PowerTypeRegistry.size() + " powers.");
    }

    private boolean isResourceConditionValid(class_2960 id, JsonObject jo) {
        return ApoliResourceConditions.test(id, jo);
    }

    @Nullable
    private PowerType readPower(class_2960 id, JsonElement je, boolean isSubPower) {
        return this.readPower(id, je, isSubPower, PowerType::new);
    }

    @Nullable
    private PowerType readPower(class_2960 id, JsonElement je, boolean isSubPower, BiFunction<class_2960, PowerFactory.Instance, PowerType> powerTypeFactory) {
        Optional optionalFactory;
        JsonObject jo = je.getAsJsonObject();
        class_2960 factoryId = new class_2960(class_3518.method_15265((JsonObject)jo, (String)"type"));
        int priority = class_3518.method_15282((JsonObject)jo, (String)"loading_priority", (int)0);
        if (!this.isResourceConditionValid(id, jo)) {
            if (!PowerTypeRegistry.contains(id)) {
                PowerTypeRegistry.disable(id);
            }
            return null;
        }
        if (this.isMultiple(factoryId)) {
            factoryId = SIMPLE;
            if (isSubPower) {
                throw new JsonSyntaxException("Power type \"" + String.valueOf(MULTIPLE) + "\" may not be used for a sub-power of another \"" + String.valueOf(MULTIPLE) + "\" power.");
            }
        }
        if ((optionalFactory = ApoliRegistries.POWER_FACTORY.method_17966(factoryId)).isEmpty()) {
            if (NamespaceAlias.hasAlias(factoryId)) {
                optionalFactory = ApoliRegistries.POWER_FACTORY.method_17966(NamespaceAlias.resolveAlias(factoryId));
            }
            if (optionalFactory.isEmpty()) {
                throw new JsonSyntaxException("Power type \"" + String.valueOf(factoryId) + "\" is not defined.");
            }
        }
        PowerFactory.Instance factoryInstance = ((PowerFactory)optionalFactory.get()).read(jo);
        PowerType type = powerTypeFactory.apply(id, factoryInstance);
        String name = class_3518.method_15253((JsonObject)jo, (String)"name", (String)"");
        String description = class_3518.method_15253((JsonObject)jo, (String)"description", (String)"");
        boolean hidden = class_3518.method_15258((JsonObject)jo, (String)"hidden", (boolean)false);
        if (hidden || isSubPower) {
            type.setHidden();
        }
        type.setTranslationKeys(name, description);
        if (!PowerTypeRegistry.contains(id)) {
            PowerTypeRegistry.register(id, type);
            LOADING_PRIORITIES.put(id, priority);
            if (!(type instanceof MultiplePowerType)) {
                this.handleAdditionalData(id, factoryId, isSubPower, jo, type);
                ((PostPowerLoadCallback)PostPowerLoadCallback.EVENT.invoker()).onPostPowerLoad(id, factoryId, isSubPower, jo, type);
            }
        } else if (LOADING_PRIORITIES.get(id) < priority) {
            PowerTypeRegistry.update(id, type);
            LOADING_PRIORITIES.put(id, priority);
            if (!(type instanceof MultiplePowerType)) {
                this.handleAdditionalData(id, factoryId, isSubPower, jo, type);
                ((PostPowerLoadCallback)PostPowerLoadCallback.EVENT.invoker()).onPostPowerLoad(id, factoryId, isSubPower, jo, type);
            }
        }
        return type;
    }

    private boolean isMultiple(class_2960 id) {
        if (MULTIPLE.equals((Object)id)) {
            return true;
        }
        if (NamespaceAlias.hasAlias(id)) {
            return MULTIPLE.equals((Object)NamespaceAlias.resolveAlias(id));
        }
        return false;
    }

    private void handleAdditionalData(class_2960 powerId, class_2960 factoryId, boolean isSubPower, JsonObject json, PowerType<?> powerType) {
        ADDITIONAL_DATA.forEach((dataFieldName, callback) -> {
            if (json.has(dataFieldName)) {
                callback.readAdditionalPowerData(powerId, factoryId, isSubPower, json.get(dataFieldName), powerType);
            }
        });
    }

    public class_2960 getFabricId() {
        return new class_2960("apoli", "powers");
    }

    public static void registerAdditionalData(String data, AdditionalPowerDataCallback callback) {
        if (ADDITIONAL_DATA.containsKey(data)) {
            Apoli.LOGGER.error("Apoli already contains a callback for additional data for the field \"" + data + "\".");
            return;
        }
        ADDITIONAL_DATA.put(data, callback);
    }

    public static int getLoadingPriority(class_2960 powerId) {
        if (!LOADING_PRIORITIES.containsKey(powerId)) {
            return Integer.MIN_VALUE;
        }
        return LOADING_PRIORITIES.get(powerId);
    }

    public Collection<class_2960> getFabricDependencies() {
        return DEPENDENCIES;
    }
}

