/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import com.mojang.datafixers.util.Pair;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2810;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3449;
import net.minecraft.class_3545;
import net.minecraft.class_3902;
import net.minecraft.class_4076;
import net.minecraft.class_5275;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.function.TriFunction;

public class ModifyPlayerSpawnPower
extends Power {
    public final class_5321<class_1937> dimension;
    public final float dimensionDistanceMultiplier;
    public final class_2960 biomeId;
    public final SpawnStrategy spawnStrategy;
    public final class_5321<class_3195> structure;
    public final class_3414 spawnSound;

    public ModifyPlayerSpawnPower(PowerType<?> type, class_1309 entity, class_5321<class_1937> dimension, float dimensionDistanceMultiplier, class_2960 biomeId, SpawnStrategy spawnStrategy, class_5321<class_3195> structure, class_3414 spawnSound) {
        super(type, entity);
        this.dimension = dimension;
        this.dimensionDistanceMultiplier = dimensionDistanceMultiplier;
        this.biomeId = biomeId;
        this.spawnStrategy = spawnStrategy;
        this.structure = structure;
        this.spawnSound = spawnSound;
    }

    @Override
    public void onRemoved() {
        class_1309 class_13092;
        if (this.entity.method_37908().field_9236 || !((class_13092 = this.entity) instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)class_13092;
        class_3222 serverPlayerEntity = (class_3222)playerEntity;
        if (serverPlayerEntity.method_14239() || serverPlayerEntity.method_26280() == null || !serverPlayerEntity.method_26282()) {
            return;
        }
        serverPlayerEntity.method_26284(class_1937.field_25179, null, 0.0f, false, false);
    }

    public void teleportToModifiedSpawn() {
        class_1309 class_13092;
        if (this.entity.method_37908().field_9236 || !((class_13092 = this.entity) instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)class_13092;
        class_3222 serverPlayerEntity = (class_3222)playerEntity;
        class_3545<class_3218, class_2338> newSpawn = this.getSpawn(false);
        if (newSpawn == null) {
            return;
        }
        class_3218 newSpawnDimension = (class_3218)newSpawn.method_15442();
        class_2338 newSpawnPos = (class_2338)newSpawn.method_15441();
        class_243 tpPos = class_5275.method_30769((class_1299)playerEntity.method_5864(), (class_1941)((class_1941)newSpawn.method_15442()), (class_2338)((class_2338)newSpawn.method_15441()), (boolean)true);
        if (tpPos == null) {
            serverPlayerEntity.method_14251(newSpawnDimension, (double)newSpawnPos.method_10263(), (double)newSpawnPos.method_10264(), (double)newSpawnPos.method_10260(), this.entity.method_36455(), this.entity.method_36454());
            Apoli.LOGGER.warn("Power {} could not find a suitable spawnpoint for {}! Teleporting to the desired location directly...", (Object)this.getType().getIdentifier(), (Object)this.entity.method_5820());
        } else {
            serverPlayerEntity.method_14251(newSpawnDimension, tpPos.field_1352, tpPos.field_1351, tpPos.field_1350, this.entity.method_36455(), this.entity.method_36454());
        }
    }

    public class_3545<class_3218, class_2338> getSpawn(boolean isSpawnObstructed) {
        class_1309 class_13092;
        if (this.entity.method_37908().field_9236 || !((class_13092 = this.entity) instanceof class_1657)) {
            return null;
        }
        class_1657 playerEntity = (class_1657)class_13092;
        class_3222 serverPlayerEntity = (class_3222)playerEntity;
        MinecraftServer server = serverPlayerEntity.method_5682();
        if (server == null) {
            return null;
        }
        class_3218 overworldDimension = server.method_3847(class_1937.field_25179);
        if (overworldDimension == null) {
            return null;
        }
        class_3218 targetDimension = server.method_3847(this.dimension);
        if (targetDimension == null) {
            Apoli.LOGGER.warn("Power {} could not set {}'s spawnpoint at dimension \"{}\" as it's not registered! Falling back to default spawnpoint...", (Object)this.getType().getIdentifier(), (Object)this.entity.method_5820(), (Object)this.dimension.method_29177());
            return null;
        }
        int center = targetDimension.method_32819() / 2;
        int range = 64;
        AtomicReference modifiedSpawnPos = new AtomicReference();
        class_2338 regularSpawnBlockPos = overworldDimension.method_43126();
        class_2338.class_2339 modifiedSpawnBlockPos = new class_2338.class_2339();
        class_2338.class_2339 dimensionSpawnPos = this.spawnStrategy.apply(regularSpawnBlockPos, center, this.dimensionDistanceMultiplier).method_25503();
        this.getBiomePos(targetDimension, (class_2338)dimensionSpawnPos).ifPresent(arg_0 -> ((class_2338.class_2339)dimensionSpawnPos).method_10101(arg_0));
        this.getSpawnPos(targetDimension, (class_2338)dimensionSpawnPos, range).ifPresent(modifiedSpawnPos::set);
        if (modifiedSpawnPos.get() == null) {
            return null;
        }
        class_243 msp = (class_243)modifiedSpawnPos.get();
        modifiedSpawnBlockPos.method_10102(msp.field_1352, msp.field_1351, msp.field_1350);
        targetDimension.method_14178().method_17297(class_3230.field_14030, new class_1923((class_2338)modifiedSpawnBlockPos), 11, (Object)class_3902.field_17274);
        return new class_3545((Object)targetDimension, (Object)modifiedSpawnBlockPos);
    }

    private Optional<class_2338> getBiomePos(class_3218 targetDimension, class_2338 originPos) {
        if (this.biomeId == null) {
            return Optional.empty();
        }
        Optional targetBiome = targetDimension.method_30349().method_30530(class_7924.field_41236).method_17966(this.biomeId);
        if (targetBiome.isEmpty()) {
            Apoli.LOGGER.warn("Power {} could not set {}'s spawnpoint at biome \"{}\" as it's not registered in dimension \"{}\".", (Object)this.getType().getIdentifier(), (Object)this.entity.method_5820(), (Object)this.biomeId, (Object)this.dimension.method_29177());
            return Optional.empty();
        }
        Pair targetBiomePos = targetDimension.method_42108(biome -> biome.comp_349() == targetBiome.get(), originPos, 6400, 8, 8);
        if (targetBiomePos != null) {
            return Optional.of((class_2338)targetBiomePos.getFirst());
        }
        Apoli.LOGGER.warn("Power {} could not set {}'s spawnpoint at biome \"{}\" as it couldn't be found in dimension \"{}\".", (Object)this.getType().getIdentifier(), (Object)this.entity.method_5820(), (Object)this.biomeId, (Object)this.dimension.method_29177());
        return Optional.empty();
    }

    private Optional<class_3545<class_2338, class_3195>> getStructurePos(class_1937 world, class_5321<class_3195> structure, class_6862<class_3195> structureTag, class_5321<class_1937> dimension) {
        MinecraftServer server;
        class_2378 structureRegistry = world.method_30349().method_30530(class_7924.field_41246);
        class_6885 structureRegistryEntryList = null;
        Object structureTagOrName = "";
        if (structure != null) {
            Optional entry = structureRegistry.method_40264(structure);
            if (entry.isPresent()) {
                structureRegistryEntryList = class_6885.method_40246((class_6880[])new class_6880[]{(class_6880)entry.get()});
            }
            structureTagOrName = structure.method_29177().toString();
        }
        if (structureRegistryEntryList == null) {
            Optional entryList = structureRegistry.method_40266(structureTag);
            if (entryList.isPresent()) {
                structureRegistryEntryList = (class_6885)entryList.get();
            }
            structureTagOrName = "#" + structureTag.comp_327().toString();
        }
        if ((server = this.entity.method_5682()) == null) {
            return Optional.empty();
        }
        class_3218 serverWorld = server.method_3847(dimension);
        if (serverWorld == null) {
            return Optional.empty();
        }
        class_2338 center = new class_2338(0, 70, 0);
        Pair structurePos = serverWorld.method_14178().method_12129().method_12103(serverWorld, structureRegistryEntryList, center, 100, false);
        if (structurePos == null) {
            Apoli.LOGGER.warn("Power {} could not set {}'s spawnpoint at structure \"{}\" as it couldn't be found in dimension \"{}\".", (Object)this.getType().getIdentifier(), (Object)this.entity.method_5820(), structureTagOrName, (Object)dimension.method_29177());
            return Optional.empty();
        }
        return Optional.of(new class_3545((Object)((class_2338)structurePos.getFirst()), (Object)((class_3195)((class_6880)structurePos.getSecond()).comp_349())));
    }

    private Optional<class_243> getSpawnPos(class_3218 targetDimension, class_2338 originPos, int range) {
        if (this.structure == null) {
            return this.getValidSpawn(targetDimension, originPos, range);
        }
        Optional<class_3545<class_2338, class_3195>> targetStructure = this.getStructurePos((class_1937)targetDimension, this.structure, null, this.dimension);
        if (targetStructure.isEmpty()) {
            return Optional.empty();
        }
        class_2338 targetStructurePos = (class_2338)targetStructure.get().method_15442();
        class_1923 targetStructureChunkPos = new class_1923(targetStructurePos.method_10263() >> 4, targetStructurePos.method_10260() >> 4);
        class_3449 targetStructureStart = targetDimension.method_27056().method_26975(class_4076.method_18681((class_1923)targetStructureChunkPos, (int)0), (class_3195)targetStructure.get().method_15441(), (class_2810)targetDimension.method_22350(targetStructurePos));
        if (targetStructureStart == null) {
            return Optional.empty();
        }
        class_2338 targetStructureCenter = new class_2338((class_2382)targetStructureStart.method_14969().method_22874());
        return this.getValidSpawn(targetDimension, targetStructureCenter, range);
    }

    private Optional<class_243> getValidSpawn(class_3218 targetDimension, class_2338 startPos, int range) {
        int dx = 1;
        int dz = 0;
        int segmentLength = 1;
        int center = startPos.method_10264();
        class_2338.class_2339 mutableStartPos = startPos.method_25503();
        int x = startPos.method_10263();
        int z = startPos.method_10260();
        int segmentPassed = 0;
        int upOffset = 0;
        int downOffset = 0;
        int maxY = targetDimension.method_32819();
        int minY = ((class_2874)targetDimension.method_40134().comp_349()).comp_651();
        while (upOffset < maxY || downOffset > minY) {
            for (int steps = 0; steps < range; ++steps) {
                mutableStartPos.method_33097(x += dx);
                mutableStartPos.method_33099(z += dz);
                ++segmentPassed;
                mutableStartPos.method_33098(center + upOffset);
                class_243 spawnPos = class_5275.method_30769((class_1299)this.entity.method_5864(), (class_1941)targetDimension, (class_2338)mutableStartPos, (boolean)true);
                if (spawnPos != null) {
                    return Optional.of(spawnPos);
                }
                mutableStartPos.method_33098(center + downOffset);
                spawnPos = class_5275.method_30769((class_1299)this.entity.method_5864(), (class_1941)targetDimension, (class_2338)mutableStartPos, (boolean)true);
                if (spawnPos != null) {
                    return Optional.of(spawnPos);
                }
                if (segmentPassed != segmentLength) continue;
                segmentPassed = 0;
                int bdx = dx;
                dx = -dz;
                dz = bdx;
                if (dz != 0) continue;
                ++segmentLength;
            }
            if (upOffset < maxY) {
                ++upOffset;
            }
            if (downOffset <= minY) continue;
            --downOffset;
        }
        return Optional.empty();
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_player_spawn"), new SerializableData().add("dimension", SerializableDataTypes.DIMENSION).add("dimension_distance_multiplier", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("biome", SerializableDataTypes.IDENTIFIER, null).add("spawn_strategy", SerializableDataType.enumValue(SpawnStrategy.class), (Object)SpawnStrategy.DEFAULT).add("structure", SerializableDataType.registryKey((class_5321)class_7924.field_41246), null).add("respawn_sound", SerializableDataTypes.SOUND_EVENT, null), data -> (powerType, livingEntity) -> new ModifyPlayerSpawnPower((PowerType<?>)powerType, (class_1309)livingEntity, (class_5321<class_1937>)((class_5321)data.get("dimension")), ((Float)data.get("dimension_distance_multiplier")).floatValue(), (class_2960)data.get("biome"), (SpawnStrategy)((Object)((Object)((Object)data.get("spawn_strategy")))), (class_5321<class_3195>)((class_5321)data.get("structure")), (class_3414)data.get("respawn_sound"))).allowCondition();
    }

    private static enum SpawnStrategy {
        CENTER((TriFunction<class_2338, Integer, Float, class_2338>)((TriFunction)(blockPos, center, multiplier) -> new class_2338(0, center.intValue(), 0))),
        DEFAULT((TriFunction<class_2338, Integer, Float, class_2338>)((TriFunction)(blockPos, center, multiplier) -> {
            class_2338.class_2339 mut = new class_2338.class_2339();
            if (multiplier.floatValue() != 0.0f) {
                mut.method_10102((double)((float)blockPos.method_10263() * multiplier.floatValue()), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() * multiplier.floatValue()));
            } else {
                mut.method_10101((class_2382)blockPos);
            }
            return mut;
        }));

        final TriFunction<class_2338, Integer, Float, class_2338> strategyApplier;

        private SpawnStrategy(TriFunction<class_2338, Integer, Float, class_2338> strategyApplier) {
            this.strategyApplier = strategyApplier;
        }

        public class_2338 apply(class_2338 blockPos, int center, float multiplier) {
            return (class_2338)this.strategyApplier.apply((Object)blockPos, (Object)center, (Object)Float.valueOf(multiplier));
        }
    }
}

