/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3545;

public class ModifyFoodPower
extends Power {
    private final Predicate<class_1799> applicableFood;
    private final class_1799 replaceStack;
    private final Consumer<class_3545<class_1937, class_1799>> consumableAction;
    private final List<Modifier> foodModifiers;
    private final List<Modifier> saturationModifiers;
    private final Consumer<class_1297> entityActionWhenEaten;
    private final boolean preventFoodEffects;
    private final boolean makeAlwaysEdible;

    public ModifyFoodPower(PowerType<?> type, class_1309 entity, Predicate<class_1799> applicableFood, class_1799 replaceStack, Consumer<class_3545<class_1937, class_1799>> consumableAction, Modifier foodModifier, List<Modifier> foodModifiers, Modifier saturationModifier, List<Modifier> saturationModifiers, Consumer<class_1297> entityActionWhenEaten, boolean makeAlwaysEdible, boolean preventFoodEffects) {
        super(type, entity);
        this.applicableFood = applicableFood;
        this.replaceStack = replaceStack;
        this.consumableAction = consumableAction;
        this.foodModifiers = new LinkedList<Modifier>();
        if (foodModifier != null) {
            this.foodModifiers.add(foodModifier);
        }
        if (foodModifiers != null) {
            this.foodModifiers.addAll(foodModifiers);
        }
        this.saturationModifiers = new LinkedList<Modifier>();
        if (saturationModifier != null) {
            this.saturationModifiers.add(saturationModifier);
        }
        if (saturationModifiers != null) {
            this.saturationModifiers.addAll(saturationModifiers);
        }
        this.entityActionWhenEaten = entityActionWhenEaten;
        this.makeAlwaysEdible = makeAlwaysEdible;
        this.preventFoodEffects = preventFoodEffects;
    }

    public boolean doesApply(class_1799 stack) {
        return this.applicableFood == null || this.applicableFood.test(stack);
    }

    public class_1799 getConsumedItemStack(class_1799 stack) {
        if (this.replaceStack != null) {
            stack = this.replaceStack;
        }
        class_1799 consumed = stack.method_7972();
        if (this.consumableAction != null) {
            this.consumableAction.accept((class_3545<class_1937, class_1799>)new class_3545((Object)this.entity.method_37908(), (Object)consumed));
        }
        return consumed;
    }

    public void eat() {
        if (this.entityActionWhenEaten != null) {
            this.entityActionWhenEaten.accept((class_1297)this.entity);
        }
    }

    public List<Modifier> getFoodModifiers() {
        return this.foodModifiers;
    }

    public List<Modifier> getSaturationModifiers() {
        return this.saturationModifiers;
    }

    public boolean doesMakeAlwaysEdible() {
        return this.makeAlwaysEdible;
    }

    public boolean doesPreventEffects() {
        return this.preventFoodEffects;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_food"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("replace_stack", SerializableDataTypes.ITEM_STACK, null).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("food_modifier", Modifier.DATA_TYPE, null).add("food_modifiers", Modifier.LIST_TYPE, null).add("saturation_modifier", Modifier.DATA_TYPE, null).add("saturation_modifiers", Modifier.LIST_TYPE, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("always_edible", SerializableDataTypes.BOOLEAN, (Object)false).add("prevent_effects", SerializableDataTypes.BOOLEAN, (Object)false), data -> (powerType, livingEntity) -> new ModifyFoodPower((PowerType<?>)powerType, (class_1309)livingEntity, (Predicate)data.get("item_condition"), (class_1799)data.get("replace_stack"), (Consumer)data.get("item_action"), (Modifier)data.get("food_modifier"), (List)data.get("food_modifiers"), (Modifier)data.get("saturation_modifier"), (List)data.get("saturation_modifiers"), (Consumer)data.get("entity_action"), (Boolean)data.get("always_edible"), (Boolean)data.get("prevent_effects"))).allowCondition();
    }
}

