/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;

public class ModifyDamageDealtPower
extends ValueModifyingPower {
    private final Predicate<class_3545<class_1282, Float>> condition;
    private final Predicate<class_1297> targetCondition;
    private final Predicate<class_3545<class_1297, class_1297>> biEntityCondition;
    private Consumer<class_1297> targetAction;
    private Consumer<class_1297> selfAction;
    private Consumer<class_3545<class_1297, class_1297>> biEntityAction;

    public ModifyDamageDealtPower(PowerType<?> type, class_1309 entity, Predicate<class_3545<class_1282, Float>> condition, Predicate<class_1297> targetCondition, Predicate<class_3545<class_1297, class_1297>> biEntityCondition) {
        super(type, entity);
        this.condition = condition;
        this.targetCondition = targetCondition;
        this.biEntityCondition = biEntityCondition;
    }

    public boolean doesApply(class_1282 source, float damageAmount, class_1309 target) {
        return !(!this.condition.test((class_3545<class_1282, Float>)new class_3545((Object)source, (Object)Float.valueOf(damageAmount))) || target != null && this.targetCondition != null && !this.targetCondition.test((class_1297)target) || target != null && this.biEntityCondition != null && !this.biEntityCondition.test((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)target)));
    }

    public void setTargetAction(Consumer<class_1297> targetAction) {
        this.targetAction = targetAction;
    }

    public void setBiEntityAction(Consumer<class_3545<class_1297, class_1297>> biEntityAction) {
        this.biEntityAction = biEntityAction;
    }

    public void setSelfAction(Consumer<class_1297> selfAction) {
        this.selfAction = selfAction;
    }

    public void executeActions(class_1297 target) {
        if (this.selfAction != null) {
            this.selfAction.accept((class_1297)this.entity);
        }
        if (this.targetAction != null) {
            this.targetAction.accept(target);
        }
        if (this.biEntityAction != null) {
            this.biEntityAction.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)target));
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_damage_dealt"), new SerializableData().add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null).add("target_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("self_action", ApoliDataTypes.ENTITY_ACTION, null).add("target_action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null), data -> (type, player) -> {
            ModifyDamageDealtPower power = new ModifyDamageDealtPower((PowerType<?>)type, (class_1309)player, data.isPresent("damage_condition") ? (Predicate)data.get("damage_condition") : dmg -> true, (Predicate)data.get("target_condition"), (Predicate)data.get("bientity_condition"));
            data.ifPresent("modifier", power::addModifier);
            data.ifPresent("modifiers", mods -> mods.forEach(power::addModifier));
            if (data.isPresent("bientity_action")) {
                power.setBiEntityAction((Consumer)data.get("bientity_action"));
            }
            if (data.isPresent("self_action")) {
                power.setSelfAction((Consumer)data.get("self_action"));
            }
            if (data.isPresent("target_action")) {
                power.setTargetAction((Consumer)data.get("target_action"));
            }
            return power;
        }).allowCondition();
    }
}

