/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3955;
import org.apache.commons.lang3.tuple.Triple;

public class ModifyCraftingPower
extends ValueModifyingPower {
    private final class_2960 recipeIdentifier;
    private final Predicate<class_1799> itemCondition;
    private final class_1799 newStack;
    private final Consumer<class_3545<class_1937, class_1799>> itemAction;
    private final Consumer<class_3545<class_1937, class_1799>> lateItemAction;
    private final Consumer<class_1297> entityAction;
    private final Consumer<Triple<class_1937, class_2338, class_2350>> blockAction;

    public ModifyCraftingPower(PowerType<?> type, class_1309 entity, class_2960 recipeIdentifier, Predicate<class_1799> itemCondition, class_1799 newStack, Consumer<class_3545<class_1937, class_1799>> itemAction, Consumer<class_3545<class_1937, class_1799>> lateItemAction, Consumer<class_1297> entityAction, Consumer<Triple<class_1937, class_2338, class_2350>> blockAction) {
        super(type, entity);
        this.recipeIdentifier = recipeIdentifier;
        this.itemCondition = itemCondition;
        this.newStack = newStack;
        this.itemAction = itemAction;
        this.lateItemAction = lateItemAction;
        this.entityAction = entityAction;
        this.blockAction = blockAction;
    }

    public boolean doesApply(class_1715 inventory, class_3955 recipe) {
        if (this.recipeIdentifier != null && !recipe.method_8114().equals((Object)this.recipeIdentifier)) {
            return false;
        }
        return this.itemCondition == null || this.itemCondition.test(recipe.method_8116((class_1263)inventory, this.entity.method_37908().method_30349()));
    }

    public void applyAfterCraftingItemAction(class_1799 output) {
        if (this.lateItemAction == null) {
            return;
        }
        this.lateItemAction.accept((class_3545<class_1937, class_1799>)new class_3545((Object)this.entity.method_37908(), (Object)output));
    }

    public class_1799 getNewResult(class_1715 inventory, class_3955 recipe) {
        class_1799 stack = this.newStack != null ? this.newStack.method_7972() : recipe.method_8116((class_1263)inventory, this.entity.method_37908().method_30349());
        if (this.itemAction != null) {
            this.itemAction.accept((class_3545<class_1937, class_1799>)new class_3545((Object)this.entity.method_37908(), (Object)stack));
        }
        return stack;
    }

    public void executeActions(Optional<class_2338> craftingBlockPos) {
        if (craftingBlockPos.isPresent() && this.blockAction != null) {
            this.blockAction.accept((Triple<class_1937, class_2338, class_2350>)Triple.of((Object)this.entity.method_37908(), (Object)craftingBlockPos.get(), (Object)class_2350.field_11036));
        }
        if (this.entityAction != null) {
            this.entityAction.accept((class_1297)this.entity);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_crafting"), new SerializableData().add("recipe", SerializableDataTypes.IDENTIFIER, null).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("result", SerializableDataTypes.ITEM_STACK, null).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("item_action_after_crafting", ApoliDataTypes.ITEM_ACTION, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("block_action", ApoliDataTypes.BLOCK_ACTION, null), data -> (type, player) -> new ModifyCraftingPower((PowerType<?>)type, (class_1309)player, data.getId("recipe"), (Predicate)data.get("item_condition"), (class_1799)data.get("result"), (Consumer)data.get("item_action"), (Consumer)data.get("item_action_after_crafting"), (Consumer)data.get("entity_action"), (Consumer)data.get("block_action"))).allowCondition();
    }
}

