/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_3545;

public class InvulnerablePower
extends Power {
    private final Predicate<class_1282> damageSources;

    public InvulnerablePower(PowerType<?> type, class_1309 entity, Predicate<class_1282> damageSourcePredicate) {
        super(type, entity);
        this.damageSources = damageSourcePredicate;
    }

    public boolean doesApply(class_1282 source) {
        return this.damageSources.test(source);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("invulnerability"), new SerializableData().add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION), data -> (type, player) -> {
            ConditionFactory.Instance damageCondition = (ConditionFactory.Instance)data.get("damage_condition");
            return new InvulnerablePower((PowerType<?>)type, (class_1309)player, ds -> damageCondition.test(new class_3545(ds, null)));
        }).allowCondition();
    }
}

