/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3545;

public class InteractionPower
extends Power {
    private final EnumSet<class_1268> hands;
    private final class_1269 actionResult;
    private final Predicate<class_1799> itemCondition;
    protected final Consumer<class_3545<class_1937, class_1799>> heldItemAction;
    protected final class_1799 itemResult;
    protected final Consumer<class_3545<class_1937, class_1799>> resultItemAction;

    public InteractionPower(PowerType<?> type, class_1309 entity, EnumSet<class_1268> hands, class_1269 actionResult, Predicate<class_1799> itemCondition, Consumer<class_3545<class_1937, class_1799>> heldItemAction, class_1799 itemResult, Consumer<class_3545<class_1937, class_1799>> resultItemAction) {
        super(type, entity);
        this.hands = hands;
        this.actionResult = actionResult;
        this.itemCondition = itemCondition;
        this.heldItemAction = heldItemAction;
        this.itemResult = itemResult;
        this.resultItemAction = resultItemAction;
    }

    public boolean shouldExecute(class_1268 hand, class_1799 heldStack) {
        if (!this.doesApplyToHand(hand)) {
            return false;
        }
        return this.doesApplyToItem(heldStack);
    }

    public boolean doesApplyToHand(class_1268 hand) {
        return this.hands.contains(hand);
    }

    public boolean doesApplyToItem(class_1799 heldStack) {
        return this.itemCondition == null || this.itemCondition.test(heldStack);
    }

    public class_1269 getActionResult() {
        return this.actionResult;
    }

    protected void performActorItemStuff(InteractionPower power, class_1657 actor, class_1268 hand) {
        boolean modified;
        class_1799 heldStack = actor.method_5998(hand);
        if (power.heldItemAction != null) {
            power.heldItemAction.accept((class_3545<class_1937, class_1799>)new class_3545((Object)actor.method_37908(), (Object)heldStack));
        }
        class_1799 resultingStack = power.itemResult == null ? heldStack : power.itemResult.method_7972();
        boolean bl = modified = power.itemResult != null;
        if (power.resultItemAction != null) {
            power.resultItemAction.accept((class_3545<class_1937, class_1799>)new class_3545((Object)actor.method_37908(), (Object)resultingStack));
            modified = true;
        }
        if (modified) {
            if (heldStack.method_7960()) {
                actor.method_6122(hand, resultingStack);
            } else {
                actor.method_31548().method_7398(resultingStack);
            }
        }
    }
}

