/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

public class ConditionedRestrictArmorPower
extends Power {
    private final HashMap<class_1304, Predicate<class_1799>> armorConditions;
    private final int tickRate;

    public ConditionedRestrictArmorPower(PowerType<?> type, class_1309 entity, HashMap<class_1304, Predicate<class_1799>> armorConditions, int tickRate) {
        super(type, entity);
        this.armorConditions = armorConditions;
        this.setTicking(true);
        this.tickRate = tickRate;
    }

    public boolean canEquip(class_1799 itemStack, class_1304 slot) {
        return !this.armorConditions.get(slot).test(itemStack);
    }

    @Override
    public void tick() {
        if (this.entity.field_6012 % this.tickRate == 0 && this.isActive()) {
            for (class_1304 slot : this.armorConditions.keySet()) {
                class_1799 equippedItem = this.entity.method_6118(slot);
                if (equippedItem.method_7960() || this.canEquip(equippedItem, slot)) continue;
                this.entity.method_5699(equippedItem, this.entity.method_18381(this.entity.method_18376()));
                this.entity.method_5673(slot, class_1799.field_8037);
            }
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("conditioned_restrict_armor"), new SerializableData().add("head", ApoliDataTypes.ITEM_CONDITION, null).add("chest", ApoliDataTypes.ITEM_CONDITION, null).add("legs", ApoliDataTypes.ITEM_CONDITION, null).add("feet", ApoliDataTypes.ITEM_CONDITION, null).add("tick_rate", SerializableDataTypes.INT, (Object)80), data -> (type, player) -> {
            HashMap<class_1304, Predicate<class_1799>> restrictions = new HashMap<class_1304, Predicate<class_1799>>();
            if (data.isPresent("head")) {
                restrictions.put(class_1304.field_6169, (ConditionFactory.Instance)data.get("head"));
            }
            if (data.isPresent("chest")) {
                restrictions.put(class_1304.field_6174, (ConditionFactory.Instance)data.get("chest"));
            }
            if (data.isPresent("legs")) {
                restrictions.put(class_1304.field_6172, (ConditionFactory.Instance)data.get("legs"));
            }
            if (data.isPresent("feet")) {
                restrictions.put(class_1304.field_6166, (ConditionFactory.Instance)data.get("feet"));
            }
            return new ConditionedRestrictArmorPower((PowerType<?>)type, (class_1309)player, restrictions, data.getInt("tick_rate"));
        }).allowCondition();
    }
}

