/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2481;
import net.minecraft.class_2520;

public class ActionOverTimePower
extends Power {
    private final int interval;
    private final Consumer<class_1297> entityAction;
    private final Consumer<class_1297> risingAction;
    private final Consumer<class_1297> fallingAction;
    private boolean wasActive = false;
    private Integer initialTicks = null;

    public ActionOverTimePower(PowerType<?> type, class_1309 entity, int interval, Consumer<class_1297> entityAction, Consumer<class_1297> risingAction, Consumer<class_1297> fallingAction) {
        super(type, entity);
        if (interval <= 0) {
            interval = 1;
        }
        this.interval = interval;
        this.entityAction = entityAction;
        this.risingAction = risingAction;
        this.fallingAction = fallingAction;
        this.setTicking(true);
    }

    @Override
    public void tick() {
        if (this.initialTicks == null) {
            this.initialTicks = this.entity.field_6012 % this.interval;
        } else if (this.entity.field_6012 % this.interval == this.initialTicks) {
            if (this.isActive()) {
                if (!this.wasActive && this.risingAction != null) {
                    this.risingAction.accept((class_1297)this.entity);
                }
                if (this.entityAction != null) {
                    this.entityAction.accept((class_1297)this.entity);
                }
                this.wasActive = true;
            } else {
                if (this.wasActive && this.fallingAction != null) {
                    this.fallingAction.accept((class_1297)this.entity);
                }
                this.wasActive = false;
            }
        }
    }

    @Override
    public class_2520 toTag() {
        return class_2481.method_23234((boolean)this.wasActive);
    }

    @Override
    public void fromTag(class_2520 tag) {
        this.wasActive = tag.equals((Object)class_2481.field_21027);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("action_over_time"), new SerializableData().add("interval", SerializableDataTypes.INT, (Object)20).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("rising_action", ApoliDataTypes.ENTITY_ACTION, null).add("falling_action", ApoliDataTypes.ENTITY_ACTION, null), data -> (type, player) -> new ActionOverTimePower((PowerType<?>)type, (class_1309)player, data.getInt("interval"), (Consumer)data.get("entity_action"), (Consumer)data.get("rising_action"), (Consumer)data.get("falling_action"))).allowCondition();
    }
}

