/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.Prioritized;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3545;

public class ActionOnItemUsePower
extends Power
implements Prioritized<ActionOnItemUsePower> {
    private final Predicate<class_1799> itemCondition;
    private final Consumer<class_1297> entityAction;
    private final Consumer<class_3545<class_1937, class_1799>> itemAction;
    private final TriggerType triggerType;
    private final int priority;

    public ActionOnItemUsePower(PowerType<?> type, class_1309 entity, Predicate<class_1799> itemCondition, Consumer<class_1297> entityAction, Consumer<class_3545<class_1937, class_1799>> itemAction, TriggerType triggerType, int priority) {
        super(type, entity);
        this.itemCondition = itemCondition;
        this.entityAction = entityAction;
        this.itemAction = itemAction;
        this.triggerType = triggerType;
        this.priority = priority;
    }

    public boolean doesApply(class_1799 stack) {
        return this.itemCondition == null || this.itemCondition.test(stack);
    }

    public void executeActions(class_1799 stack) {
        if (this.itemAction != null) {
            this.itemAction.accept((class_3545<class_1937, class_1799>)new class_3545((Object)this.entity.method_37908(), (Object)stack));
        }
        if (this.entityAction != null) {
            this.entityAction.accept((class_1297)this.entity);
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    private boolean isInPhase(PriorityPhase phase) {
        return phase == PriorityPhase.ALL || phase == PriorityPhase.BEFORE && this.getPriority() >= 0 || phase == PriorityPhase.AFTER && this.getPriority() < 0;
    }

    public static void executeActions(class_1297 user, class_1799 useStack, class_1799 checkStack, TriggerType triggerType, PriorityPhase phase) {
        if (user.method_37908().field_9236) {
            return;
        }
        Prioritized.CallInstance callInstance = new Prioritized.CallInstance();
        callInstance.add(user, ActionOnItemUsePower.class, p -> p.triggerType == triggerType && p.doesApply(checkStack) && p.isInPhase(phase));
        for (int i = callInstance.getMaxPriority(); i >= callInstance.getMinPriority(); --i) {
            if (!callInstance.hasPowers(i)) continue;
            List powers = callInstance.getPowers(i);
            for (ActionOnItemUsePower power : powers) {
                power.executeActions(useStack);
            }
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("action_on_item_use"), new SerializableData().add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("trigger", SerializableDataType.enumValue(TriggerType.class), (Object)TriggerType.FINISH).add("priority", SerializableDataTypes.INT, (Object)0), data -> (type, player) -> new ActionOnItemUsePower((PowerType<?>)type, (class_1309)player, (Predicate)data.get("item_condition"), (Consumer)data.get("entity_action"), (Consumer)data.get("item_action"), (TriggerType)((Object)((Object)((Object)data.get("trigger")))), data.getInt("priority"))).allowCondition();
    }

    public static enum TriggerType {
        INSTANT,
        START,
        STOP,
        FINISH,
        DURING;

    }

    public static enum PriorityPhase {
        BEFORE,
        AFTER,
        ALL;

    }
}

