/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.networking;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.SyncStatusEffectsUtil;
import io.github.apace100.calio.SerializationHelper;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_635;

public class ModPacketsS2C {
    @Environment(value=EnvType.CLIENT)
    public static void register() {
        ClientLoginNetworking.registerGlobalReceiver((class_2960)ModPackets.HANDSHAKE, ModPacketsS2C::handleHandshake);
        ClientPlayConnectionEvents.INIT.register((clientPlayNetworkHandler, minecraftClient) -> {
            ClientPlayNetworking.registerReceiver((class_2960)ModPackets.POWER_LIST, ModPacketsS2C::receivePowerList);
            ClientPlayNetworking.registerReceiver((class_2960)ModPackets.SYNC_POWER, ModPacketsS2C::onPowerSync);
            ClientPlayNetworking.registerReceiver((class_2960)ModPackets.PLAYER_MOUNT, ModPacketsS2C::onPlayerMount);
            ClientPlayNetworking.registerReceiver((class_2960)ModPackets.PLAYER_DISMOUNT, ModPacketsS2C::onPlayerDismount);
            ClientPlayNetworking.registerReceiver((class_2960)ModPackets.SET_ATTACKER, ModPacketsS2C::onSetAttacker);
            ClientPlayNetworking.registerReceiver((class_2960)ModPackets.SYNC_STATUS_EFFECT, ModPacketsS2C::onStatusEffectSync);
        });
    }

    private static void onStatusEffectSync(class_310 minecraftClient, class_634 clientPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        int targetId = packetByteBuf.readInt();
        SyncStatusEffectsUtil.UpdateType updateType = SyncStatusEffectsUtil.UpdateType.values()[packetByteBuf.readByte()];
        class_1293 instance = null;
        if (updateType != SyncStatusEffectsUtil.UpdateType.CLEAR) {
            instance = SerializationHelper.readStatusEffect((class_2540)packetByteBuf);
        }
        class_1293 finalInstance = instance;
        minecraftClient.execute(() -> {
            class_1297 target = clientPlayNetworkHandler.method_2890().method_8469(targetId);
            if (!(target instanceof class_1309)) {
                Apoli.LOGGER.warn("Received unknown target for status effect synchronization");
            } else {
                class_1309 living = (class_1309)target;
                switch (updateType) {
                    case CLEAR: {
                        living.method_6088().clear();
                        break;
                    }
                    case APPLY: 
                    case UPGRADE: {
                        living.method_6088().put(finalInstance.method_5579(), finalInstance);
                        break;
                    }
                    case REMOVE: {
                        living.method_6088().remove(finalInstance.method_5579());
                    }
                }
            }
        });
    }

    private static void onSetAttacker(class_310 minecraftClient, class_634 clientPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        int targetId = packetByteBuf.readInt();
        boolean hasAttacker = packetByteBuf.readBoolean();
        int attackerId = 0;
        if (hasAttacker) {
            attackerId = packetByteBuf.readInt();
        }
        int finalAttackerId = attackerId;
        minecraftClient.execute(() -> {
            class_1297 target = clientPlayNetworkHandler.method_2890().method_8469(targetId);
            class_1297 attacker = null;
            if (hasAttacker) {
                attacker = clientPlayNetworkHandler.method_2890().method_8469(finalAttackerId);
            }
            if (!(target instanceof class_1309)) {
                Apoli.LOGGER.warn("Received unknown target");
            } else if (hasAttacker && !(attacker instanceof class_1309)) {
                Apoli.LOGGER.warn("Received unknown attacker");
            } else if (hasAttacker) {
                ((class_1309)target).method_6015((class_1309)attacker);
            } else {
                ((class_1309)target).method_6015(null);
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static CompletableFuture<class_2540> handleHandshake(class_310 minecraftClient, class_635 clientLoginNetworkHandler, class_2540 packetByteBuf, Consumer<GenericFutureListener<? extends Future<? super Void>>> genericFutureListenerConsumer) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(Apoli.SEMVER.length);
        for (int i = 0; i < Apoli.SEMVER.length; ++i) {
            buf.writeInt(Apoli.SEMVER[i]);
        }
        return CompletableFuture.completedFuture(buf);
    }

    @Environment(value=EnvType.CLIENT)
    private static void receivePowerList(class_310 minecraftClient, class_634 clientPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        int powerCount = packetByteBuf.readInt();
        HashMap<class_2960, PowerType> factories = new HashMap<class_2960, PowerType>();
        for (int i = 0; i < powerCount; ++i) {
            class_2960 powerId = packetByteBuf.method_10810();
            class_2960 factoryId = packetByteBuf.method_10810();
            try {
                PowerType type;
                PowerFactory factory = (PowerFactory)ApoliRegistries.POWER_FACTORY.method_10223(factoryId);
                PowerFactory.Instance factoryInstance = factory.read(packetByteBuf);
                if (packetByteBuf.readBoolean()) {
                    type = new MultiplePowerType(powerId, factoryInstance);
                    int subPowerCount = packetByteBuf.method_10816();
                    ArrayList<class_2960> subPowers = new ArrayList<class_2960>(subPowerCount);
                    for (int j = 0; j < subPowerCount; ++j) {
                        subPowers.add(packetByteBuf.method_10810());
                    }
                    ((MultiplePowerType)type).setSubPowers(subPowers);
                } else {
                    type = new PowerType(powerId, factoryInstance);
                }
                type.setTranslationKeys(packetByteBuf.method_19772(), packetByteBuf.method_19772());
                if (packetByteBuf.readBoolean()) {
                    type.setHidden();
                }
                factories.put(powerId, type);
                continue;
            }
            catch (Exception e) {
                Apoli.LOGGER.error("Error while receiving \"" + String.valueOf(powerId) + "\" (factory: \"" + String.valueOf(factoryId) + "\"): " + e.getMessage());
                e.printStackTrace();
            }
        }
        minecraftClient.execute(() -> {
            PowerTypeRegistry.clear();
            factories.forEach(PowerTypeRegistry::register);
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void onPlayerMount(class_310 minecraftClient, class_634 clientPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        int mountingPlayerId = packetByteBuf.readInt();
        int mountedPlayerId = packetByteBuf.readInt();
        minecraftClient.execute(() -> {
            class_1297 mountingPlayer = clientPlayNetworkHandler.method_2890().method_8469(mountingPlayerId);
            class_1297 mountedPlayer = clientPlayNetworkHandler.method_2890().method_8469(mountedPlayerId);
            if (mountedPlayer == null) {
                Apoli.LOGGER.warn("Received passenger for unknown player");
            } else if (mountingPlayer == null) {
                Apoli.LOGGER.warn("Received unknown passenger for player");
            } else {
                boolean result = mountingPlayer.method_5873(mountedPlayer, true);
                if (result) {
                    Apoli.LOGGER.info(mountingPlayer.method_5476().getString() + " started riding " + mountedPlayer.method_5476().getString());
                } else {
                    Apoli.LOGGER.warn(mountingPlayer.method_5476().getString() + " failed to start riding " + mountedPlayer.method_5476().getString());
                }
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void onPlayerDismount(class_310 minecraftClient, class_634 clientPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        int dismountingPlayerId = packetByteBuf.readInt();
        minecraftClient.execute(() -> {
            class_1297 dismountingPlayer = clientPlayNetworkHandler.method_2890().method_8469(dismountingPlayerId);
            if (dismountingPlayer == null) {
                Apoli.LOGGER.warn("Unknown player tried to dismount");
            } else if (dismountingPlayer.method_5854() instanceof class_1657) {
                dismountingPlayer.method_29239();
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void onPowerSync(class_310 minecraftClient, class_634 clientPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        int entityId = packetByteBuf.readInt();
        class_2960 powerId = packetByteBuf.method_10810();
        class_2487 powerNbtContainer = packetByteBuf.method_10798();
        class_2520 powerNbt = powerNbtContainer.method_10580("Data");
        minecraftClient.execute(() -> {
            if (!PowerTypeRegistry.contains(powerId)) {
                Apoli.LOGGER.warn("Received sync packet for unknown power type: " + String.valueOf(powerId));
                return;
            }
            class_1297 entity = clientPlayNetworkHandler.method_2890().method_8469(entityId);
            if (entity == null) {
                Apoli.LOGGER.warn("Received sync packet for unknown power holder.");
                return;
            }
            PowerType powerType = PowerTypeRegistry.get(powerId);
            PowerHolderComponent.KEY.maybeGet((Object)entity).ifPresentOrElse(phc -> {
                Object power = phc.getPower(powerType);
                ((Power)power).fromTag(powerNbt);
            }, () -> Apoli.LOGGER.warn("Received sync packet for entity without power holder."));
        });
    }
}

