/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.ApoliClient;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.EntityGlowPower;
import io.github.apace100.apoli.power.PhasingPower;
import io.github.apace100.apoli.power.SelfGlowPower;
import io.github.apace100.apoli.util.MiscUtil;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_761.class})
public abstract class WorldRendererMixin {
    @Final
    @Shadow
    private class_310 field_4088;
    @Unique
    private class_1297 renderEntity;

    @Shadow
    public abstract void method_3279();

    @Shadow
    public abstract void method_22710(class_4587 var1, float var2, long var3, boolean var5, class_4184 var6, class_757 var7, class_765 var8, Matrix4f var9);

    @Inject(method={"renderSky(Lnet/minecraft/client/util/math/MatrixStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Ljava/lang/Runnable;run()V", shift=At.Shift.AFTER, ordinal=0)}, cancellable=true)
    private void skipSkyRenderingForPhasingBlindness(class_4587 matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, boolean bl, Runnable runnable, CallbackInfo ci) {
        List<PhasingPower> phasings;
        if (camera.method_19331() instanceof class_1309 && (phasings = PowerHolderComponent.getPowers(camera.method_19331(), PhasingPower.class)).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS) && MiscUtil.getInWallBlockState((class_1309)camera.method_19331()) != null) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void updateChunksIfRenderChanged(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (ApoliClient.shouldReloadWorldRenderer) {
            this.method_3279();
            ApoliClient.shouldReloadWorldRenderer = false;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/Entity;getTeamColorValue()I")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void getEntity(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci, class_3695 profiler, class_243 vec3d, double d, double e, double f, Matrix4f matrix4f, boolean bl, class_4604 frustum, float g, boolean bl2, boolean bl3, class_4597.class_4598 immediate, Iterator var25, class_1297 entity) {
        this.renderEntity = entity;
    }

    @ModifyArgs(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/OutlineVertexConsumerProvider;setColor(IIII)V"))
    private void setColors(Args args) {
        for (EntityGlowPower entityGlowPower : PowerHolderComponent.getPowers(this.field_4088.method_1560(), EntityGlowPower.class)) {
            if (!entityGlowPower.doesApply(this.renderEntity) || entityGlowPower.usesTeams()) continue;
            args.set(0, (Object)((int)(entityGlowPower.getRed() * 255.0f)));
            args.set(1, (Object)((int)(entityGlowPower.getGreen() * 255.0f)));
            args.set(2, (Object)((int)(entityGlowPower.getBlue() * 255.0f)));
        }
        for (SelfGlowPower selfGlowPower : PowerHolderComponent.getPowers(this.renderEntity, SelfGlowPower.class)) {
            if (selfGlowPower.usesTeams()) continue;
            args.set(0, (Object)((int)(selfGlowPower.getRed() * 255.0f)));
            args.set(1, (Object)((int)(selfGlowPower.getGreen() * 255.0f)));
            args.set(2, (Object)((int)(selfGlowPower.getBlue() * 255.0f)));
        }
    }
}

