/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.github.apace100.apoli.access.EndRespawningEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActionOnItemUsePower;
import io.github.apace100.apoli.power.KeepInventoryPower;
import io.github.apace100.apoli.power.ModifyPlayerSpawnPower;
import io.github.apace100.apoli.power.PreventSleepPower;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3545;
import net.minecraft.class_3902;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements class_1712,
EndRespawningEntity {
    @Shadow
    private class_5321<class_1937> field_23191;
    @Shadow
    private class_2338 field_23192;
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Shadow
    public class_3244 field_13987;
    @Shadow
    public boolean field_13989;
    @Shadow
    private boolean field_23193;
    @Unique
    private class_1799 apoli$stackBeforeDrop;
    @Unique
    private boolean origins_isEndRespawning;

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Shadow
    public abstract void method_7353(class_2561 var1, boolean var2);

    @Inject(method={"trySleep"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setSpawnPoint(Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/util/math/BlockPos;FZZ)V")}, cancellable=true)
    public void preventAvianSleep(class_2338 pos, CallbackInfoReturnable<Either<class_1657.class_1658, class_3902>> info) {
        PowerHolderComponent.getPowers((class_1297)this, PreventSleepPower.class).forEach(p -> {
            if (p.doesPrevent((class_4538)this.method_37908(), pos)) {
                if (p.doesAllowSpawnPoint()) {
                    ((class_3222)this).method_26284(this.method_37908().method_27983(), pos, this.method_36454(), false, true);
                }
                info.setReturnValue((Object)Either.left(null));
                this.method_7353((class_2561)class_2561.method_43471((String)p.getMessage()), true);
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"getSpawnPointDimension"}, cancellable=true)
    private void modifySpawnPointDimension(CallbackInfoReturnable<class_5321<class_1937>> info) {
        if (!this.origins_isEndRespawning && (this.field_23192 == null || this.hasObstructedSpawn()) && PowerHolderComponent.getPowers((class_1297)this, ModifyPlayerSpawnPower.class).size() > 0) {
            ModifyPlayerSpawnPower power = PowerHolderComponent.getPowers((class_1297)this, ModifyPlayerSpawnPower.class).get(0);
            info.setReturnValue(power.dimension);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getSpawnPointPosition"}, cancellable=true)
    private void modifyPlayerSpawnPosition(CallbackInfoReturnable<class_2338> info) {
        if (!this.origins_isEndRespawning && PowerHolderComponent.getPowers((class_1297)this, ModifyPlayerSpawnPower.class).size() > 0) {
            if (this.field_23192 == null) {
                info.setReturnValue((Object)this.findPlayerSpawn());
            } else if (this.hasObstructedSpawn()) {
                this.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25645, 0.0f));
                info.setReturnValue((Object)this.findPlayerSpawn());
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSpawnForced"}, cancellable=true)
    private void modifySpawnPointSet(CallbackInfoReturnable<Boolean> info) {
        if (!this.origins_isEndRespawning && (this.field_23192 == null || this.hasObstructedSpawn()) && PowerHolderComponent.hasPower((class_1297)this, ModifyPlayerSpawnPower.class)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/server/network/ServerPlayerEntity;enchantmentTableSeed:I")})
    private void copyInventoryWhenKeeping(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (PowerHolderComponent.hasPower((class_1297)oldPlayer, KeepInventoryPower.class)) {
            this.method_31548().method_7377(oldPlayer.method_31548());
        }
    }

    private boolean hasObstructedSpawn() {
        class_3218 world = this.field_13995.method_3847(this.field_23191);
        if (this.field_23192 != null && world != null) {
            Optional optional = class_1657.method_26091((class_3218)world, (class_2338)this.field_23192, (float)0.0f, (boolean)this.field_23193, (boolean)true);
            return !optional.isPresent();
        }
        return false;
    }

    private class_2338 findPlayerSpawn() {
        ModifyPlayerSpawnPower power = PowerHolderComponent.getPowers((class_1297)this, ModifyPlayerSpawnPower.class).get(0);
        class_3545<class_3218, class_2338> spawn = power.getSpawn(true);
        if (spawn != null) {
            return (class_2338)spawn.method_15441();
        }
        return null;
    }

    @Inject(method={"dropSelectedItem"}, at={@At(value="HEAD")})
    private void cacheItemStackBeforeDropping(boolean entireStack, CallbackInfoReturnable<Boolean> cir) {
        this.apoli$stackBeforeDrop = this.method_31548().method_7391().method_7972();
    }

    @Inject(method={"dropSelectedItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/ScreenHandler;getSlotIndex(Lnet/minecraft/inventory/Inventory;I)Ljava/util/OptionalInt;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void checkItemUsageStopping(boolean entireStack, CallbackInfoReturnable<Boolean> cir, class_1661 playerInventory, class_1799 itemStack) {
        if (this.method_6115() && !class_1799.method_7984((class_1799)this.apoli$stackBeforeDrop, (class_1799)this.method_31548().method_7391())) {
            ActionOnItemUsePower.executeActions((class_1297)this, itemStack, this.apoli$stackBeforeDrop, ActionOnItemUsePower.TriggerType.STOP, ActionOnItemUsePower.PriorityPhase.ALL);
        }
    }

    @Override
    public void setEndRespawning(boolean endSpawn) {
        this.origins_isEndRespawning = endSpawn;
    }

    @Override
    public boolean isEndRespawning() {
        return this.origins_isEndRespawning;
    }

    @Override
    public boolean hasRealRespawnPoint() {
        return this.field_23192 != null && !this.hasObstructedSpawn();
    }
}

