/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.power.ActionOnBeingUsedPower;
import io.github.apace100.apoli.power.ActionOnEntityUsePower;
import io.github.apace100.apoli.power.ActionOnWakeUp;
import io.github.apace100.apoli.power.ActiveInteractionPower;
import io.github.apace100.apoli.power.DisableRegenPower;
import io.github.apace100.apoli.power.IgnoreWaterPower;
import io.github.apace100.apoli.power.InventoryPower;
import io.github.apace100.apoli.power.KeepInventoryPower;
import io.github.apace100.apoli.power.ModifyAirSpeedPower;
import io.github.apace100.apoli.power.ModifyDamageDealtPower;
import io.github.apace100.apoli.power.ModifyDamageTakenPower;
import io.github.apace100.apoli.power.ModifyExhaustionPower;
import io.github.apace100.apoli.power.ModifyFoodPower;
import io.github.apace100.apoli.power.ModifyProjectileDamagePower;
import io.github.apace100.apoli.power.PreventBeingUsedPower;
import io.github.apace100.apoli.power.PreventEntityUsePower;
import io.github.apace100.apoli.power.Prioritized;
import io.github.apace100.apoli.power.RestrictArmorPower;
import io.github.apace100.apoli.power.SwimmingPower;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1275;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements class_1275,
class_2165 {
    @Shadow
    protected boolean field_7490;
    @Shadow
    @Final
    public class_1661 field_7514;
    @Unique
    private class_1269 apoli$CachedPriorityZeroResult;

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract class_4048 method_18377(class_4050 var1);

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract class_1542 method_7328(class_1799 var1, boolean var2);

    @Shadow
    public abstract class_1269 method_7287(class_1297 var1, class_1268 var2);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"getOffGroundSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyFlySpeed(CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(PowerHolderComponent.modify((class_1297)this, ModifyAirSpeedPower.class, ((Float)cir.getReturnValue()).floatValue())));
    }

    @ModifyVariable(method={"eatFood"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1799 modifyEatenItemStack(class_1799 original) {
        List<ModifyFoodPower> mfps = PowerHolderComponent.getPowers((class_1297)this, ModifyFoodPower.class);
        mfps = mfps.stream().filter(mfp -> mfp.doesApply(original)).collect(Collectors.toList());
        class_1799 newStack = original;
        for (ModifyFoodPower mfp2 : mfps) {
            newStack = mfp2.getConsumedItemStack(newStack);
        }
        ((ModifiableFoodEntity)((Object)this)).setCurrentModifyFoodPowers(mfps);
        ((ModifiableFoodEntity)((Object)this)).setOriginalFoodStack(original);
        return newStack;
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventEntityInteraction(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (this.method_7325()) {
            return;
        }
        class_1799 stack = this.method_5998(hand);
        for (PreventEntityUsePower peup : PowerHolderComponent.getPowers((class_1297)this, PreventEntityUsePower.class)) {
            if (!peup.doesApply(entity, hand, stack)) continue;
            cir.setReturnValue((Object)peup.executeAction(entity, hand));
            cir.cancel();
            return;
        }
        for (PreventBeingUsedPower pbup : PowerHolderComponent.getPowers(entity, PreventBeingUsedPower.class)) {
            if (!pbup.doesApply((class_1657)this, hand, stack)) continue;
            cir.setReturnValue((Object)pbup.executeAction((class_1657)this, hand));
            cir.cancel();
            return;
        }
        this.apoli$CachedPriorityZeroResult = class_1269.field_5811;
        Prioritized.CallInstance callInstance = new Prioritized.CallInstance();
        callInstance.add((class_1297)this, ActionOnEntityUsePower.class, p -> p.shouldExecute(entity, hand, stack) && p.getPriority() >= 0);
        callInstance.add(entity, ActionOnBeingUsedPower.class, p -> p.shouldExecute((class_1657)this, hand, stack) && p.getPriority() >= 0);
        for (int i = callInstance.getMaxPriority(); i >= 0; --i) {
            if (!callInstance.hasPowers(i)) continue;
            List powers = callInstance.getPowers(i);
            class_1269 result = class_1269.field_5811;
            for (ActiveInteractionPower ip : powers) {
                class_1269 ar = class_1269.field_5811;
                if (ip instanceof ActionOnEntityUsePower) {
                    ActionOnEntityUsePower aoeup = (ActionOnEntityUsePower)ip;
                    ar = aoeup.executeAction(entity, hand);
                } else if (ip instanceof ActionOnBeingUsedPower) {
                    ActionOnBeingUsedPower aobup = (ActionOnBeingUsedPower)ip;
                    ar = aobup.executeAction((class_1657)this, hand);
                }
                if (ar.method_23665() && !result.method_23665()) {
                    result = ar;
                    continue;
                }
                if (!ar.method_23666() || result.method_23666()) continue;
                result = ar;
            }
            if (i == 0) {
                this.apoli$CachedPriorityZeroResult = result;
                continue;
            }
            this.apoli$CachedPriorityZeroResult = class_1269.field_5811;
            if (result == class_1269.field_5811) continue;
            if (result.method_23666()) {
                this.method_6104(hand);
            }
            cir.setReturnValue((Object)result);
            break;
        }
    }

    @Inject(method={"damage"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true)
    private void allowDamageIfModifyingPowersExist(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        boolean hasModifyingPower = false;
        if (source.method_5529() != null) {
            hasModifyingPower = source.method_48789(class_8103.field_42247) ? PowerHolderComponent.hasPower(source.method_5529(), ModifyProjectileDamagePower.class, mpdp -> mpdp.doesApply(source, amount, this)) : PowerHolderComponent.hasPower(source.method_5529(), ModifyDamageDealtPower.class, mddp -> mddp.doesApply(source, amount, this));
        }
        if (hasModifyingPower |= PowerHolderComponent.hasPower((class_1297)this, ModifyDamageTakenPower.class, mdtp -> mdtp.doesApply(source, amount))) {
            cir.setReturnValue((Object)super.method_5643(source, amount));
        }
    }

    @Inject(method={"interact"}, at={@At(value="RETURN")}, cancellable=true)
    private void entityInteractionAfter(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1269 original = (class_1269)cir.getReturnValue();
        class_1269 custom = class_1269.field_5811;
        if (this.apoli$CachedPriorityZeroResult != class_1269.field_5811) {
            custom = this.apoli$CachedPriorityZeroResult;
        } else if (cir.getReturnValue() == class_1269.field_5811) {
            class_1799 stack = this.method_5998(hand);
            Prioritized.CallInstance callInstance = new Prioritized.CallInstance();
            callInstance.add((class_1297)this, ActionOnEntityUsePower.class, p -> p.shouldExecute(entity, hand, stack) && p.getPriority() < 0);
            callInstance.add(entity, ActionOnBeingUsedPower.class, p -> p.shouldExecute((class_1657)this, hand, stack) && p.getPriority() < 0);
            for (int i = -1; i >= callInstance.getMinPriority(); --i) {
                if (!callInstance.hasPowers(i)) continue;
                List powers = callInstance.getPowers(i);
                class_1269 result = class_1269.field_5811;
                for (ActiveInteractionPower ip : powers) {
                    class_1269 ar = class_1269.field_5811;
                    if (ip instanceof ActionOnEntityUsePower) {
                        ActionOnEntityUsePower aoeup = (ActionOnEntityUsePower)ip;
                        ar = aoeup.executeAction(entity, hand);
                    } else if (ip instanceof ActionOnBeingUsedPower) {
                        ActionOnBeingUsedPower aobup = (ActionOnBeingUsedPower)ip;
                        ar = aobup.executeAction((class_1657)this, hand);
                    }
                    if (ar.method_23665() && !result.method_23665()) {
                        result = ar;
                        continue;
                    }
                    if (!ar.method_23666() || result.method_23666()) continue;
                    result = ar;
                }
                if (result == class_1269.field_5811) continue;
                custom = result;
                break;
            }
        }
        if (custom.method_23666()) {
            this.method_6104(hand);
        }
        if (!(original.method_23665() && !custom.method_23665() || original.method_23666() && !custom.method_23666())) {
            cir.setReturnValue((Object)custom);
        }
    }

    @Inject(method={"dismountVehicle"}, at={@At(value="HEAD")})
    private void sendPlayerDismountPacket(CallbackInfo ci) {
        if (!this.method_37908().field_9236 && this.method_5854() instanceof class_1657) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(this.method_5628());
            ServerPlayNetworking.send((class_3222)((class_3222)this.method_5854()), (class_2960)ModPackets.PLAYER_DISMOUNT, (class_2540)buf);
        }
    }

    @Inject(method={"updateSwimming"}, at={@At(value="TAIL")})
    private void updateSwimmingPower(CallbackInfo ci) {
        if (PowerHolderComponent.hasPower((class_1297)this, SwimmingPower.class)) {
            this.method_5796(this.method_5624() && !this.method_5765());
            this.field_5957 = this.method_5681();
            if (this.method_5681()) {
                this.field_6017 = 0.0f;
                class_243 look = this.method_5720();
                this.method_5784(class_1313.field_6308, new class_243(look.field_1352 / 4.0, look.field_1351 / 4.0, look.field_1350 / 4.0));
            }
        } else if (PowerHolderComponent.hasPower((class_1297)this, IgnoreWaterPower.class)) {
            this.method_5796(false);
        }
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="HEAD")})
    private void invokeWakeUpAction(boolean bl, boolean updateSleepingPlayers, CallbackInfo ci) {
        if (!bl && !updateSleepingPlayers && this.method_18398().isPresent()) {
            class_2338 sleepingPos = (class_2338)this.method_18398().get();
            PowerHolderComponent.getPowers((class_1297)this, ActionOnWakeUp.class).stream().filter(p -> p.doesApply(sleepingPos)).forEach(p -> p.executeActions(sleepingPos, class_2350.field_11033));
        }
    }

    @Inject(method={"canFoodHeal"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableHeal(CallbackInfoReturnable<Boolean> info) {
        if (PowerHolderComponent.hasPower((class_1297)this, DisableRegenPower.class)) {
            info.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addExhaustion"}, ordinal=0, name={"exhaustion"})
    private float modifyExhaustion(float exhaustionIn) {
        return PowerHolderComponent.modify((class_1297)this, ModifyExhaustionPower.class, exhaustionIn);
    }

    @Inject(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V")})
    private void dropAdditionalInventory(CallbackInfo ci) {
        PowerHolderComponent.getPowers((class_1297)this, InventoryPower.class).forEach(inventoryPower -> {
            if (inventoryPower.shouldDropOnDeath()) {
                inventoryPower.dropItemsOnDeath();
            }
        });
        PowerHolderComponent.getPowers((class_1297)this, KeepInventoryPower.class).forEach(keepInventoryPower -> keepInventoryPower.preventItemsFromDropping((class_1263)this.field_7514));
    }

    @Inject(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V", shift=At.Shift.AFTER)})
    private void restoreKeptInventory(CallbackInfo ci) {
        PowerHolderComponent.getPowers((class_1297)this, KeepInventoryPower.class).forEach(keepInventoryPower -> keepInventoryPower.restoreSavedItems((class_1263)this.field_7514));
    }

    @Inject(method={"canEquip"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventArmorDispensing(class_1799 stack, CallbackInfoReturnable<Boolean> info) {
        class_1304 slot = class_1308.method_32326((class_1799)stack);
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this);
        if (component.getPowers(RestrictArmorPower.class).stream().anyMatch(rap -> !rap.canEquip(stack, slot))) {
            info.setReturnValue((Object)false);
        }
    }
}

