/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.HiddenEffectStatus;
import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.power.ActionOnHitPower;
import io.github.apace100.apoli.power.ActionWhenHitPower;
import io.github.apace100.apoli.power.AttackerActionWhenHitPower;
import io.github.apace100.apoli.power.ClimbingPower;
import io.github.apace100.apoli.power.EffectImmunityPower;
import io.github.apace100.apoli.power.FreezePower;
import io.github.apace100.apoli.power.ModifyAirSpeedPower;
import io.github.apace100.apoli.power.ModifyAttributePower;
import io.github.apace100.apoli.power.ModifyDamageDealtPower;
import io.github.apace100.apoli.power.ModifyDamageTakenPower;
import io.github.apace100.apoli.power.ModifyFallingPower;
import io.github.apace100.apoli.power.ModifyFoodPower;
import io.github.apace100.apoli.power.ModifyHealingPower;
import io.github.apace100.apoli.power.ModifyJumpPower;
import io.github.apace100.apoli.power.ModifyProjectileDamagePower;
import io.github.apace100.apoli.power.ModifySlipperinessPower;
import io.github.apace100.apoli.power.ModifyStatusEffectAmplifierPower;
import io.github.apace100.apoli.power.ModifyStatusEffectDurationPower;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.PreventDeathPower;
import io.github.apace100.apoli.power.PreventEntityCollisionPower;
import io.github.apace100.apoli.power.SelfActionOnHitPower;
import io.github.apace100.apoli.power.SelfActionOnKillPower;
import io.github.apace100.apoli.power.SelfActionWhenHitPower;
import io.github.apace100.apoli.power.SetEntityGroupPower;
import io.github.apace100.apoli.power.SwimmingPower;
import io.github.apace100.apoli.power.TargetActionOnHitPower;
import io.github.apace100.apoli.power.WalkOnFluidPower;
import io.github.apace100.apoli.util.InventoryUtil;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.apace100.apoli.util.SyncStatusEffectsUtil;
import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements ModifiableFoodEntity {
    @Shadow
    private Optional<class_2338> field_22418;
    @Unique
    private boolean apoli$hasModifiedDamage;
    @Unique
    private Optional<Boolean> apoli$shouldApplyArmor = Optional.empty();
    @Unique
    private Optional<Boolean> apoli$shouldDamageArmor = Optional.empty();
    @Unique
    private boolean prevPowderSnowState = false;
    @Unique
    private float cachedDamageAmount;
    @Shadow
    @Nullable
    private class_1309 field_6274;
    @Unique
    private List<ModifyFoodPower> apoli$currentModifyFoodPowers = new LinkedList<ModifyFoodPower>();
    @Unique
    private class_1799 apoli$originalFoodStack;

    @Shadow
    protected abstract float method_6106();

    @Shadow
    public abstract float method_6029();

    @Shadow
    public abstract boolean method_21754();

    @Shadow
    public abstract void method_6033(float var1);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"onStatusEffectApplied"}, at={@At(value="TAIL")})
    private void updateStatusEffectWhenApplied(class_1293 effectInstance, class_1297 source, CallbackInfo ci) {
        SyncStatusEffectsUtil.sendStatusEffectUpdatePacket((class_1309)this, SyncStatusEffectsUtil.UpdateType.APPLY, effectInstance);
    }

    @Inject(method={"onStatusEffectUpgraded"}, at={@At(value="TAIL")})
    private void updateStatusEffectWhenUpgraded(class_1293 effectInstance, boolean reapplyEffect, class_1297 source, CallbackInfo ci) {
        SyncStatusEffectsUtil.sendStatusEffectUpdatePacket((class_1309)this, SyncStatusEffectsUtil.UpdateType.UPGRADE, effectInstance);
    }

    @Inject(method={"onStatusEffectRemoved"}, at={@At(value="TAIL")})
    private void updateStatusEffectWhenRemoved(class_1293 effectInstance, CallbackInfo ci) {
        SyncStatusEffectsUtil.sendStatusEffectUpdatePacket((class_1309)this, SyncStatusEffectsUtil.UpdateType.REMOVE, effectInstance);
    }

    @Inject(method={"clearStatusEffects"}, at={@At(value="RETURN")})
    private void updateStatusEffectWhenCleared(CallbackInfoReturnable<Boolean> cir) {
        SyncStatusEffectsUtil.sendStatusEffectUpdatePacket((class_1309)this, SyncStatusEffectsUtil.UpdateType.CLEAR, null);
    }

    @ModifyVariable(method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z"}, at=@At(value="HEAD"))
    private class_1293 modifyStatusEffect(class_1293 effect) {
        class_1291 effectType = effect.method_5579();
        int originalAmp = effect.method_5578();
        int originalDur = effect.method_5584();
        int amplifier = Math.round(PowerHolderComponent.modify(this, ModifyStatusEffectAmplifierPower.class, originalAmp, power -> power.doesApply(effectType)));
        int duration = Math.round(PowerHolderComponent.modify(this, ModifyStatusEffectDurationPower.class, originalDur, power -> power.doesApply(effectType)));
        if (amplifier != originalAmp || duration != originalDur) {
            return new class_1293(effectType, duration, amplifier, effect.method_5591(), effect.method_5581(), effect.method_5592(), ((HiddenEffectStatus)effect).getHiddenEffect(), Optional.empty());
        }
        return effect;
    }

    @Inject(method={"setAttacker"}, at={@At(value="TAIL")})
    private void syncAttacker(class_1309 attacker, CallbackInfo ci) {
        if (!this.method_37908().field_9236) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(this.method_5628());
            if (this.field_6274 == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeInt(this.field_6274.method_5628());
            }
            for (class_3222 player : PlayerLookup.tracking((class_1297)this)) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.SET_ATTACKER, (class_2540)buf);
            }
        }
    }

    @Inject(method={"getEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/attribute/AttributeContainer;removeModifiers(Lcom/google/common/collect/Multimap;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void removeEquipmentPowers(CallbackInfoReturnable<Map> cir, Map map, class_1304[] var2, int var3, int var4, class_1304 equipmentSlot, class_1799 itemStack3, class_1799 itemStack4) {
        List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(itemStack3, equipmentSlot);
        if (powers.size() > 0) {
            class_2960 source = new class_2960("apoli", equipmentSlot.method_5923());
            PowerHolderComponent powerHolder = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this);
            powers.forEach(sp -> {
                if (PowerTypeRegistry.contains(sp.powerId)) {
                    powerHolder.removePower(PowerTypeRegistry.get(sp.powerId), source);
                }
            });
            powerHolder.sync();
        }
    }

    @Inject(method={"getEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/attribute/AttributeContainer;addTemporaryModifiers(Lcom/google/common/collect/Multimap;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addEquipmentPowers(CallbackInfoReturnable<Map> cir, Map map, class_1304[] var2, int var3, int var4, class_1304 equipmentSlot, class_1799 itemStack3, class_1799 itemStack4) {
        List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(itemStack4, equipmentSlot);
        if (powers.size() > 0) {
            class_2960 source = new class_2960("apoli", equipmentSlot.method_5923());
            PowerHolderComponent powerHolder = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this);
            powers.forEach(sp -> {
                if (PowerTypeRegistry.contains(sp.powerId)) {
                    powerHolder.addPower(PowerTypeRegistry.get(sp.powerId), source);
                }
            });
            powerHolder.sync();
        } else if (StackPowerUtil.getPowers(itemStack3, equipmentSlot).size() > 0) {
            ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this)).sync();
        }
    }

    @Inject(method={"canWalkOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyWalkableFluids(class_3610 fluidState, CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.getPowers(this, WalkOnFluidPower.class).stream().anyMatch(p -> fluidState.method_15767(p.getFluidTag()))) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), argsOnly=true)
    private float modifyHealingApplied(float originalValue) {
        return PowerHolderComponent.modify((class_1297)this, ModifyHealingPower.class, originalValue);
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    private float modifyDamageTaken(float originalValue, class_1282 source, float amount) {
        long dontWantArmor;
        float intermediateValue;
        float newValue = originalValue;
        class_1309 thisAsLiving = (class_1309)this;
        if (source.method_5529() != null) {
            newValue = !source.method_48789(class_8103.field_42247) ? PowerHolderComponent.modify(source.method_5529(), ModifyDamageDealtPower.class, originalValue, p -> p.doesApply(source, originalValue, thisAsLiving), p -> p.executeActions((class_1297)thisAsLiving)) : PowerHolderComponent.modify(source.method_5529(), ModifyProjectileDamagePower.class, originalValue, p -> p.doesApply(source, originalValue, thisAsLiving), p -> p.executeActions((class_1297)thisAsLiving));
        }
        this.apoli$hasModifiedDamage = (newValue = PowerHolderComponent.modify((class_1297)this, ModifyDamageTakenPower.class, intermediateValue = newValue, p -> p.doesApply(source, intermediateValue), p -> p.executeActions(source.method_5529()))) != originalValue;
        List<ModifyDamageTakenPower> mdtps = PowerHolderComponent.getPowers(this, ModifyDamageTakenPower.class).stream().filter(p -> p.doesApply(source, originalValue)).toList();
        long wantArmor = mdtps.stream().filter(p -> p.modifiesArmorApplicance() && p.shouldApplyArmor()).count();
        this.apoli$shouldApplyArmor = wantArmor == (dontWantArmor = mdtps.stream().filter(p -> p.modifiesArmorApplicance() && !p.shouldApplyArmor()).count()) ? Optional.empty() : Optional.of(wantArmor > dontWantArmor);
        long wantDamage = mdtps.stream().filter(p -> p.modifiesArmorDamaging() && p.shouldDamageArmor()).count();
        long dontWantDamage = mdtps.stream().filter(p -> p.modifiesArmorDamaging() && !p.shouldDamageArmor()).count();
        this.apoli$shouldDamageArmor = wantDamage == dontWantDamage ? Optional.empty() : Optional.of(wantDamage > dontWantDamage);
        return newValue;
    }

    @Inject(method={"applyArmorToDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyArmorApplicance(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        if (this.apoli$shouldApplyArmor.isPresent()) {
            if (this.apoli$shouldDamageArmor.isPresent() && this.apoli$shouldDamageArmor.get().booleanValue()) {
                this.method_6105(source, amount);
            }
            if (this.apoli$shouldApplyArmor.get().booleanValue()) {
                if (this.apoli$shouldDamageArmor.isEmpty()) {
                    this.method_6105(source, amount);
                }
                float damageLeft = class_1280.method_5496((float)amount, (float)this.method_6096(), (float)((float)this.method_26825(class_5134.field_23725)));
                cir.setReturnValue((Object)Float.valueOf(damageLeft));
            } else {
                cir.setReturnValue((Object)Float.valueOf(amount));
            }
        } else if (this.apoli$shouldDamageArmor.isPresent() && this.apoli$shouldDamageArmor.get().booleanValue() && source.method_48789(class_8103.field_42241)) {
            this.method_6105(source, amount);
        }
    }

    @Redirect(method={"applyArmorToDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageArmor(Lnet/minecraft/entity/damage/DamageSource;F)V"))
    private void preventArmorDamaging(class_1309 instance, class_1282 source, float amount) {
        if (this.apoli$shouldDamageArmor.isPresent() && !this.apoli$shouldDamageArmor.get().booleanValue()) {
            return;
        }
        this.method_6105(source, amount);
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isSleeping()Z")}, cancellable=true)
    private void preventHitIfDamageIsZero(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.apoli$hasModifiedDamage && amount <= 0.0f) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void invokeHitActions(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            class_1297 attacker = source.method_5529();
            if (attacker != null) {
                PowerHolderComponent.withPowers(this, ActionWhenHitPower.class, p -> true, p -> p.whenHit(attacker, source, amount));
                PowerHolderComponent.withPowers(attacker, ActionOnHitPower.class, p -> true, p -> p.onHit(this, source, amount));
            }
            PowerHolderComponent.getPowers(this, SelfActionWhenHitPower.class).forEach(p -> p.whenHit(source, amount));
            PowerHolderComponent.getPowers(this, AttackerActionWhenHitPower.class).forEach(p -> p.whenHit(source, amount));
            PowerHolderComponent.getPowers(source.method_5529(), SelfActionOnHitPower.class).forEach(p -> p.onHit((class_1297)((class_1309)this), source, amount));
            PowerHolderComponent.getPowers(source.method_5529(), TargetActionOnHitPower.class).forEach(p -> p.onHit((class_1309)this, source, amount));
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;onDeath(Lnet/minecraft/entity/damage/DamageSource;)V")})
    private void invokeKillAction(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        PowerHolderComponent.getPowers(source.method_5529(), SelfActionOnKillPower.class).forEach(p -> p.onKill((class_1297)((class_1309)this), source, amount));
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isWet()Z"))
    private boolean preventExtinguishingFromSwimming(class_1309 livingEntity) {
        if (PowerHolderComponent.hasPower((class_1297)livingEntity, SwimmingPower.class) && livingEntity.method_5681() && !(this.method_5861(class_3486.field_15517) > 0.0)) {
            return false;
        }
        return livingEntity.method_5637();
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getFrozenTicks()I")})
    private void freezeEntityFromPower(CallbackInfo ci) {
        if (PowerHolderComponent.hasPower(this, FreezePower.class)) {
            this.prevPowderSnowState = this.field_27857;
            this.field_27857 = true;
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;removePowderSnowSlow()V")})
    private void unfreezeEntityFromPower(CallbackInfo ci) {
        if (PowerHolderComponent.hasPower(this, FreezePower.class)) {
            this.field_27857 = this.prevPowderSnowState;
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="RETURN")}, cancellable=true)
    private void allowFreezingPower(CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower(this, FreezePower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getGroup"}, cancellable=true)
    public void getGroup(CallbackInfoReturnable<class_1310> info) {
        PowerHolderComponent component;
        List<SetEntityGroupPower> groups;
        if (this instanceof class_1309 && (groups = (component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this)).getPowers(SetEntityGroupPower.class)).size() > 0) {
            if (groups.size() > 1) {
                Apoli.LOGGER.warn("Entity " + this.method_5476().toString() + " has two instances of SetEntityGroupPower.");
            }
            info.setReturnValue((Object)groups.get((int)0).group);
        }
    }

    @Redirect(method={"jump"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getJumpVelocity()F"))
    private float modifyJumpVelocity(class_1309 entity) {
        return PowerHolderComponent.modify(this, ModifyJumpPower.class, this.method_6106(), p -> {
            p.executeAction();
            return true;
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"canHaveStatusEffect"}, cancellable=true)
    private void preventStatusEffects(class_1293 effect, CallbackInfoReturnable<Boolean> info) {
        for (EffectImmunityPower power : PowerHolderComponent.getPowers(this, EffectImmunityPower.class)) {
            if (!power.doesApply(effect)) continue;
            info.setReturnValue((Object)false);
            return;
        }
    }

    @ModifyReturnValue(method={"isClimbing"}, at={@At(value="RETURN")})
    private boolean apoli$modifyClimbing(boolean original) {
        if (original) {
            return true;
        }
        List<ClimbingPower> climbingPowers = PowerHolderComponent.getPowers(this, ClimbingPower.class);
        if (this.method_7325() || climbingPowers.isEmpty()) {
            return false;
        }
        this.field_22418 = Optional.of(this.method_24515());
        return true;
    }

    @ModifyReturnValue(method={"isHoldingOntoLadder"}, at={@At(value="RETURN")})
    private boolean apoli$overrideClimbHold(boolean original) {
        List<ClimbingPower> climbingPowers = PowerHolderComponent.getPowers(this, ClimbingPower.class);
        if (climbingPowers.isEmpty()) {
            return original;
        }
        return climbingPowers.stream().anyMatch(ClimbingPower::canHold);
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getFluidState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/fluid/FluidState;"), method={"travel"}, name={"d"}, ordinal=0)
    public double modifyFallingVelocity(double in) {
        if (this.method_18798().field_1351 > 0.0) {
            return in;
        }
        List<ModifyFallingPower> modifyFallingPowers = PowerHolderComponent.getPowers(this, ModifyFallingPower.class);
        if (modifyFallingPowers.size() > 0) {
            if (modifyFallingPowers.stream().anyMatch(p -> !p.takeFallDamage)) {
                this.field_6017 = 0.0f;
            }
            return PowerHolderComponent.modify((class_1297)this, ModifyFallingPower.class, in);
        }
        return in;
    }

    @Inject(method={"getAttributeValue(Lnet/minecraft/entity/attribute/EntityAttribute;)D"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyAttributeValue(class_1320 attribute, CallbackInfoReturnable<Double> cir) {
        double modified;
        double originalValue = this.method_6127().method_26852(attribute);
        if (originalValue != (modified = (double)PowerHolderComponent.modify(this, ModifyAttributePower.class, (float)originalValue, p -> p.getAttribute() == attribute))) {
            cir.setReturnValue((Object)modified);
        }
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isOnGround()Z", opcode=180, ordinal=2))
    private float modifySlipperiness(float original) {
        return PowerHolderComponent.modify(this, ModifySlipperinessPower.class, original, p -> p.doesApply((class_4538)this.method_37908(), this.method_23314()));
    }

    @Inject(method={"pushAway"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventPushing(class_1297 entity, CallbackInfo ci) {
        if (PowerHolderComponent.hasPower(this, PreventEntityCollisionPower.class, p -> p.doesApply(entity)) || PowerHolderComponent.hasPower(entity, PreventEntityCollisionPower.class, p -> p.doesApply(this))) {
            ci.cancel();
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tryUseTotem(Lnet/minecraft/entity/damage/DamageSource;)Z")})
    private void cacheDamageAmount(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.cachedDamageAmount = amount;
    }

    @Inject(method={"tryUseTotem"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Hand;values()[Lnet/minecraft/util/Hand;")}, cancellable=true)
    private void preventDeath(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        Optional<PreventDeathPower> preventDeathPower = PowerHolderComponent.getPowers(this, PreventDeathPower.class).stream().filter(p -> p.doesApply(source, this.cachedDamageAmount)).findFirst();
        if (preventDeathPower.isPresent()) {
            this.method_6033(1.0f);
            preventDeathPower.get().executeAction();
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"eatFood"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1799 modifyEatenItemStack(class_1799 original) {
        if (this instanceof class_1657) {
            return original;
        }
        List<ModifyFoodPower> mfps = PowerHolderComponent.getPowers(this, ModifyFoodPower.class);
        mfps = mfps.stream().filter(mfp -> mfp.doesApply(original)).collect(Collectors.toList());
        class_1799 newStack = original;
        for (ModifyFoodPower mfp2 : mfps) {
            newStack = mfp2.getConsumedItemStack(newStack);
        }
        this.setCurrentModifyFoodPowers(mfps);
        this.setOriginalFoodStack(original);
        return newStack;
    }

    @ModifyVariable(method={"eatFood"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyFoodEffects(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;)V", shift=At.Shift.AFTER))
    private class_1799 unmodifyEatenItemStack(class_1799 modified) {
        LivingEntityMixin foodEntity = this;
        class_1799 original = foodEntity.getOriginalFoodStack();
        if (original != null) {
            foodEntity.setOriginalFoodStack(null);
            return original;
        }
        return modified;
    }

    @Inject(method={"eatFood"}, at={@At(value="TAIL")})
    private void removeCurrentModifyFoodPowers(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
        this.setCurrentModifyFoodPowers(new LinkedList<ModifyFoodPower>());
    }

    @Redirect(method={"eatFood"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyFoodEffects(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;)V"))
    private void preventApplyingFoodEffects(class_1309 livingEntity, class_1799 stack, class_1937 world, class_1309 targetEntity) {
        if (this.getCurrentModifyFoodPowers().stream().anyMatch(ModifyFoodPower::doesPreventEffects)) {
            return;
        }
        this.method_18865(stack, world, targetEntity);
    }

    @Shadow
    protected abstract void method_18865(class_1799 var1, class_1937 var2, class_1309 var3);

    @Shadow
    protected abstract void method_6105(class_1282 var1, float var2);

    @Shadow
    public abstract int method_6096();

    @Shadow
    public abstract double method_26825(class_1320 var1);

    @Shadow
    public abstract class_5131 method_6127();

    @Inject(method={"getOffGroundSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyFlySpeed(CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(PowerHolderComponent.modify((class_1297)this, ModifyAirSpeedPower.class, ((Float)cir.getReturnValue()).floatValue())));
    }

    @Override
    public List<ModifyFoodPower> getCurrentModifyFoodPowers() {
        return this.apoli$currentModifyFoodPowers;
    }

    @Override
    public void setCurrentModifyFoodPowers(List<ModifyFoodPower> powers) {
        this.apoli$currentModifyFoodPowers = powers;
    }

    @Override
    public class_1799 getOriginalFoodStack() {
        return this.apoli$originalFoodStack;
    }

    @Override
    public void setOriginalFoodStack(class_1799 original) {
        this.apoli$originalFoodStack = original;
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void updateItemStackHolder(CallbackInfo ci) {
        InventoryUtil.forEachStack(this, stack -> stack.method_27320((class_1297)this));
    }
}

