/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ModifyCameraSubmersionTypePower;
import io.github.apace100.apoli.power.NightVisionPower;
import io.github.apace100.apoli.power.OverlayPower;
import io.github.apace100.apoli.power.PhasingPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.ShaderPower;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_757.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private class_4184 field_18765;
    @Shadow
    @Final
    private class_310 field_4015;
    @Shadow
    private class_279 field_4024;
    @Shadow
    private boolean field_4013;
    @Shadow
    @Final
    private class_3300 field_4018;
    @Unique
    private class_2960 currentlyLoadedShader;
    private HashMap<class_2338, class_2680> savedStates = new HashMap();

    @Shadow
    protected abstract void method_3168(class_2960 var1);

    @Inject(at={@At(value="TAIL")}, method={"onCameraEntitySet"})
    private void loadShaderFromPowerOnCameraEntity(class_1297 entity, CallbackInfo ci) {
        PowerHolderComponent.withPower(this.field_4015.method_1560(), ShaderPower.class, null, shaderPower -> {
            class_2960 shaderLoc = shaderPower.getShaderLocation();
            if (this.field_4018.method_14486(shaderLoc).isPresent()) {
                this.method_3168(shaderLoc);
                this.currentlyLoadedShader = shaderLoc;
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void loadShaderFromPower(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        PowerHolderComponent.withPower(this.field_4015.method_1560(), ShaderPower.class, null, shaderPower -> {
            class_2960 shaderLoc = shaderPower.getShaderLocation();
            if (this.currentlyLoadedShader != shaderLoc && this.field_4018.method_14486(shaderLoc).isPresent()) {
                this.method_3168(shaderLoc);
                this.currentlyLoadedShader = shaderLoc;
            }
        });
        if (!PowerHolderComponent.hasPower(this.field_4015.method_1560(), ShaderPower.class) && this.currentlyLoadedShader != null) {
            if (this.field_4024 != null) {
                this.field_4024.close();
                this.field_4024 = null;
            }
            this.field_4013 = false;
            this.currentlyLoadedShader = null;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;pop()V")})
    private void renderOverlayPowers(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        boolean hudHidden = this.field_4015.field_1690.field_1842;
        boolean thirdPerson = !this.field_4015.field_1690.method_31044().method_31034();
        PowerHolderComponent.withPower(this.field_4015.method_1560(), OverlayPower.class, p -> {
            if (p.getDrawPhase() != OverlayPower.DrawPhase.ABOVE_HUD) {
                return false;
            }
            if (hudHidden && p.doesHideWithHud()) {
                return false;
            }
            return !thirdPerson || p.shouldBeVisibleInThirdPerson();
        }, OverlayPower::render);
    }

    @Inject(at={@At(value="HEAD")}, method={"togglePostProcessorEnabled"}, cancellable=true)
    private void disableShaderToggle(CallbackInfo ci) {
        PowerHolderComponent.withPower(this.field_4015.method_1560(), ShaderPower.class, null, shaderPower -> {
            class_2960 shaderLoc = shaderPower.getShaderLocation();
            if (!shaderPower.isToggleable() && this.currentlyLoadedShader == shaderLoc) {
                ci.cancel();
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"getNightVisionStrength"}, cancellable=true)
    private static void getNightVisionStrength(class_1309 livingEntity, float f, CallbackInfoReturnable<Float> info) {
        if (livingEntity instanceof class_1657 && !livingEntity.method_6059(class_1294.field_5925)) {
            List<NightVisionPower> nvs = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingEntity)).getPowers(NightVisionPower.class);
            Optional<Float> strength = nvs.stream().filter(Power::isActive).map(NightVisionPower::getStrength).max(Float::compareTo);
            strength.ifPresent(arg_0 -> info.setReturnValue(arg_0));
        }
    }

    @Redirect(method={"getFov"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;getSubmersionType()Lnet/minecraft/client/render/CameraSubmersionType;"))
    private class_5636 modifySubmersionType(class_4184 camera) {
        class_5636 original = camera.method_19334();
        if (camera.method_19331() instanceof class_1309) {
            for (ModifyCameraSubmersionTypePower p : PowerHolderComponent.getPowers(camera.method_19331(), ModifyCameraSubmersionTypePower.class)) {
                if (!p.doesModify(original)) continue;
                return p.getNewType();
            }
        }
        return original;
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void beforeRender(float tickDelta, long startTime, boolean tick, CallbackInfo info) {
        block5: {
            block4: {
                List<PhasingPower> phasings = PowerHolderComponent.getPowers(this.field_18765.method_19331(), PhasingPower.class);
                if (!phasings.stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.REMOVE_BLOCKS)) break block4;
                float view = phasings.stream().filter(pp -> pp.getRenderType() == PhasingPower.RenderType.REMOVE_BLOCKS).map(PhasingPower::getViewDistance).min(Float::compareTo).get().floatValue();
                Set<class_2338> eyePositions = this.getEyePos(0.25f, 0.05f, 0.25f);
                HashSet<class_2338> noLongerEyePositions = new HashSet<class_2338>();
                for (class_2338 p : this.savedStates.keySet()) {
                    if (eyePositions.contains(p)) continue;
                    noLongerEyePositions.add(p);
                }
                for (class_2338 eyePosition : noLongerEyePositions) {
                    class_2680 state = this.savedStates.get(eyePosition);
                    this.field_4015.field_1687.method_8501(eyePosition, state);
                    this.savedStates.remove(eyePosition);
                }
                for (class_2338 p : eyePositions) {
                    class_2680 stateAtP = this.field_4015.field_1687.method_8320(p);
                    if (this.savedStates.containsKey(p) || this.field_4015.field_1687.method_22347(p) || stateAtP.method_26204() instanceof class_2404) continue;
                    this.savedStates.put(p, stateAtP);
                    this.field_4015.field_1687.method_8501(p, class_2246.field_10124.method_9564());
                }
                break block5;
            }
            if (this.savedStates.size() <= 0) break block5;
            HashSet<class_2338> noLongerEyePositions = new HashSet<class_2338>(this.savedStates.keySet());
            for (class_2338 eyePosition : noLongerEyePositions) {
                class_2680 state = this.savedStates.get(eyePosition);
                this.field_4015.field_1687.method_8501(eyePosition, state);
                this.savedStates.remove(eyePosition);
            }
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;update(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;ZZF)V"), method={"renderWorld"})
    private void preventThirdPerson(class_4184 camera, class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta) {
        if (PowerHolderComponent.getPowers(camera.method_19331(), PhasingPower.class).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.REMOVE_BLOCKS)) {
            camera.method_19321(area, focusedEntity, false, false, tickDelta);
        } else {
            camera.method_19321(area, focusedEntity, thirdPerson, inverseView, tickDelta);
        }
    }

    private Set<class_2338> getEyePos(float rangeX, float rangeY, float rangeZ) {
        class_243 pos = this.field_18765.method_19331().method_19538().method_1031(0.0, (double)this.field_18765.method_19331().method_18381(this.field_18765.method_19331().method_18376()), 0.0);
        class_238 cameraBox = new class_238(pos, pos);
        cameraBox = cameraBox.method_1009((double)rangeX, (double)rangeY, (double)rangeZ);
        HashSet<class_2338> set = new HashSet<class_2338>();
        class_2338.method_29715((class_238)cameraBox).forEach(p -> set.add(p.method_10062()));
        return set;
    }
}

