/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.component;

import com.google.common.collect.ImmutableList;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeReference;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.util.GainedPowerCriterion;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PowerHolderComponentImpl
implements PowerHolderComponent {
    private final class_1309 owner;
    private final ConcurrentHashMap<PowerType<?>, Power> powers = new ConcurrentHashMap();
    private final ConcurrentHashMap<PowerType<?>, List<class_2960>> powerSources = new ConcurrentHashMap();

    public PowerHolderComponentImpl(class_1309 owner) {
        this.owner = owner;
    }

    @Override
    public boolean hasPower(PowerType<?> powerType) {
        return this.powers.containsKey(powerType);
    }

    @Override
    public boolean hasPower(PowerType<?> powerType, class_2960 source) {
        return this.powerSources.containsKey(powerType) && this.powerSources.get(powerType).contains(source);
    }

    @Override
    public <T extends Power> T getPower(PowerType<T> powerType) {
        if (this.powers.containsKey(powerType)) {
            return (T)this.powers.get(powerType);
        }
        return null;
    }

    @Override
    public List<Power> getPowers() {
        return new LinkedList<Power>(this.powers.values());
    }

    @Override
    public Set<PowerType<?>> getPowerTypes(boolean getSubPowerTypes) {
        HashSet powerTypes = new HashSet(this.powers.keySet());
        for (PowerType type : this.powers.keySet()) {
            if (getSubPowerTypes || !(type instanceof MultiplePowerType)) continue;
            ((MultiplePowerType)type).getSubPowers().stream().map(PowerTypeRegistry::get).forEach(powerTypes::remove);
        }
        return powerTypes;
    }

    @Override
    public <T extends Power> List<T> getPowers(Class<T> powerClass) {
        return this.getPowers(powerClass, false);
    }

    @Override
    public <T extends Power> List<T> getPowers(Class<T> powerClass, boolean includeInactive) {
        LinkedList<Power> list = new LinkedList<Power>();
        for (Power power : this.powers.values()) {
            if (!powerClass.isAssignableFrom(power.getClass()) || !includeInactive && !power.isActive()) continue;
            list.add(power);
        }
        return list;
    }

    @Override
    public List<class_2960> getSources(PowerType<?> powerType) {
        if (this.powerSources.containsKey(powerType)) {
            return List.copyOf((Collection)this.powerSources.get(powerType));
        }
        return List.of();
    }

    @Override
    public void removePower(PowerType<?> powerType, class_2960 source) {
        if (powerType instanceof PowerTypeReference) {
            powerType = ((PowerTypeReference)powerType).getReferencedPowerType();
        }
        if (this.powerSources.containsKey(powerType)) {
            List<class_2960> sources = this.powerSources.get(powerType);
            sources.remove(source);
            if (sources.isEmpty()) {
                this.powerSources.remove(powerType);
                Power power = this.powers.remove(powerType);
                if (power != null) {
                    power.onRemoved();
                    power.onLost();
                }
            }
            if (powerType instanceof MultiplePowerType) {
                ImmutableList<class_2960> subPowers = ((MultiplePowerType)powerType).getSubPowers();
                for (class_2960 subPowerId : subPowers) {
                    this.removePower(PowerTypeRegistry.get(subPowerId), source);
                }
            }
        }
    }

    @Override
    public int removeAllPowersFromSource(class_2960 source) {
        List<PowerType<?>> powersToRemove = this.getPowersFromSource(source);
        powersToRemove.forEach(p -> this.removePower((PowerType<?>)p, source));
        return powersToRemove.size();
    }

    @Override
    public List<PowerType<?>> getPowersFromSource(class_2960 source) {
        LinkedList powers = new LinkedList();
        for (Map.Entry<PowerType<?>, List<class_2960>> sourceEntry : this.powerSources.entrySet()) {
            if (!sourceEntry.getValue().contains(source)) continue;
            powers.add(sourceEntry.getKey());
        }
        return powers;
    }

    @Override
    public boolean addPower(PowerType<?> powerType, class_2960 source) {
        if (powerType instanceof PowerTypeReference) {
            powerType = ((PowerTypeReference)powerType).getReferencedPowerType();
        }
        if (this.powerSources.containsKey(powerType)) {
            List<class_2960> sources = this.powerSources.get(powerType);
            if (sources.contains(source)) {
                return false;
            }
            sources.add(source);
            if (powerType instanceof MultiplePowerType) {
                ImmutableList<class_2960> subPowers = ((MultiplePowerType)powerType).getSubPowers();
                for (class_2960 subPowerId : subPowers) {
                    this.addPower(PowerTypeRegistry.get(subPowerId), source);
                }
            }
            return true;
        }
        LinkedList<class_2960> sources = new LinkedList<class_2960>();
        sources.add(source);
        if (powerType instanceof MultiplePowerType) {
            ImmutableList<class_2960> subPowers = ((MultiplePowerType)powerType).getSubPowers();
            for (class_2960 subPowerId : subPowers) {
                this.addPower(PowerTypeRegistry.get(subPowerId), source);
            }
        }
        this.powerSources.put(powerType, sources);
        Object power = powerType.create(this.owner);
        this.powers.put(powerType, (Power)power);
        ((Power)power).onGained();
        ((Power)power).onAdded();
        class_1309 class_13092 = this.owner;
        if (class_13092 instanceof class_3222) {
            class_3222 spe = (class_3222)class_13092;
            GainedPowerCriterion.INSTANCE.trigger(spe, powerType);
        }
        return true;
    }

    public void serverTick() {
        this.getPowers(Power.class, true).stream().filter(p -> p.shouldTick() && (p.shouldTickWhenInactive() || p.isActive())).forEach(Power::tick);
    }

    public void readFromNbt(class_2487 compoundTag) {
        this.fromTag(compoundTag, true);
    }

    private void fromTag(class_2487 compoundTag, boolean callPowerOnAdd) {
        block16: {
            try {
                if (this.owner == null) {
                    Apoli.LOGGER.error("Owner was null in PowerHolderComponent#fromTag!");
                }
                if (callPowerOnAdd) {
                    for (Power power : this.powers.values()) {
                        power.onRemoved();
                        power.onLost();
                    }
                }
                this.powers.clear();
                class_2499 powerList = (class_2499)compoundTag.method_10580("Powers");
                if (powerList == null) break block16;
                for (int i = 0; i < powerList.size(); ++i) {
                    class_2487 powerTag = powerList.method_10602(i);
                    class_2960 powerTypeId = class_2960.method_12829((String)powerTag.method_10558("Type"));
                    if (callPowerOnAdd && PowerTypeRegistry.isDisabled(powerTypeId)) continue;
                    class_2499 sources = (class_2499)powerTag.method_10580("Sources");
                    LinkedList list = new LinkedList();
                    if (sources != null) {
                        sources.forEach(nbtElement -> list.add(class_2960.method_12829((String)nbtElement.method_10714())));
                    }
                    PowerType type = PowerTypeRegistry.get(powerTypeId);
                    this.powerSources.put(type, list);
                    try {
                        class_2520 data = powerTag.method_10580("Data");
                        Object power = type.create(this.owner);
                        try {
                            ((Power)power).fromTag(data);
                        }
                        catch (ClassCastException e) {
                            Apoli.LOGGER.warn("Data type of \"" + String.valueOf(powerTypeId) + "\" changed, skipping data for that power on entity " + this.owner.method_5477().getString());
                        }
                        this.powers.put(type, (Power)power);
                        if (!callPowerOnAdd) continue;
                        ((Power)power).onAdded();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Apoli.LOGGER.warn("Power data of unregistered power \"" + String.valueOf(powerTypeId) + "\" found on entity, skipping...");
                    }
                }
                for (Map.Entry<PowerType<?>, List<class_2960>> entry : this.powerSources.entrySet()) {
                    PowerType<?> powerType = entry.getKey();
                    if (!(powerType instanceof MultiplePowerType)) continue;
                    ImmutableList<class_2960> subPowers = ((MultiplePowerType)powerType).getSubPowers();
                    for (class_2960 subPowerId : subPowers) {
                        try {
                            PowerType subType = PowerTypeRegistry.get(subPowerId);
                            for (class_2960 source : entry.getValue()) {
                                if (this.hasPower(subType, source)) continue;
                                this.addPower(subType, source);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (callPowerOnAdd && PowerTypeRegistry.isDisabled(subPowerId)) continue;
                            Apoli.LOGGER.warn("Multiple power type read from data contained unregistered sub-type: \"" + String.valueOf(subPowerId) + "\".");
                        }
                    }
                }
            }
            catch (Exception e) {
                Apoli.LOGGER.error("Error while reading power holder data: " + e.getMessage());
            }
        }
    }

    public void writeToNbt(class_2487 compoundTag) {
        class_2499 powerList = new class_2499();
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            class_2487 powerTag = new class_2487();
            powerTag.method_10582("Type", PowerTypeRegistry.getId(powerEntry.getKey()).toString());
            powerTag.method_10566("Data", powerEntry.getValue().toTag());
            class_2499 sources = new class_2499();
            this.powerSources.get(powerEntry.getKey()).forEach(id -> sources.add((Object)class_2519.method_23256((String)id.toString())));
            powerTag.method_10566("Sources", (class_2520)sources);
            powerList.add((Object)powerTag);
        }
        compoundTag.method_10566("Powers", (class_2520)powerList);
    }

    public void applySyncPacket(class_2540 buf) {
        class_2487 compoundTag = buf.method_10798();
        if (compoundTag != null) {
            this.fromTag(compoundTag, false);
        }
    }

    @Override
    public void sync() {
        PowerHolderComponent.sync((class_1297)this.owner);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("PowerHolderComponent[\n");
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            str.append("\t").append(PowerTypeRegistry.getId(powerEntry.getKey())).append(": ").append(powerEntry.getValue().toTag().toString()).append("\n");
        }
        str.append("]");
        return str.toString();
    }
}

