/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.networking.ModPacketsS2C;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.factory.condition.EntityConditionsClient;
import io.github.apace100.apoli.power.factory.condition.ItemConditionsClient;
import io.github.apace100.apoli.registry.ApoliClassDataClient;
import io.github.apace100.apoli.screen.GameHudRender;
import io.github.apace100.apoli.screen.PowerHudRenderer;
import io.github.apace100.apoli.util.ApoliConfig;
import io.github.apace100.apoli.util.ApoliConfigClient;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ApoliClient
implements ClientModInitializer {
    public static boolean shouldReloadWorldRenderer = false;
    private static HashMap<String, class_304> idToKeyBindingMap = new HashMap();
    private static HashMap<String, Boolean> lastKeyBindingStates = new HashMap();
    private static boolean initializedKeyBindingMap = false;

    public static void registerPowerKeybinding(String keyId, class_304 keyBinding) {
        idToKeyBindingMap.put(keyId, keyBinding);
    }

    public void onInitializeClient() {
        ModPacketsS2C.register();
        ApoliClassDataClient.registerAll();
        EntityConditionsClient.register();
        ItemConditionsClient.register();
        ClientTickEvents.START_CLIENT_TICK.register(tick -> {
            if (tick.field_1724 != null) {
                List<Power> powers = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)tick.field_1724)).getPowers();
                LinkedList<Power> pressedPowers = new LinkedList<Power>();
                HashMap<String, Boolean> currentKeyBindingStates = new HashMap<String, Boolean>();
                for (Power power : powers) {
                    if (!(power instanceof Active)) continue;
                    Active active = (Active)((Object)power);
                    Active.Key key = active.getKey();
                    class_304 keyBinding = this.getKeyBinding(key.key);
                    if (keyBinding == null) continue;
                    if (!currentKeyBindingStates.containsKey(key.key)) {
                        currentKeyBindingStates.put(key.key, keyBinding.method_1434());
                    }
                    if (!((Boolean)currentKeyBindingStates.get(key.key)).booleanValue() || !key.continuous && lastKeyBindingStates.getOrDefault(key.key, false).booleanValue()) continue;
                    pressedPowers.add(power);
                }
                lastKeyBindingStates = currentKeyBindingStates;
                if (pressedPowers.size() > 0) {
                    this.performActivePowers(pressedPowers);
                }
            }
        });
        GameHudRender.HUD_RENDERS.add(new PowerHudRenderer());
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            for (GameHudRender hudRender : GameHudRender.HUD_RENDERS) {
                hudRender.render(drawContext, tickDelta);
            }
        });
        AutoConfig.register(ApoliConfigClient.class, JanksonConfigSerializer::new);
        Apoli.config = (ApoliConfig)AutoConfig.getConfigHolder(ApoliConfigClient.class).getConfig();
    }

    @Environment(value=EnvType.CLIENT)
    private void performActivePowers(List<Power> powers) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeInt(powers.size());
        for (Power power : powers) {
            buffer.method_10812(power.getType().getIdentifier());
            ((Active)((Object)power)).onUse();
        }
        ClientPlayNetworking.send((class_2960)ModPackets.USE_ACTIVE_POWERS, (class_2540)buffer);
    }

    @Environment(value=EnvType.CLIENT)
    private class_304 getKeyBinding(String key) {
        if (!idToKeyBindingMap.containsKey(key)) {
            if (!initializedKeyBindingMap) {
                initializedKeyBindingMap = true;
                class_310 client = class_310.method_1551();
                for (int i = 0; i < client.field_1690.field_1839.length; ++i) {
                    idToKeyBindingMap.put(client.field_1690.field_1839[i].method_1431(), client.field_1690.field_1839[i]);
                }
                return this.getKeyBinding(key);
            }
            return null;
        }
        return idToKeyBindingMap.get(key);
    }
}

