/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.AnnotationNode;

@ApiStatus.Internal
public final class AnnotationEqualityVisitor
extends AnnotationVisitor {
    private final AnnotationNode other;
    private boolean isEqual = true;
    private int index = 0;

    public AnnotationEqualityVisitor(AnnotationNode other) {
        super(327680);
        this.other = other;
    }

    private static boolean deepEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                return Objects.deepEquals(o1, o2);
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                return Arrays.equals((short[])o1, (short[])o2);
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                return Arrays.equals((int[])o1, (int[])o2);
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                return Arrays.equals((long[])o1, (long[])o2);
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                return Arrays.equals((char[])o1, (char[])o2);
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                return Arrays.equals((float[])o1, (float[])o2);
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                return Arrays.equals((double[])o1, (double[])o2);
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                return Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            return false;
        }
        return o1.equals(o2);
    }

    public boolean isEqual() {
        return this.isEqual;
    }

    public void visit(AnnotationNode annotationNode) {
        if (annotationNode == null) {
            this.isEqual = false;
            return;
        }
        annotationNode.accept((AnnotationVisitor)this);
    }

    public void visit(String name, Object value) {
        if (!this.isEqual) {
            return;
        }
        Object expectedValue = this.getExpectedValue(name);
        if (!AnnotationEqualityVisitor.deepEquals(value, expectedValue)) {
            this.isEqual = false;
        }
    }

    public void visitEnum(String name, String desc, String value) {
        if (!this.isEqual) {
            return;
        }
        Object expectedValue = this.getExpectedValue(name);
        this.compareEnum(desc, value, expectedValue);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (!this.isEqual) {
            return null;
        }
        Object expectedValue = this.getExpectedValue(name);
        if (!(expectedValue instanceof AnnotationNode)) {
            this.isEqual = false;
            return null;
        }
        return new AnnotationEqualityVisitor((AnnotationNode)expectedValue);
    }

    public AnnotationVisitor visitArray(String name) {
        if (!this.isEqual) {
            return null;
        }
        Object expectedValue = this.getExpectedValue(name);
        if (!(expectedValue instanceof List)) {
            this.isEqual = false;
            return null;
        }
        final List expectedList = (List)expectedValue;
        return new AnnotationVisitor(this.api){
            int arrayIndex;
            {
                super(arg0);
                this.arrayIndex = 0;
            }

            public void visit(String name, Object value) {
                Object expectedElement;
                if (!AnnotationEqualityVisitor.this.isEqual) {
                    return;
                }
                if (this.arrayIndex >= expectedList.size()) {
                    AnnotationEqualityVisitor.this.isEqual = false;
                    return;
                }
                if (!AnnotationEqualityVisitor.deepEquals(value, expectedElement = expectedList.get(this.arrayIndex++))) {
                    AnnotationEqualityVisitor.this.isEqual = false;
                }
            }

            public void visitEnum(String name, String desc, String value) {
                if (!AnnotationEqualityVisitor.this.isEqual) {
                    return;
                }
                if (this.arrayIndex >= expectedList.size()) {
                    AnnotationEqualityVisitor.this.isEqual = false;
                    return;
                }
                Object expectedElement = expectedList.get(this.arrayIndex++);
                AnnotationEqualityVisitor.this.compareEnum(desc, value, expectedElement);
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                Object expectedElement;
                if (!AnnotationEqualityVisitor.this.isEqual) {
                    return null;
                }
                if (this.arrayIndex >= expectedList.size()) {
                    AnnotationEqualityVisitor.this.isEqual = false;
                    return null;
                }
                if (!((expectedElement = expectedList.get(this.arrayIndex++)) instanceof AnnotationNode)) {
                    AnnotationEqualityVisitor.this.isEqual = false;
                    return null;
                }
                return new AnnotationEqualityVisitor((AnnotationNode)expectedElement);
            }

            public void visitEnd() {
                if (this.arrayIndex != expectedList.size()) {
                    AnnotationEqualityVisitor.this.isEqual = false;
                }
            }
        };
    }

    private void compareEnum(String desc, String value, Object expectedElement) {
        if (!(expectedElement instanceof String[])) {
            this.isEqual = false;
            return;
        }
        String[] expectedEnum = (String[])expectedElement;
        if (expectedEnum.length != 2 || !desc.equals(expectedEnum[0]) || !value.equals(expectedEnum[1])) {
            this.isEqual = false;
        }
    }

    public void visitEnd() {
        if (this.index != (this.other.values == null ? 0 : this.other.values.size())) {
            this.isEqual = false;
        }
    }

    private Object getExpectedValue(String name) {
        if (this.other.values == null || this.index >= this.other.values.size()) {
            this.isEqual = false;
            return null;
        }
        Object expectedName = this.other.values.get(this.index++);
        Object expectedValue = this.other.values.get(this.index++);
        if (name != null && !name.equals(expectedName)) {
            this.isEqual = false;
            return null;
        }
        return expectedValue;
    }
}

