/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.reflection;

import com.bawnorton.mixinsquared.reflection.MethodReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

@ApiStatus.Internal
public final class MixinInfoExtension {
    private final IMixinInfo reference;
    private final MethodReference<?> stateMethod;
    private final MethodReference<String> remapClassNameMethod;

    private MixinInfoExtension(IMixinInfo reference) {
        this.reference = reference;
        this.stateMethod = new MethodReference(reference.getClass(), "getState", new Class[0]);
        this.remapClassNameMethod = new MethodReference(reference.getClass(), "remapClassName", String.class);
    }

    public static void tryAs(IMixinInfo mixinInfo, Consumer<MixinInfoExtension> consumer) {
        if (mixinInfo.getClass().getName().equals("org.spongepowered.asm.mixin.transformer.MixinInfo")) {
            consumer.accept(new MixinInfoExtension(mixinInfo));
        }
    }

    public Object getState() {
        return this.stateMethod.invoke(this.reference, new Object[0]);
    }

    public String remapClassName(String className) {
        return this.remapClassNameMethod.invoke(this.reference, className);
    }
}

