/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.adjuster.tools;

import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.adjuster.tools.type.OrdinalAnnotationNode;
import java.util.function.UnaryOperator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.mixin.injection.Constant;

public class AdjustableConstantNode
extends AdjustableAnnotationNode
implements OrdinalAnnotationNode {
    public AdjustableConstantNode(AnnotationNode node) {
        super(node);
    }

    public static AdjustableConstantNode defaultNode() {
        AnnotationNode node = new AnnotationNode(AdjustableAnnotationNode.KnownAnnotations.CONSTANT.desc());
        return new AdjustableConstantNode(node);
    }

    public boolean getNullValue() {
        return this.get("nullValue").orElse(false);
    }

    public void setNullValue(boolean nullValue) {
        this.set("nullValue", nullValue);
    }

    public AdjustableConstantNode withNullValue(UnaryOperator<Boolean> nullValue) {
        this.setNullValue((Boolean)nullValue.apply(this.getNullValue()));
        return this;
    }

    public int getIntValue() {
        return this.get("intValue").orElse(0);
    }

    public void setIntValue(int intValue) {
        this.set("intValue", intValue);
    }

    public AdjustableConstantNode withIntValue(UnaryOperator<Integer> intValue) {
        this.setIntValue((Integer)intValue.apply(this.getIntValue()));
        return this;
    }

    public float getFloatValue() {
        return this.get("floatValue").orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void setFloatValue(float floatValue) {
        this.set("floatValue", Float.valueOf(floatValue));
    }

    public AdjustableConstantNode withFloatValue(UnaryOperator<Float> floatValue) {
        this.setFloatValue(((Float)floatValue.apply(Float.valueOf(this.getFloatValue()))).floatValue());
        return this;
    }

    public long getLongValue() {
        return this.get("longValue").orElse(0L);
    }

    public void setLongValue(long longValue) {
        this.set("longValue", longValue);
    }

    public AdjustableConstantNode withLongValue(UnaryOperator<Long> longValue) {
        this.setLongValue((Long)longValue.apply(this.getLongValue()));
        return this;
    }

    public double getDoubleValue() {
        return this.get("doubleValue").orElse(0.0);
    }

    public void setDoubleValue(double doubleValue) {
        this.set("doubleValue", doubleValue);
    }

    public AdjustableConstantNode withDoubleValue(UnaryOperator<Double> doubleValue) {
        this.setDoubleValue((Double)doubleValue.apply(this.getDoubleValue()));
        return this;
    }

    public String getStringValue() {
        return this.get("stringValue").orElse("");
    }

    public void setStringValue(String stringValue) {
        this.set("stringValue", stringValue);
    }

    public AdjustableConstantNode withStringValue(UnaryOperator<String> stringValue) {
        this.setStringValue((String)stringValue.apply(this.getStringValue()));
        return this;
    }

    public Type getClassValue() {
        return this.get("classValue").orElse(Type.getType(Object.class));
    }

    public void setClassValue(Type classValue) {
        this.set("classValue", classValue);
    }

    public AdjustableConstantNode withClassValue(UnaryOperator<Type> classValue) {
        this.setClassValue((Type)classValue.apply(this.getClassValue()));
        return this;
    }

    @Override
    public AdjustableConstantNode withOrdinal(UnaryOperator<Integer> ordinal) {
        return (AdjustableConstantNode)OrdinalAnnotationNode.super.withOrdinal(ordinal);
    }

    public String getSlice() {
        return this.get("slice").orElse("");
    }

    public void setSlice(String slice) {
        this.set("slice", slice);
    }

    public AdjustableConstantNode withSlice(UnaryOperator<String> slice) {
        this.setSlice((String)slice.apply(this.getSlice()));
        return this;
    }

    public Constant.Condition[] getExpandZeroConditions() {
        return this.get("expandZeroConditions").orElse(new Constant.Condition[0]);
    }

    public void setExpandZeroConditions(Constant.Condition[] expandZeroConditions) {
        this.set("expandZeroConditions", expandZeroConditions);
    }

    public AdjustableConstantNode withExpandZeroConditions(UnaryOperator<Constant.Condition[]> expandZeroConditions) {
        this.setExpandZeroConditions((Constant.Condition[])expandZeroConditions.apply(this.getExpandZeroConditions()));
        return this;
    }

    public boolean getLog() {
        return this.get("log").orElse(false);
    }

    public void setLog(boolean log) {
        this.set("log", log);
    }

    public AdjustableConstantNode withLog(UnaryOperator<Boolean> log) {
        this.setLog((Boolean)log.apply(this.getLog()));
        return this;
    }
}

