/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.adjuster.tools;

import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.adjuster.tools.AdjustableDescNode;
import com.bawnorton.mixinsquared.adjuster.tools.RemapperHolderAnnotationNode;
import com.bawnorton.mixinsquared.adjuster.tools.type.OptionalIdAnnotationNode;
import com.bawnorton.mixinsquared.adjuster.tools.type.OrdinalAnnotationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.mixin.injection.At;

public class AdjustableAtNode
extends RemapperHolderAnnotationNode
implements OptionalIdAnnotationNode,
OrdinalAnnotationNode {
    public AdjustableAtNode(AnnotationNode node) {
        super(node);
    }

    public static AdjustableAtNode defaultNode(InjectionPoint point) {
        AnnotationNode node = new AnnotationNode(AdjustableAnnotationNode.KnownAnnotations.AT.desc());
        AdjustableAtNode defaultNode = new AdjustableAtNode(node);
        defaultNode.setValue(point.name());
        return defaultNode;
    }

    @Override
    public AdjustableAtNode withId(UnaryOperator<String> id) {
        return (AdjustableAtNode)OptionalIdAnnotationNode.super.withId(id);
    }

    public String getValue() {
        return this.get("value").orElse(null);
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.set("value", value);
    }

    public AdjustableAtNode withValue(UnaryOperator<String> value) {
        this.setValue((String)value.apply(this.getValue()));
        return this;
    }

    public String getSlice() {
        return this.get("slice").orElse("");
    }

    public void setSlice(String slice) {
        this.set("slice", slice);
    }

    public AdjustableAtNode withSlice(UnaryOperator<String> slice) {
        this.setSlice((String)slice.apply(this.getSlice()));
        return this;
    }

    public At.Shift getShift() {
        return this.getEnum("shift", At.Shift.class).orElse(At.Shift.NONE);
    }

    public void setShift(At.Shift shift) {
        this.set("shift", new String[]{Type.getDescriptor(At.Shift.class), shift.name()});
    }

    public AdjustableAtNode withShift(UnaryOperator<At.Shift> shift) {
        this.setShift((At.Shift)shift.apply(this.getShift()));
        return this;
    }

    public int getBy() {
        return this.get("by").orElse(0);
    }

    public void setBy(int by) {
        this.set("by", by);
    }

    public AdjustableAtNode withBy(UnaryOperator<Integer> by) {
        this.setBy((Integer)by.apply(this.getBy()));
        return this;
    }

    public List<String> getArgs() {
        return this.get("args").orElse(new ArrayList());
    }

    public void setArgs(List<String> args) {
        this.set("args", args);
    }

    public AdjustableAtNode withArgs(UnaryOperator<List<String>> args) {
        this.setArgs((List)args.apply(this.getArgs()));
        return this;
    }

    public String getTarget() {
        return this.get("target").orElse("");
    }

    public void setTarget(String target) {
        this.set("target", target);
    }

    public AdjustableAtNode withTarget(UnaryOperator<String> target) {
        this.setTarget((String)target.apply(this.getTarget()));
        return this;
    }

    public AdjustableDescNode getDesc() {
        return this.get("desc").map(AdjustableDescNode::new).orElse(AdjustableDescNode.defaultNode(""));
    }

    public void setDesc(AdjustableDescNode desc) {
        this.set("desc", desc);
    }

    public AdjustableAtNode withDesc(UnaryOperator<AdjustableDescNode> desc) {
        this.setDesc((AdjustableDescNode)desc.apply(this.getDesc()));
        return this;
    }

    @Override
    public AdjustableAtNode withOrdinal(UnaryOperator<Integer> ordinal) {
        return (AdjustableAtNode)OrdinalAnnotationNode.super.withOrdinal(ordinal);
    }

    public int getOpcode() {
        return this.get("opcode").orElse(-1);
    }

    public void setOpcode(int opcode) {
        this.set("opcode", opcode);
    }

    public AdjustableAtNode withOpcode(UnaryOperator<Integer> opcode) {
        this.setOpcode((Integer)opcode.apply(this.getOpcode()));
        return this;
    }

    public boolean getUnsafe() {
        return this.get("unsafe").orElse(false);
    }

    public void setUnsafe(boolean unsafe) {
        this.set("unsafe", unsafe);
    }

    public AdjustableAtNode withUnsafe(UnaryOperator<Boolean> unsafe) {
        this.setUnsafe((Boolean)unsafe.apply(this.getUnsafe()));
        return this;
    }

    @Override
    @ApiStatus.Internal
    public void applyRefmap(UnaryOperator<String> refmapApplicator) {
        this.withTarget(refmapApplicator);
        this.withArgs(args -> {
            ArrayList<String> remappedArgs = new ArrayList<String>();
            for (String arg : args) {
                remappedArgs.add((String)refmapApplicator.apply(arg));
            }
            return remappedArgs;
        });
    }

    public static enum InjectionPoint {
        HEAD,
        TAIL,
        INVOKE,
        INVOKE_ASSIGN,
        INVOKE_STRING,
        FIELD,
        NEW,
        CONSTANT,
        JUMP,
        CUSTOM;

        private String customName;

        public static InjectionPoint custom(String name) {
            InjectionPoint point = CUSTOM;
            point.customName = name;
            return point;
        }

        public AdjustableAtNode toNode() {
            if (this != CUSTOM) {
                return AdjustableAtNode.defaultNode(this);
            }
            return AdjustableAtNode.defaultNode(this).withValue(v -> {
                if (this.customName == null) {
                    throw new IllegalStateException("Custom InjectionPoint name not set");
                }
                return this.customName;
            });
        }
    }
}

