/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class DrawBatcher
implements AutoCloseable {
    private final Matrix4f matrix4f;
    private final BufferBuilder bufferBuilder;
    private final VertexConsumer vertexConsumer;
    private final float textureWidth;
    private final float textureHeight;
    private final int light;

    public DrawBatcher(PoseStack matrices, MultiBufferSource vertexConsumers, ResourceLocation texture, int textureWidth, int textureHeight, int light) {
        if (vertexConsumers == null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.setShader(GameRenderer::m_172835_);
            this.bufferBuilder = Tesselator.m_85913_().m_85915_();
            this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
            this.vertexConsumer = this.bufferBuilder;
        } else {
            this.bufferBuilder = null;
            this.vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110497_((ResourceLocation)texture));
        }
        this.matrix4f = matrices.m_85850_().m_252922_();
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.light = light;
    }

    public void add(int x, int y, float z, int width, int height, int u, int v, int regionWidth, int regionHeight, int argb) {
        this.innerAdd(x, x + width, y, y + height, z, ((float)u + 0.0f) / this.textureWidth, ((float)u + (float)regionWidth) / this.textureWidth, ((float)v + 0.0f) / this.textureHeight, ((float)v + (float)regionHeight) / this.textureHeight, argb);
    }

    private void innerAdd(float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2, int argb) {
        this.vertexConsumer.m_252986_(this.matrix4f, x1, y1, z).m_193479_(argb).m_7421_(u1, v1).m_85969_(this.light).m_5752_();
        this.vertexConsumer.m_252986_(this.matrix4f, x1, y2, z).m_193479_(argb).m_7421_(u1, v2).m_85969_(this.light).m_5752_();
        this.vertexConsumer.m_252986_(this.matrix4f, x2, y2, z).m_193479_(argb).m_7421_(u2, v2).m_85969_(this.light).m_5752_();
        this.vertexConsumer.m_252986_(this.matrix4f, x2, y1, z).m_193479_(argb).m_7421_(u2, v1).m_85969_(this.light).m_5752_();
    }

    @Override
    public void close() {
        if (this.bufferBuilder != null) {
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)this.bufferBuilder.m_231175_());
        }
    }
}

