/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.reloader;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AtlasStructureLandmark;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.StructureTileProvider;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.reloader.BiomeTileProviders;
import folk.sisby.antique_atlas.reloader.MarkerTextures;
import folk.sisby.antique_atlas.reloader.TileTextures;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.structure.JigsawPieceSummary;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import folk.sisby.surveyor.structure.StructureStartSummary;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;

public class StructureTileProviders
extends SimpleJsonResourceReloadListener
implements IdentifiableResourceReloadListener {
    private static final StructureTileProviders INSTANCE = new StructureTileProviders();
    public static final ResourceLocation ID = AntiqueAtlas.id("structures");
    private final Map<ResourceLocation, StructureTileProvider> startTiles = new HashMap<ResourceLocation, StructureTileProvider>();
    private final Map<ResourceLocation, StructureTileProvider> typeTiles = new HashMap<ResourceLocation, StructureTileProvider>();
    private final Map<ResourceLocation, StructureTileProvider> tagTiles = new HashMap<ResourceLocation, StructureTileProvider>();
    private final Map<ResourceLocation, StructureTileProvider> pieceTypeTiles = new HashMap<ResourceLocation, StructureTileProvider>();
    private final Map<ResourceLocation, StructureTileProvider> pieceJigsawSingleTiles = new HashMap<ResourceLocation, StructureTileProvider>();
    private final Map<ResourceLocation, StructureTileProvider> pieceJigsawFeatureTiles = new HashMap<ResourceLocation, StructureTileProvider>();
    private final Map<ResourceLocation, MarkerTexture> startMarkers = new HashMap<ResourceLocation, MarkerTexture>();
    private final Map<ResourceLocation, MarkerTexture> typeMarkers = new HashMap<ResourceLocation, MarkerTexture>();
    private final Map<ResourceLocation, MarkerTexture> tagMarkers = new HashMap<ResourceLocation, MarkerTexture>();
    private final Map<ResourceLocation, MarkerTexture> pieceTypeMarkers = new HashMap<ResourceLocation, MarkerTexture>();
    private final Map<ResourceLocation, MarkerTexture> pieceJigsawSingleMarkers = new HashMap<ResourceLocation, MarkerTexture>();
    private final Map<ResourceLocation, MarkerTexture> pieceJigsawFeatureMarkers = new HashMap<ResourceLocation, MarkerTexture>();
    private final Map<ProviderType, Pair<Map<ResourceLocation, StructureTileProvider>, Map<ResourceLocation, MarkerTexture>>> PROVIDER_MAPS = Map.of(ProviderType.START, Pair.of(this.startTiles, this.startMarkers), ProviderType.TYPE, Pair.of(this.typeTiles, this.typeMarkers), ProviderType.TAG, Pair.of(this.tagTiles, this.tagMarkers), ProviderType.PIECE_TYPE, Pair.of(this.pieceTypeTiles, this.pieceTypeMarkers), ProviderType.JIGSAW_SINGLE, Pair.of(this.pieceJigsawSingleTiles, this.pieceJigsawSingleMarkers), ProviderType.JIGSAW_FEATURE, Pair.of(this.pieceJigsawFeatureTiles, this.pieceJigsawFeatureMarkers));

    public static StructureTileProviders getInstance() {
        return INSTANCE;
    }

    public StructureTileProviders() {
        super(new Gson(), "atlas/structure");
    }

    public Map<ChunkPos, TileTexture> resolve(Map<ChunkPos, TileTexture> outTiles, Map<ChunkPos, StructureTileProvider> structureProviders, Map<ChunkPos, String> tilePredicates, StructurePieceSummary piece, Level world) {
        if (piece instanceof JigsawPieceSummary) {
            JigsawPieceSummary jigsawPiece = (JigsawPieceSummary)piece;
            if (this.pieceJigsawSingleTiles.containsKey(jigsawPiece.getId())) {
                StructureTileProvider provider = (jigsawPiece.getElementType() == StructurePoolElementType.f_210544_ ? this.pieceJigsawFeatureTiles : this.pieceJigsawSingleTiles).get(jigsawPiece.getId());
                provider.getTextures(world, jigsawPiece.m_73547_(), jigsawPiece.getJunctions(), tilePredicates).forEach((pos, texture) -> {
                    if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                        return;
                    }
                    outTiles.put((ChunkPos)pos, (TileTexture)texture);
                    structureProviders.put((ChunkPos)pos, provider);
                });
                return outTiles;
            }
        } else {
            ResourceLocation pieceTypeId = BuiltInRegistries.f_257014_.m_7981_((Object)piece.m_210000_());
            if (this.pieceTypeTiles.containsKey(pieceTypeId)) {
                StructureTileProvider provider = this.pieceTypeTiles.get(pieceTypeId);
                provider.getTextures(world, piece.m_73547_(), tilePredicates).forEach((pos, texture) -> {
                    if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                        return;
                    }
                    outTiles.put((ChunkPos)pos, (TileTexture)texture);
                    structureProviders.put((ChunkPos)pos, provider);
                });
            }
        }
        return outTiles;
    }

    public void resolve(Map<ChunkPos, TileTexture> outTiles, Map<ChunkPos, StructureTileProvider> structureProviders, Map<ChunkPos, String> debugPredicates, Map<Landmark<?>, MarkerTexture> outMarkers, Level world, ResourceKey<Structure> key, ChunkPos pos, StructureStartSummary summary, ResourceKey<StructureType<?>> type, Collection<TagKey<Structure>> tags) {
        if (this.startMarkers.containsKey(key.m_135782_())) {
            texture = this.startMarkers.get(key.m_135782_());
            outMarkers.put(new AtlasStructureLandmark(pos.m_151394_(0), ProviderType.START, key.m_135782_()), texture);
        } else if (type != null && this.typeMarkers.containsKey(type.m_135782_())) {
            texture = this.typeMarkers.get(type.m_135782_());
            outMarkers.put(new AtlasStructureLandmark(pos.m_151394_(0), ProviderType.TYPE, type.m_135782_()), texture);
        } else {
            this.tagMarkers.entrySet().stream().filter(entry -> tags.contains(TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)((ResourceLocation)entry.getKey())))).findFirst().ifPresent(entry -> outMarkers.put(new AtlasStructureLandmark(pos.m_151394_(0), ProviderType.TAG, (ResourceLocation)entry.getKey()), (MarkerTexture)entry.getValue()));
        }
        if (this.startTiles.containsKey(key.m_135782_())) {
            provider = this.startTiles.get(key.m_135782_());
            provider.getTextures(world, summary.getBoundingBox(), debugPredicates).forEach((pos2, texture) -> {
                if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                    return;
                }
                outTiles.put((ChunkPos)pos2, (TileTexture)texture);
                structureProviders.put((ChunkPos)pos2, provider);
            });
        } else if (type != null && this.typeTiles.containsKey(type.m_135782_())) {
            provider = this.typeTiles.get(key.m_135782_());
            provider.getTextures(world, summary.getBoundingBox(), debugPredicates).forEach((pos2, texture) -> {
                if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                    return;
                }
                outTiles.put((ChunkPos)pos2, (TileTexture)texture);
                structureProviders.put((ChunkPos)pos2, provider);
            });
        } else {
            tags.stream().filter(t -> this.tagTiles.containsKey(t.f_203868_())).findFirst().ifPresent(tag -> {
                StructureTileProvider provider = this.tagTiles.get(tag.f_203868_());
                provider.getTextures(world, summary.getBoundingBox(), debugPredicates).forEach((pos2, texture) -> {
                    if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                        return;
                    }
                    outTiles.put((ChunkPos)pos2, (TileTexture)texture);
                    structureProviders.put((ChunkPos)pos2, provider);
                });
            });
        }
        summary.getChildren().forEach(p -> this.resolve(outTiles, structureProviders, debugPredicates, (StructurePieceSummary)p, world));
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Reloading Structure Tile / Marker Providers...");
        Map<ResourceLocation, TileTexture> textures = TileTextures.getInstance().getTextures();
        HashSet<TileTexture> unusedTextures = new HashSet<TileTexture>(textures.values().stream().filter(t -> t.id().m_135815_().startsWith("structure")).toList());
        this.PROVIDER_MAPS.values().forEach(p -> ((Map)p.left()).clear());
        this.PROVIDER_MAPS.values().forEach(p -> ((Map)p.right()).clear());
        for (Map.Entry<ResourceLocation, JsonElement> fileEntry : prepared.entrySet()) {
            ResourceLocation fileId = fileEntry.getKey();
            this.PROVIDER_MAPS.forEach((providerType, pair) -> {
                Map providerMap = (Map)pair.left();
                Map markerMap = (Map)pair.right();
                if (fileId.m_135815_().startsWith(providerType.prefix())) {
                    ResourceLocation id = new ResourceLocation(fileId.m_135827_(), fileId.m_135815_().substring(providerType.prefix().length()));
                    try {
                        JsonObject fileJson = ((JsonElement)fileEntry.getValue()).getAsJsonObject();
                        if (fileJson.has("textures")) {
                            JsonElement textureJson = fileJson.get("textures");
                            int priority = fileJson.has("priority") ? fileJson.get("priority").getAsInt() : 999;
                            List<TileTexture> defaultTextures = BiomeTileProviders.resolveTextureJson(textures, textureJson);
                            if (defaultTextures != null) {
                                StructureTileProvider provider = new StructureTileProvider(id, priority, defaultTextures);
                                providerMap.put(provider.id(), provider);
                                unusedTextures.removeAll(provider.allTextures());
                            } else {
                                JsonObject textureObject = textureJson.getAsJsonObject();
                                HashMap<StructureTileProvider.ChunkMatcher, List<TileTexture>> matchers = new HashMap<StructureTileProvider.ChunkMatcher, List<TileTexture>>();
                                for (String matcherKey : textureObject.keySet()) {
                                    ResourceLocation matcherId = matcherKey.contains(":") ? new ResourceLocation(matcherKey) : AntiqueAtlas.id(matcherKey);
                                    StructureTileProvider.ChunkMatcher matcher = StructureTileProvider.getChunkMatcher(matcherId);
                                    if (matcher == null) {
                                        throw new IllegalStateException("Matcher %s does not exist!".formatted(matcherId.toString()));
                                    }
                                    List<TileTexture> matcherTextures = BiomeTileProviders.resolveTextureJson(textures, textureObject.get(matcherKey));
                                    if (matcherTextures == null) {
                                        throw new IllegalStateException("Malformed object %s in textures object!".formatted(matcherId.toString()));
                                    }
                                    matcherTextures.forEach(unusedTextures::remove);
                                    matchers.put(matcher, matcherTextures);
                                }
                                if (matchers.isEmpty()) {
                                    throw new IllegalStateException("No matcher keys were found in the textures object!");
                                }
                                StructureTileProvider provider = new StructureTileProvider(id, priority, matchers);
                                providerMap.put(provider.id(), provider);
                                unusedTextures.removeAll(provider.allTextures());
                            }
                        }
                        if (fileJson.has("markers")) {
                            JsonElement markerJson = fileJson.get("markers");
                            ResourceLocation markerTextureId = new ResourceLocation(markerJson.getAsString());
                            MarkerTexture texture = MarkerTextures.getInstance().asMap().get(markerTextureId);
                            if (texture == null) {
                                throw new IllegalStateException("Marker texture %s does not exist!".formatted(markerTextureId));
                            }
                            AntiqueAtlas.CONFIG.structureMarkers.putIfAbsent(fileId.toString(), true);
                            if (AntiqueAtlas.CONFIG.structureMarkers.get(fileId.toString()).booleanValue()) {
                                markerMap.put(id, texture);
                            }
                        }
                    }
                    catch (Exception e) {
                        AntiqueAtlas.LOGGER.error("[Antique Atlas] Error reading structure tile provider {}!", (Object)fileId, (Object)e);
                    }
                }
            });
        }
        for (TileTexture texture : unusedTextures) {
            AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} isn't referenced by any structure tile provider!", (Object)texture.displayId());
        }
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    public Collection<ResourceLocation> getFabricDependencies() {
        return List.of(TileTextures.ID, MarkerTextures.ID);
    }

    public static enum ProviderType {
        START("start"),
        TAG("tag"),
        TYPE("type"),
        PIECE_TYPE("piece/type"),
        JIGSAW_SINGLE("piece/jigsaw/single"),
        JIGSAW_FEATURE("piece/jigsaw/feature");

        private final String key;

        private ProviderType(String key) {
            this.key = key;
        }

        public String prefix() {
            return this.key + "/";
        }

        public String translation(ResourceLocation id) {
            return "structure.%s.%s".formatted(this.key.replace('/', '.'), id.toString().replace(':', '.'));
        }
    }
}

