/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.reloader;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import folk.sisby.antique_atlas.TerrainTileProvider;
import folk.sisby.antique_atlas.TileElevation;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.reloader.TileTextures;
import folk.sisby.antique_atlas.util.ForgeTags;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.Nullable;

public class BiomeTileProviders
extends SimpleJsonResourceReloadListener
implements IdentifiableResourceReloadListener {
    private static final BiomeTileProviders INSTANCE = new BiomeTileProviders();
    public static final ResourceLocation ID = AntiqueAtlas.id("tile_provider/biome");
    private final Map<ResourceLocation, TerrainTileProvider> tileProviders = new HashMap<ResourceLocation, TerrainTileProvider>();
    private final Map<ResourceLocation, ResourceLocation> biomeFallbacks = new HashMap<ResourceLocation, ResourceLocation>();
    private boolean hasFallbacks = false;

    public static BiomeTileProviders getInstance() {
        return INSTANCE;
    }

    public BiomeTileProviders() {
        super(new Gson(), "atlas/biome");
    }

    public TerrainTileProvider getTileProvider(ResourceLocation providerId) {
        return this.tileProviders.getOrDefault(providerId, this.tileProviders.getOrDefault(this.biomeFallbacks.get(providerId), TerrainTileProvider.DEFAULT));
    }

    public void registerFallbacks(Registry<Biome> biomeRegistry) {
        for (Biome biome : biomeRegistry) {
            ResourceLocation biomeId = biomeRegistry.m_7981_((Object)biome);
            if (this.tileProviders.containsKey(biomeId)) continue;
            ResourceLocation fallbackBiome = BiomeTileProviders.getFallbackBiome((Holder<Biome>)biomeRegistry.m_263177_((Object)biome));
            if (fallbackBiome != null && this.tileProviders.containsKey(fallbackBiome)) {
                this.biomeFallbacks.put(biomeId, fallbackBiome);
                AntiqueAtlas.LOGGER.info("[Antique Atlas] Set fallback biome for {} to {}. You can set a more fitting texture using a resource pack!", (Object)biomeId, (Object)fallbackBiome);
                continue;
            }
            if (fallbackBiome != null) {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Fallback biome for {} is {}, which has no defined tile provider.", (Object)biomeId, (Object)fallbackBiome);
                continue;
            }
            AntiqueAtlas.LOGGER.warn("[Antique Atlas] No fallback could be found for {}. This shouldn't happen! This means the biome is not in ANY conventional or vanilla tag on the client!", (Object)biomeId);
            if (AntiqueAtlas.CONFIG.fallbackFailHandling != AntiqueAtlasConfig.FallbackHandling.CRASH) continue;
            throw new IllegalStateException("Antique Atlas fallback biome registration failed! Fix the missing biome or change fallbackFailHandling in antique_atlas.toml");
        }
        this.hasFallbacks = true;
    }

    public void clearFallbacks() {
        this.hasFallbacks = false;
        this.biomeFallbacks.clear();
    }

    public boolean hasFallbacks() {
        return this.hasFallbacks;
    }

    private static ResourceLocation getFallbackBiome(Holder<Biome> biome) {
        if (biome.m_203656_(ConventionalBiomeTags.VOID) || biome.m_203656_(ForgeTags.Biomes.IS_VOID)) {
            return Biomes.f_48173_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_215818_) || biome.m_203656_(ConventionalBiomeTags.IN_THE_END) || biome.m_203656_(ConventionalBiomeTags.END_ISLANDS)) {
            if (biome.m_203656_(ConventionalBiomeTags.VEGETATION_DENSE) || biome.m_203656_(ConventionalBiomeTags.VEGETATION_SPARSE) || biome.m_203656_(ForgeTags.Biomes.IS_LUSH)) {
                return Biomes.f_48164_.m_135782_();
            }
            return Biomes.f_48165_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.NETHER_FORESTS)) {
            return Biomes.f_48201_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_207612_) || biome.m_203656_(ConventionalBiomeTags.IN_NETHER)) {
            return Biomes.f_48199_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.SWAMP) || biome.m_203656_(ForgeTags.Biomes.IS_SWAMP)) {
            return Biomes.f_48207_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207602_) || biome.m_203656_(ConventionalBiomeTags.DEEP_OCEAN) || biome.m_203656_(ConventionalBiomeTags.OCEAN) || biome.m_203656_(ConventionalBiomeTags.SHALLOW_OCEAN) || biome.m_203656_(BiomeTags.f_207605_) || biome.m_203656_(ConventionalBiomeTags.RIVER) || biome.m_203656_(ConventionalBiomeTags.AQUATIC) || biome.m_203656_(ConventionalBiomeTags.AQUATIC_ICY) || biome.m_203656_(ForgeTags.Biomes.IS_WATER)) {
            if (biome.m_203656_(ConventionalBiomeTags.ICY) || biome.m_203656_(ConventionalBiomeTags.AQUATIC_ICY)) {
                return Biomes.f_48212_.m_135782_();
            }
            return Biomes.f_48208_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.STONY_SHORES)) {
            return Biomes.f_186760_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_207604_) || biome.m_203656_(ConventionalBiomeTags.BEACH)) {
            return Biomes.f_48217_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_207610_) || biome.m_203656_(ConventionalBiomeTags.JUNGLE) || biome.m_203656_(ConventionalBiomeTags.TREE_JUNGLE)) {
            return Biomes.f_48222_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.FLOWER_FORESTS) || biome.m_203656_(ConventionalBiomeTags.FLORAL)) {
            return Biomes.f_48179_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_215816_) || biome.m_203656_(ConventionalBiomeTags.SAVANNA) || biome.m_203656_(ConventionalBiomeTags.TREE_SAVANNA)) {
            return Biomes.f_48157_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_207607_) || biome.m_203656_(ConventionalBiomeTags.BADLANDS) || biome.m_203656_(ConventionalBiomeTags.MESA)) {
            return Biomes.f_48159_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.TREE_CONIFEROUS) || biome.m_203656_(ForgeTags.Biomes.IS_CONIFEROUS) || biome.m_203656_(BiomeTags.f_207609_) || biome.m_203656_(ConventionalBiomeTags.TAIGA)) {
            if (biome.m_203656_(ConventionalBiomeTags.ICY) || biome.m_203656_(ConventionalBiomeTags.SNOWY)) {
                return Biomes.f_48152_.m_135782_();
            }
            return Biomes.f_48206_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.BIRCH_FOREST) || biome.m_203656_(ConventionalBiomeTags.TREE_DECIDUOUS)) {
            return Biomes.f_48149_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_207611_) || biome.m_203656_(ConventionalBiomeTags.FOREST)) {
            return Biomes.f_48205_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.PLAINS) || biome.m_203656_(ConventionalBiomeTags.SNOWY_PLAINS) || biome.m_203656_(ForgeTags.Biomes.IS_PLAINS) || biome.m_203656_(ConventionalBiomeTags.SNOWY) || biome.m_203656_(ForgeTags.Biomes.IS_SNOWY)) {
            if (biome.m_203656_(ConventionalBiomeTags.ICY) || biome.m_203656_(ConventionalBiomeTags.SNOWY)) {
                return Biomes.f_186761_.m_135782_();
            }
            return Biomes.f_48202_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.DESERT) || biome.m_203656_(ConventionalBiomeTags.WASTELAND) || biome.m_203656_(ConventionalBiomeTags.DEAD) || biome.m_203656_(ForgeTags.Biomes.IS_SANDY) || biome.m_203656_(ForgeTags.Biomes.IS_DESERT) || biome.m_203656_(ForgeTags.Biomes.IS_DEAD) || biome.m_203656_(ForgeTags.Biomes.IS_WASTELAND)) {
            return Biomes.f_48203_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.ICY)) {
            return Biomes.f_48211_.m_135782_();
        }
        if (biome.m_203656_(ForgeTags.Biomes.IS_PLATEAU)) {
            return Biomes.f_186754_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.EXTREME_HILLS) || biome.m_203656_(ConventionalBiomeTags.WINDSWEPT)) {
            return Biomes.f_186765_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.MOUNTAIN_PEAK) || biome.m_203656_(ForgeTags.Biomes.IS_PEAK)) {
            return Biomes.f_186758_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_207606_) || biome.m_203656_(ConventionalBiomeTags.MOUNTAIN) || biome.m_203656_(ConventionalBiomeTags.MOUNTAIN_SLOPE) || biome.m_203656_(ForgeTags.Biomes.IS_SLOPE) || biome.m_203656_(ForgeTags.Biomes.IS_MOUNTAIN)) {
            return Biomes.f_186759_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.MUSHROOM) || biome.m_203656_(ForgeTags.Biomes.IS_MUSHROOM)) {
            return Biomes.f_48215_.m_135782_();
        }
        if (biome.m_203656_(BiomeTags.f_207608_)) {
            return Biomes.f_186766_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.CAVES) || biome.m_203656_(ConventionalBiomeTags.UNDERGROUND) || biome.m_203656_(ForgeTags.Biomes.IS_UNDERGROUND) || biome.m_203656_(ForgeTags.Biomes.IS_CAVE)) {
            return Biomes.f_151784_.m_135782_();
        }
        if (biome.m_203656_(ForgeTags.Biomes.IS_SPOOKY)) {
            return Biomes.f_48151_.m_135782_();
        }
        if (biome.m_203656_(ForgeTags.Biomes.IS_MAGICAL)) {
            return Biomes.f_48215_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.VEGETATION_DENSE) || biome.m_203656_(ForgeTags.Biomes.IS_DENSE)) {
            return Biomes.f_48205_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.VEGETATION_SPARSE) || biome.m_203656_(ForgeTags.Biomes.IS_SPARSE)) {
            return Biomes.f_48202_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.CLIMATE_HOT) || biome.m_203656_(ForgeTags.Biomes.IS_HOT)) {
            return Biomes.f_48203_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.CLIMATE_COLD) || biome.m_203656_(ForgeTags.Biomes.IS_COLD)) {
            return Biomes.f_186761_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.CLIMATE_TEMPERATE)) {
            return Biomes.f_48202_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.CLIMATE_DRY) || biome.m_203656_(ForgeTags.Biomes.IS_DRY)) {
            return Biomes.f_48159_.m_135782_();
        }
        if (biome.m_203656_(ConventionalBiomeTags.CLIMATE_WET) || biome.m_203656_(ForgeTags.Biomes.IS_WET)) {
            return Biomes.f_48207_.m_135782_();
        }
        return null;
    }

    public static TileTexture getTexture(Map<ResourceLocation, TileTexture> textures, ResourceLocation id) {
        if (textures.containsKey(id)) {
            return textures.get(id);
        }
        throw new IllegalStateException("texture %s is not present!".formatted(id));
    }

    @Nullable
    public static List<TileTexture> resolveTextureJson(Map<ResourceLocation, TileTexture> textures, JsonElement textureJson) {
        JsonObject textureObject;
        JsonPrimitive texturePrimitive;
        if (textureJson instanceof JsonPrimitive && (texturePrimitive = (JsonPrimitive)textureJson).isString()) {
            return List.of(BiomeTileProviders.getTexture(textures, new ResourceLocation(texturePrimitive.getAsString())));
        }
        if (textureJson instanceof JsonArray) {
            JsonArray textureArray = (JsonArray)textureJson;
            return textureArray.asList().stream().map(je -> BiomeTileProviders.getTexture(textures, new ResourceLocation(je.getAsString()))).toList();
        }
        if (textureJson instanceof JsonObject && (textureObject = (JsonObject)textureJson).keySet().stream().allMatch(k -> {
            JsonPrimitive jp;
            JsonElement patt0$temp = textureObject.get(k);
            return patt0$temp instanceof JsonPrimitive && (jp = (JsonPrimitive)patt0$temp).isNumber();
        })) {
            HashMultiset outList = HashMultiset.create();
            textureObject.entrySet().forEach(arg_0 -> BiomeTileProviders.lambda$resolveTextureJson$2((Multiset)outList, textures, arg_0));
            return outList.stream().toList();
        }
        return null;
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Reloading Biome Tile Providers...");
        Map<ResourceLocation, TileTexture> textures = TileTextures.getInstance().getTextures();
        HashSet<TileTexture> unusedTextures = new HashSet<TileTexture>(textures.values().stream().filter(t -> t.id().m_135815_().startsWith("biome")).toList());
        HashMap<ResourceLocation, ResourceLocation> providerParents = new HashMap<ResourceLocation, ResourceLocation>();
        for (Map.Entry<ResourceLocation, JsonElement> fileEntry : prepared.entrySet()) {
            ResourceLocation fileId = fileEntry.getKey();
            try {
                JsonObject fileJson = fileEntry.getValue().getAsJsonObject();
                if (fileJson.has("parent")) {
                    ResourceLocation parentId2 = new ResourceLocation(fileJson.getAsJsonPrimitive("parent").getAsString());
                    providerParents.put(fileId, parentId2);
                    continue;
                }
                JsonElement textureJson = fileJson.get("textures");
                List<TileTexture> defaultTextures = BiomeTileProviders.resolveTextureJson(textures, textureJson);
                if (defaultTextures != null) {
                    defaultTextures.forEach(unusedTextures::remove);
                    this.tileProviders.put(fileId, new TerrainTileProvider(fileId, defaultTextures));
                    continue;
                }
                JsonObject textureObject = textureJson.getAsJsonObject();
                HashMap<TileElevation, List<TileTexture>> textureElevations = new HashMap<TileElevation, List<TileTexture>>();
                HashSet<TileElevation> skippedElevations = new HashSet<TileElevation>();
                List<TileTexture> elevationTextures = null;
                for (TileElevation elevation : TileElevation.values()) {
                    if (textureObject.has(elevation.getName())) {
                        elevationTextures = BiomeTileProviders.resolveTextureJson(textures, textureObject.get(elevation.getName()));
                        if (elevationTextures == null) {
                            throw new IllegalStateException("Malformed object %s in textures object!".formatted(elevation.getName()));
                        }
                        elevationTextures.forEach(unusedTextures::remove);
                        textureElevations.put(elevation, elevationTextures);
                        for (TileElevation skipped : skippedElevations) {
                            textureElevations.put(skipped, elevationTextures);
                        }
                        skippedElevations.clear();
                        continue;
                    }
                    skippedElevations.add(elevation);
                }
                if (textureElevations.isEmpty()) {
                    throw new IllegalStateException("No elevation keys were found in the textures object!");
                }
                for (TileElevation elevation : skippedElevations) {
                    textureElevations.put(elevation, elevationTextures);
                }
                this.tileProviders.put(fileId, new TerrainTileProvider(fileId, textureElevations));
            }
            catch (Exception e) {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Error reading biome tile provider {}!", (Object)fileId, (Object)e);
            }
        }
        providerParents.forEach((id, parentId) -> {
            if (this.tileProviders.containsKey(parentId)) {
                this.tileProviders.put((ResourceLocation)id, this.tileProviders.get(parentId));
            } else {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Error reading biome tile provider {}!", id, (Object)new IllegalStateException("Parent id %s doesn't exist".formatted(parentId)));
            }
        });
        for (TileTexture texture : unusedTextures) {
            if (texture.displayId().startsWith("test") || texture.displayId().startsWith("base")) continue;
            AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} isn't referenced by any biome tile provider!", (Object)texture.displayId());
        }
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    public Collection<ResourceLocation> getFabricDependencies() {
        return List.of(TileTextures.ID);
    }

    private static /* synthetic */ void lambda$resolveTextureJson$2(Multiset outList, Map textures, Map.Entry e) {
        outList.add((Object)BiomeTileProviders.getTexture(textures, new ResourceLocation((String)e.getKey())), ((JsonElement)e.getValue()).getAsInt());
    }
}

