/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui.core;

import folk.sisby.antique_atlas.gui.core.ButtonComponent;
import folk.sisby.antique_atlas.gui.core.IButtonListener;
import folk.sisby.antique_atlas.gui.core.ISelectListener;
import folk.sisby.antique_atlas.gui.core.ToggleButtonComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ToggleButtonRadioGroup<B extends ToggleButtonComponent>
implements Iterable<B> {
    private final List<B> buttons = new ArrayList<B>();
    private final List<ISelectListener<? extends B>> listeners = new ArrayList<ISelectListener<? extends B>>();
    private B selectedButton = null;
    private final ClickListener clickListener = new ClickListener();

    public boolean addButton(B button) {
        if (!this.buttons.contains(button)) {
            this.buttons.add(button);
            ((ButtonComponent)((Object)button)).addListener(this.clickListener);
            return true;
        }
        return false;
    }

    public void setSelectedButton(B button) {
        if (this.buttons.contains(button)) {
            if (this.selectedButton != null) {
                ((ToggleButtonComponent)((Object)this.selectedButton)).setSelected(false);
            }
            ((ToggleButtonComponent)((Object)button)).setSelected(true);
            this.selectedButton = button;
        }
    }

    @Override
    @NotNull
    public Iterator<B> iterator() {
        return this.buttons.iterator();
    }

    public void addListener(ISelectListener<? extends B> listener) {
        this.listeners.add(listener);
    }

    private class ClickListener
    implements IButtonListener<B> {
        private ClickListener() {
        }

        @Override
        public void onClick(B button) {
            if (button != ToggleButtonRadioGroup.this.selectedButton) {
                if (ToggleButtonRadioGroup.this.selectedButton != null) {
                    ((ToggleButtonComponent)((Object)ToggleButtonRadioGroup.this.selectedButton)).setSelected(false);
                }
                ToggleButtonRadioGroup.this.selectedButton = button;
                for (ISelectListener listener : ToggleButtonRadioGroup.this.listeners) {
                    listener.onSelect(ToggleButtonRadioGroup.this.selectedButton);
                }
            }
        }
    }
}

