/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public final class TileTexture {
    public static final TileTexture DEFAULT = TileTexture.empty(AntiqueAtlas.id(AntiqueAtlas.CONFIG.fallbackFailHandling == AntiqueAtlasConfig.FallbackHandling.TEST ? "test" : "missing"), false);
    private final ResourceLocation id;
    private final boolean innerBorder;
    private final Set<TileTexture> tilesTo;
    private final Set<TileTexture> tilesToHorizontal;
    private final Set<TileTexture> tilesToVertical;

    public static TileTexture empty(ResourceLocation id, boolean innerBorder) {
        return new TileTexture(new ResourceLocation(id.m_135827_(), "textures/atlas/tile/%s.png".formatted(id.m_135815_())), innerBorder, (Set<TileTexture>)new ReferenceOpenHashSet(), (Set<TileTexture>)new ReferenceOpenHashSet(), (Set<TileTexture>)new ReferenceOpenHashSet());
    }

    public TileTexture(ResourceLocation id, boolean innerBorder, Set<TileTexture> tilesTo, Set<TileTexture> tilesToHorizontal, Set<TileTexture> tilesToVertical) {
        this.id = id;
        this.innerBorder = innerBorder;
        this.tilesTo = tilesTo;
        this.tilesToHorizontal = tilesToHorizontal;
        this.tilesToVertical = tilesToVertical;
    }

    public String displayId() {
        String trimmedPath = this.id.m_135815_().substring("textures/atlas/tile/".length(), this.id.m_135815_().length() - 4);
        return this.id.m_135827_().equals("antique_atlas") ? trimmedPath : new ResourceLocation(this.id.m_135827_(), trimmedPath).toString();
    }

    public boolean tiles(TileTexture other) {
        return this == other || this.innerBorder ^ (this.tilesTo.contains(other) || this.tilesToHorizontal.contains(other) || this.tilesToVertical.contains(other));
    }

    public boolean tilesHorizontally(TileTexture other) {
        return this == other || this.innerBorder ^ (this.tilesTo.contains(other) || this.tilesToHorizontal.contains(other));
    }

    public boolean tilesVertically(TileTexture other) {
        return this == other || this.innerBorder ^ (this.tilesTo.contains(other) || this.tilesToVertical.contains(other));
    }

    public ResourceLocation id() {
        return this.id;
    }

    public record Builder(ResourceLocation id, boolean innerBorder, Set<ResourceLocation> tilesTo, Set<ResourceLocation> tilesToHorizontal, Set<ResourceLocation> tilesToVertical) {
        public TileTexture build(Map<ResourceLocation, TileTexture> emptyTextures) {
            TileTexture emptyTexture = emptyTextures.get(this.id);
            if (!this.tilesTo.isEmpty()) {
                emptyTexture.tilesTo.addAll(this.tilesTo.stream().map(emptyTextures::get).collect(Collectors.toSet()));
            }
            if (!this.tilesToHorizontal.isEmpty()) {
                emptyTexture.tilesToHorizontal.addAll(this.tilesToHorizontal.stream().map(emptyTextures::get).collect(Collectors.toSet()));
            }
            if (!this.tilesToVertical.isEmpty()) {
                emptyTexture.tilesToVertical.addAll(this.tilesToVertical.stream().map(emptyTextures::get).collect(Collectors.toSet()));
            }
            return emptyTexture;
        }
    }
}

