/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.FloatListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractRangeFieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class FloatFieldBuilder
extends AbstractRangeFieldBuilder<Float, FloatListEntry, FloatFieldBuilder> {
    public FloatFieldBuilder(Component resetButtonKey, Component fieldNameKey, float value) {
        super(resetButtonKey, fieldNameKey);
        this.value = Float.valueOf(value);
    }

    @Override
    public FloatFieldBuilder setErrorSupplier(Function<Float, Optional<Component>> errorSupplier) {
        return (FloatFieldBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public FloatFieldBuilder requireRestart() {
        return (FloatFieldBuilder)super.requireRestart();
    }

    @Override
    public FloatFieldBuilder setSaveConsumer(Consumer<Float> saveConsumer) {
        return (FloatFieldBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public FloatFieldBuilder setDefaultValue(Supplier<Float> defaultValue) {
        return (FloatFieldBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public FloatFieldBuilder setDefaultValue(float defaultValue) {
        this.defaultValue = () -> Float.valueOf(defaultValue);
        return this;
    }

    @Override
    public FloatFieldBuilder setTooltipSupplier(Function<Float, Optional<Component[]>> tooltipSupplier) {
        return (FloatFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public FloatFieldBuilder setTooltipSupplier(Supplier<Optional<Component[]>> tooltipSupplier) {
        return (FloatFieldBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public FloatFieldBuilder setTooltip(Optional<Component[]> tooltip) {
        return (FloatFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    public FloatFieldBuilder setTooltip(Component ... tooltip) {
        return (FloatFieldBuilder)super.setTooltip(tooltip);
    }

    @Override
    public FloatFieldBuilder setMin(float min) {
        this.min = Float.valueOf(min);
        return this;
    }

    @Override
    public FloatFieldBuilder setMax(float max) {
        this.max = Float.valueOf(max);
        return this;
    }

    @Override
    public FloatFieldBuilder removeMin() {
        return (FloatFieldBuilder)super.removeMin();
    }

    @Override
    public FloatFieldBuilder removeMax() {
        return (FloatFieldBuilder)super.removeMax();
    }

    @Override
    @NotNull
    public FloatListEntry build() {
        FloatListEntry entry = new FloatListEntry(this.getFieldNameKey(), (Float)this.value, this.getResetButtonKey(), this.defaultValue, this.getSaveConsumer(), null, this.isRequireRestart());
        if (this.min != null) {
            entry.setMinimum(((Float)this.min).floatValue());
        }
        if (this.max != null) {
            entry.setMaximum(((Float)this.max).floatValue());
        }
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

