/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.DoubleListListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractRangeListBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class DoubleListBuilder
extends AbstractRangeListBuilder<Double, DoubleListListEntry, DoubleListBuilder> {
    private Function<DoubleListListEntry, DoubleListListEntry.DoubleListCell> createNewInstance;

    public DoubleListBuilder(Component resetButtonKey, Component fieldNameKey, List<Double> value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    @Override
    public Function<Double, Optional<Component>> getCellErrorSupplier() {
        return super.getCellErrorSupplier();
    }

    @Override
    public DoubleListBuilder setCellErrorSupplier(Function<Double, Optional<Component>> cellErrorSupplier) {
        return (DoubleListBuilder)super.setCellErrorSupplier(cellErrorSupplier);
    }

    @Override
    public DoubleListBuilder setErrorSupplier(Function<List<Double>, Optional<Component>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    @Override
    public DoubleListBuilder setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        return (DoubleListBuilder)super.setDeleteButtonEnabled(deleteButtonEnabled);
    }

    @Override
    public DoubleListBuilder setInsertInFront(boolean insertInFront) {
        return (DoubleListBuilder)super.setInsertInFront(insertInFront);
    }

    @Override
    public DoubleListBuilder setAddButtonTooltip(Component addTooltip) {
        return (DoubleListBuilder)super.setAddButtonTooltip(addTooltip);
    }

    @Override
    public DoubleListBuilder setRemoveButtonTooltip(Component removeTooltip) {
        return (DoubleListBuilder)super.setRemoveButtonTooltip(removeTooltip);
    }

    @Override
    public DoubleListBuilder requireRestart() {
        return (DoubleListBuilder)super.requireRestart();
    }

    public DoubleListBuilder setCreateNewInstance(Function<DoubleListListEntry, DoubleListListEntry.DoubleListCell> createNewInstance) {
        this.createNewInstance = createNewInstance;
        return this;
    }

    @Override
    public DoubleListBuilder setExpanded(boolean expanded) {
        return (DoubleListBuilder)super.setExpanded(expanded);
    }

    @Override
    public DoubleListBuilder setSaveConsumer(Consumer<List<Double>> saveConsumer) {
        return (DoubleListBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public DoubleListBuilder setDefaultValue(Supplier<List<Double>> defaultValue) {
        return (DoubleListBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public DoubleListBuilder setMin(double min) {
        this.min = min;
        return this;
    }

    @Override
    public DoubleListBuilder setMax(double max) {
        this.max = max;
        return this;
    }

    @Override
    public DoubleListBuilder removeMin() {
        return (DoubleListBuilder)super.removeMin();
    }

    @Override
    public DoubleListBuilder removeMax() {
        return (DoubleListBuilder)super.removeMax();
    }

    @Override
    public DoubleListBuilder setDefaultValue(List<Double> defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    @Override
    public DoubleListBuilder setTooltipSupplier(Function<List<Double>, Optional<Component[]>> tooltipSupplier) {
        return (DoubleListBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public DoubleListBuilder setTooltipSupplier(Supplier<Optional<Component[]>> tooltipSupplier) {
        return (DoubleListBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public DoubleListBuilder setTooltip(Optional<Component[]> tooltip) {
        return (DoubleListBuilder)super.setTooltip(tooltip);
    }

    @Override
    public DoubleListBuilder setTooltip(Component ... tooltip) {
        return (DoubleListBuilder)super.setTooltip(tooltip);
    }

    @Override
    @NotNull
    public DoubleListListEntry build() {
        DoubleListListEntry entry = new DoubleListListEntry(this.getFieldNameKey(), (List)this.value, this.isExpanded(), null, this.getSaveConsumer(), this.defaultValue, this.getResetButtonKey(), this.requireRestart, this.isDeleteButtonEnabled(), this.isInsertInFront());
        if (this.min != null) {
            entry.setMinimum((Double)this.min);
        }
        if (this.max != null) {
            entry.setMaximum((Double)this.max);
        }
        if (this.createNewInstance != null) {
            entry.setCreateNewInstance(this.createNewInstance);
        }
        entry.setInsertButtonEnabled(this.isInsertButtonEnabled());
        entry.setCellErrorSupplier(this.cellErrorSupplier);
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        entry.setAddTooltip(this.getAddTooltip());
        entry.setRemoveTooltip(this.getRemoveTooltip());
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

