/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractListListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractTextFieldListListEntry<T, C extends AbstractTextFieldListCell<T, C, SELF>, SELF extends AbstractTextFieldListListEntry<T, C, SELF>>
extends AbstractListListEntry<T, C, SELF> {
    @ApiStatus.Internal
    public AbstractTextFieldListListEntry(Component fieldName, List<T> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<T>> saveConsumer, Supplier<List<T>> defaultValue, Component resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront, BiFunction<T, SELF, C> createNewCell) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, createNewCell);
    }

    @ApiStatus.Internal
    public static abstract class AbstractTextFieldListCell<T, SELF extends AbstractTextFieldListCell<T, SELF, OUTER_SELF>, OUTER_SELF extends AbstractTextFieldListListEntry<T, SELF, OUTER_SELF>>
    extends AbstractListListEntry.AbstractListCell<T, SELF, OUTER_SELF> {
        protected EditBox widget;
        private boolean isSelected;
        private boolean isHovered;

        public AbstractTextFieldListCell(@Nullable T value, OUTER_SELF listListEntry) {
            super(value, listListEntry);
            T finalValue = this.substituteDefault(value);
            this.widget = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 100, 18, (Component)Component.m_237119_()){

                public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                    this.m_93692_(isSelected);
                    super.m_88315_(graphics, mouseX, mouseY, delta);
                }
            };
            this.widget.m_94153_(this::isValidText);
            this.widget.m_94199_(Integer.MAX_VALUE);
            this.widget.m_94182_(false);
            this.widget.m_94144_(Objects.toString(finalValue));
            this.widget.m_94198_();
            this.widget.m_94151_(s -> this.widget.m_94202_(this.getPreferredTextColor()));
        }

        @Override
        public void updateSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        @Nullable
        protected abstract T substituteDefault(@Nullable T var1);

        protected abstract boolean isValidText(@NotNull String var1);

        @Override
        public int getCellHeight() {
            return 20;
        }

        @Override
        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.widget.m_93674_(entryWidth - 12);
            this.widget.m_252865_(x);
            this.widget.m_253211_(y + 1);
            this.widget.m_94186_(((AbstractTextFieldListListEntry)this.listListEntry).isEditable());
            this.widget.m_88315_(graphics, mouseX, mouseY, delta);
            this.isHovered = this.widget.m_5953_((double)mouseX, (double)mouseY);
            if (isSelected && ((AbstractTextFieldListListEntry)this.listListEntry).isEditable()) {
                graphics.m_280509_(x, y + 12, x + entryWidth - 12, y + 13, this.getConfigError().isPresent() ? -43691 : -2039584);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.widget);
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return this.isSelected ? NarratableEntry.NarrationPriority.FOCUSED : (this.isHovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE);
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
            this.widget.m_142291_(narrationElementOutput);
        }
    }
}

