/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.AbstractTabbedConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigTabButton;
import me.shedaniel.clothconfig2.gui.entries.EmptyEntry;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.SearchFieldEntry;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ClothConfigScreen
extends AbstractTabbedConfigScreen {
    private final ScrollingContainer tabsScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, 1, ClothConfigScreen.this.f_96543_ - 40);
        }

        @Override
        public int getMaxScrollHeight() {
            return (int)ClothConfigScreen.this.getTabsMaximumScrolled();
        }

        @Override
        public void updatePosition(float delta) {
            super.updatePosition(delta);
            this.scrollAmount = this.clamp(this.scrollAmount, 0.0);
        }
    };
    public ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private final LinkedHashMap<Component, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final List<Tuple<Component, Integer>> tabs;
    private SearchFieldEntry searchFieldEntry;
    private AbstractWidget buttonLeftTab;
    private AbstractWidget buttonRightTab;
    private Rectangle tabsBounds;
    private Rectangle tabsLeftBounds;
    private Rectangle tabsRightBounds;
    private double tabsMaximumScrolled = -1.0;
    private final List<ClothConfigTabButton> tabButtons = Lists.newArrayList();
    private final Map<String, ConfigCategory> categoryMap;

    @ApiStatus.Internal
    public ClothConfigScreen(Screen parent, Component title, Map<String, ConfigCategory> categoryMap, ResourceLocation backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof Tuple ? (AbstractConfigListEntry)((Tuple)object).m_14419_() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put(category.getCategoryKey(), entries);
            if (category.getBackground() != null) {
                this.registerCategoryBackground(category.getCategoryKey().getString(), category.getBackground());
            }
        });
        this.tabs = this.categorizedEntries.keySet().stream().map(s -> new Tuple(s, (Object)(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)s) + 8))).collect(Collectors.toList());
        this.categoryMap = categoryMap;
    }

    @Override
    public Component getSelectedCategory() {
        return (Component)this.tabs.get(this.selectedCategoryIndex).m_14418_();
    }

    @Override
    public Map<Component, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tabButtons.clear();
        this.listWidget = new ListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, this.isShowingTabs() ? 70 : 30, this.f_96544_ - 32, this.getBackgroundLocation());
        this.childrenL().add((GuiEventListener)this.listWidget);
        this.listWidget.m_6702_().add(new EmptyEntry(5));
        this.searchFieldEntry = new SearchFieldEntry(this, this.listWidget);
        this.listWidget.m_6702_().add(this.searchFieldEntry);
        this.listWidget.m_6702_().add(new EmptyEntry(5));
        if (this.categorizedEntries.size() > this.selectedCategoryIndex) {
            this.listWidget.m_6702_().addAll((List)Lists.newArrayList(this.categorizedEntries.values()).get(this.selectedCategoryIndex));
        }
        int buttonWidths = Math.min(200, (this.f_96543_ - 50 - 12) / 3);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)(this.isEdited() ? Component.m_237115_((String)"text.cloth-config.cancel_discard") : Component.m_237115_((String)"gui.cancel")), widget -> this.quit()).m_252987_(this.f_96543_ / 2 - buttonWidths - 3, this.f_96544_ - 26, buttonWidths, 20).m_253136_());
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 3, this.f_96544_ - 26, buttonWidths, 20, (Component)Component.m_237119_(), button -> this.saveAll(true), Supplier::get){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                for (List entries : Lists.newArrayList(ClothConfigScreen.this.categorizedEntries.values())) {
                    for (AbstractConfigEntry entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break;
                    }
                    if (!hasErrors) continue;
                    break;
                }
                this.f_93623_ = ClothConfigScreen.this.isEdited() && !hasErrors;
                this.m_93666_((Component)(hasErrors ? Component.m_237115_((String)"text.cloth-config.error_cannot_save") : Component.m_237115_((String)"text.cloth-config.save_and_done")));
                super.m_88315_(graphics, mouseX, mouseY, delta);
            }
        });
        if (this.isShowingTabs()) {
            this.tabsBounds = new Rectangle(0, 41, this.f_96543_, 24);
            this.tabsLeftBounds = new Rectangle(0, 41, 18, 24);
            this.tabsRightBounds = new Rectangle(this.f_96543_ - 18, 41, 18, 24);
            this.buttonLeftTab = new Button(4, 44, 12, 18, (Component)Component.m_237119_(), button -> this.tabsScroller.scrollTo(0.0, true), Supplier::get){

                public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)AbstractConfigScreen.CONFIG_TEX);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                    RenderSystem.blendFunc((int)770, (int)771);
                    graphics.m_280218_(AbstractConfigScreen.CONFIG_TEX, this.m_252754_(), this.m_252907_(), 12, 18 * (!this.m_142518_() ? 0 : (this.m_198029_() ? 2 : 1)), this.f_93618_, this.f_93619_);
                }
            };
            this.childrenL().add((GuiEventListener)this.buttonLeftTab);
            int j = 0;
            for (Tuple<Component, Integer> tab : this.tabs) {
                this.tabButtons.add(new ClothConfigTabButton(this, j, -100, 43, (Integer)tab.m_14419_(), 20, (Component)tab.m_14418_(), this.categoryMap.get(((Component)tab.m_14418_()).getString()).getDescription()));
                ++j;
            }
            this.childrenL().addAll(this.tabButtons);
            this.buttonRightTab = new Button(this.f_96543_ - 16, 44, 12, 18, (Component)Component.m_237119_(), button -> this.tabsScroller.scrollTo(this.tabsScroller.getMaxScroll(), true), Supplier::get){

                public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)AbstractConfigScreen.CONFIG_TEX);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                    RenderSystem.blendFunc((int)770, (int)771);
                    graphics.m_280218_(AbstractConfigScreen.CONFIG_TEX, this.m_252754_(), this.m_252907_(), 0, 18 * (!this.m_142518_() ? 0 : (this.m_198029_() ? 2 : 1)), this.f_93618_, this.f_93619_);
                }
            };
            this.childrenL().add((GuiEventListener)this.buttonRightTab);
        } else {
            this.tabsLeftBounds = this.tabsRightBounds = new Rectangle();
            this.tabsBounds = this.tabsRightBounds;
        }
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    @Override
    public boolean matchesSearch(Iterator<String> tags) {
        return this.searchFieldEntry.matchesSearch(tags);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.tabsBounds.contains(mouseX, mouseY) && !this.tabsLeftBounds.contains(mouseX, mouseY) && !this.tabsRightBounds.contains(mouseX, mouseY) && amount != 0.0) {
            this.tabsScroller.offset(-amount * 16.0, true);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public double getTabsMaximumScrolled() {
        if (this.tabsMaximumScrolled == -1.0) {
            int[] i = new int[]{0};
            for (Tuple<Component, Integer> pair : this.tabs) {
                i[0] = i[0] + ((Integer)pair.m_14419_() + 2);
            }
            this.tabsMaximumScrolled = i[0];
        }
        return this.tabsMaximumScrolled + 6.0;
    }

    public void resetTabsMaximumScrolled() {
        this.tabsMaximumScrolled = -1.0;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.isShowingTabs()) {
            this.tabsScroller.updatePosition(delta * 3.0f);
            int xx = 24 - (int)this.tabsScroller.scrollAmount;
            for (ClothConfigTabButton tabButton : this.tabButtons) {
                tabButton.m_252865_(xx);
                xx += tabButton.m_5711_() + 2;
            }
            this.buttonLeftTab.f_93623_ = this.tabsScroller.scrollAmount > 0.0;
            boolean bl = this.buttonRightTab.f_93623_ = this.tabsScroller.scrollAmount < this.getTabsMaximumScrolled() - (double)this.f_96543_ + 40.0;
        }
        if (this.isTransparentBackground()) {
            graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        } else {
            this.m_280039_(graphics);
        }
        this.listWidget.m_88315_(graphics, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (AbstractConfigEntry<AbstractConfigEntry<?>> abstractConfigEntry : this.listWidget.m_6702_()) {
            abstractConfigEntry.lateRender(graphics, mouseX, mouseY, delta);
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        if (this.isShowingTabs()) {
            graphics.m_280653_(this.f_96541_.f_91062_, this.f_96539_, this.f_96543_ / 2, 18, -1);
            Rectangle onlyInnerTabBounds = new Rectangle(this.tabsBounds.x + 20, this.tabsBounds.y, this.tabsBounds.width - 40, this.tabsBounds.height);
            ScissorsHandler.INSTANCE.scissor(onlyInnerTabBounds);
            if (this.isTransparentBackground()) {
                graphics.m_280024_(onlyInnerTabBounds.x, onlyInnerTabBounds.y, onlyInnerTabBounds.getMaxX(), onlyInnerTabBounds.getMaxY(), 0x68000000, 0x68000000);
            } else {
                this.overlayBackground(graphics, onlyInnerTabBounds, 32, 32, 32, 255, 255);
            }
            this.tabButtons.forEach(widget -> widget.m_88315_(graphics, mouseX, mouseY, delta));
            this.drawTabsShades(graphics, 0, this.isTransparentBackground() ? 120 : 255);
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.buttonLeftTab.m_88315_(graphics, mouseX, mouseY, delta);
            this.buttonRightTab.m_88315_(graphics, mouseX, mouseY, delta);
        } else {
            graphics.m_280653_(this.f_96541_.f_91062_, this.f_96539_, this.f_96543_ / 2, 12, -1);
        }
        if (this.isEditable()) {
            ArrayList errors = Lists.newArrayList();
            for (List entries : Lists.newArrayList(this.categorizedEntries.values())) {
                for (AbstractConfigEntry entry : entries) {
                    if (!entry.getConfigError().isPresent()) continue;
                    errors.add(entry.getConfigError().get());
                }
            }
            if (errors.size() > 0) {
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONFIG_TEX);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String string = "\u00a7c" + (errors.size() == 1 ? ((Component)errors.get(0)).m_6879_().getString() : I18n.m_118938_((String)"text.cloth-config.multi_error", (Object[])new Object[0]));
                if (this.isTransparentBackground()) {
                    int stringWidth = this.f_96541_.f_91062_.m_92895_(string);
                    Objects.requireNonNull(this.f_96541_.f_91062_);
                    graphics.m_280024_(8, 9, 20 + stringWidth, 14 + 9, 0x68000000, 0x68000000);
                }
                graphics.m_280218_(CONFIG_TEX, 10, 10, 0, 54, 3, 11);
                graphics.m_280488_(this.f_96541_.f_91062_, string, 18, 12, -1);
                if (errors.size() > 1) {
                    int stringWidth = this.f_96541_.f_91062_.m_92895_(string);
                    if (mouseX >= 10 && mouseY >= 10 && mouseX <= 18 + stringWidth) {
                        Objects.requireNonNull(this.f_96541_.f_91062_);
                        if (mouseY <= 14 + 9) {
                            this.addTooltip(Tooltip.of(new Point(mouseX, mouseY), errors.toArray(new Component[0])));
                        }
                    }
                }
            }
        } else if (!this.isEditable()) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONFIG_TEX);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String text = "\u00a7c" + I18n.m_118938_((String)"text.cloth-config.not_editable", (Object[])new Object[0]);
            if (this.isTransparentBackground()) {
                int n = this.f_96541_.f_91062_.m_92895_(text);
                Objects.requireNonNull(this.f_96541_.f_91062_);
                graphics.m_280024_(8, 9, 20 + n, 14 + 9, 0x68000000, 0x68000000);
            }
            graphics.m_280218_(CONFIG_TEX, 10, 10, 0, 54, 3, 11);
            graphics.m_280488_(this.f_96541_.f_91062_, text, 18, 12, -1);
        }
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    private void drawTabsShades(GuiGraphics graphics, int lightColor, int darkColor) {
        this.drawTabsShades(graphics.m_280168_(), lightColor, darkColor);
    }

    private void drawTabsShades(PoseStack matrices, int lightColor, int darkColor) {
        this.drawTabsShades(matrices.m_85850_().m_252922_(), lightColor, darkColor);
    }

    private void drawTabsShades(Matrix4f matrix, int lightColor, int darkColor) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.setShader(GameRenderer::m_172820_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)(this.tabsBounds.getMinY() + 4), 0.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, lightColor).m_5752_();
        buffer.m_252986_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)(this.tabsBounds.getMinY() + 4), 0.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, lightColor).m_5752_();
        buffer.m_252986_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)this.tabsBounds.getMinY(), 0.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, darkColor).m_5752_();
        buffer.m_252986_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)this.tabsBounds.getMinY(), 0.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, darkColor).m_5752_();
        buffer.m_252986_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)this.tabsBounds.getMaxY(), 0.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, darkColor).m_5752_();
        buffer.m_252986_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)this.tabsBounds.getMaxY(), 0.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, darkColor).m_5752_();
        buffer.m_252986_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)(this.tabsBounds.getMaxY() - 4), 0.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, lightColor).m_5752_();
        buffer.m_252986_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)(this.tabsBounds.getMaxY() - 4), 0.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, lightColor).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    @Override
    public void save() {
        super.save();
    }

    @Override
    public boolean isEditable() {
        return super.isEditable();
    }

    public static class ListWidget<R extends DynamicElementListWidget.ElementEntry<R>>
    extends DynamicElementListWidget<R> {
        private final AbstractConfigScreen screen;
        private final ValueAnimator<Rectangle> currentBounds = ValueAnimator.ofRectangle();
        public UnaryOperator<List<R>> entriesTransformer = UnaryOperator.identity();
        public Rectangle thisTimeTarget;
        public long lastTouch;

        public ListWidget(AbstractConfigScreen screen, Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
            this.setRenderSelection(false);
            this.screen = screen;
        }

        @Override
        public int getItemWidth() {
            return this.width - 80;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.left + this.width - 36;
        }

        @Override
        protected void renderItem(GuiGraphics graphics, R item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (item instanceof AbstractConfigEntry) {
                ((AbstractConfigEntry)item).updateSelected(this.getFocused() == item);
            }
            super.renderItem(graphics, item, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        @Override
        protected void renderList(GuiGraphics graphics, int startX, int startY, int int_3, int int_4, float delta) {
            this.thisTimeTarget = null;
            Rectangle hoverBounds = (Rectangle)this.currentBounds.value();
            if (!hoverBounds.isEmpty()) {
                long timePast = System.currentTimeMillis() - this.lastTouch;
                int alpha = timePast <= 200L ? 255 : Mth.m_14165_((double)(255.0 - (double)(Math.min((float)(timePast - 200L), 500.0f) / 500.0f) * 255.0));
                alpha = alpha * 36 / 255 << 24;
                graphics.m_280024_(hoverBounds.x, hoverBounds.y - (int)this.scroll, hoverBounds.getMaxX(), hoverBounds.getMaxY() - (int)this.scroll, 0xFFFFFF | alpha, 0xFFFFFF | alpha);
            }
            super.renderList(graphics, startX, startY, int_3, int_4, delta);
            if (this.thisTimeTarget != null && this.m_5953_(int_3, int_4)) {
                this.lastTouch = System.currentTimeMillis();
            }
            if (this.thisTimeTarget != null && !this.thisTimeTarget.equals(this.currentBounds.target())) {
                this.currentBounds.setTo(this.thisTimeTarget, 100L);
            } else if (!((Rectangle)this.currentBounds.target()).isEmpty()) {
                this.currentBounds.update(delta);
            }
        }

        protected static void fillGradient(Matrix4f matrix4f, BufferBuilder bufferBuilder, double xStart, double yStart, double xEnd, double yEnd, int i, int j, int k) {
            float f = (float)(j >> 24 & 0xFF) / 255.0f;
            float g = (float)(j >> 16 & 0xFF) / 255.0f;
            float h = (float)(j >> 8 & 0xFF) / 255.0f;
            float l = (float)(j & 0xFF) / 255.0f;
            float m = (float)(k >> 24 & 0xFF) / 255.0f;
            float n = (float)(k >> 16 & 0xFF) / 255.0f;
            float o = (float)(k >> 8 & 0xFF) / 255.0f;
            float p = (float)(k & 0xFF) / 255.0f;
            bufferBuilder.m_252986_(matrix4f, (float)xEnd, (float)yStart, (float)i).m_85950_(g, h, l, f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)xStart, (float)yStart, (float)i).m_85950_(g, h, l, f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)xStart, (float)yEnd, (float)i).m_85950_(n, o, p, m).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)xEnd, (float)yEnd, (float)i).m_85950_(n, o, p, m).m_5752_();
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.updateScrollingState(mouseX, mouseY, button);
            if (!this.m_5953_(mouseX, mouseY)) {
                return false;
            }
            for (DynamicElementListWidget.ElementEntry entry : this.m_6702_()) {
                if (!entry.m_6375_(mouseX, mouseY, button)) continue;
                this.m_7522_(entry);
                this.m_7897_(true);
                return true;
            }
            if (button == 0) {
                this.clickedHeader((int)(mouseX - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(mouseY - (double)this.top) + (int)this.getScroll() - 4);
                return true;
            }
            return this.scrolling;
        }

        @Override
        protected void renderBackBackground(GuiGraphics graphics, BufferBuilder buffer, Tesselator tessellator) {
            if (!this.screen.isTransparentBackground()) {
                super.renderBackBackground(graphics, buffer, tessellator);
            } else {
                graphics.m_280024_(this.left, this.top, this.right, this.bottom, 0x68000000, 0x68000000);
            }
        }

        @Override
        protected void renderHoleBackground(GuiGraphics graphics, int y1, int y2, int alpha1, int alpha2) {
            if (!this.screen.isTransparentBackground()) {
                super.renderHoleBackground(graphics, y1, y2, alpha1, alpha2);
            }
        }

        @Override
        public List<R> m_6702_() {
            return (List)this.entriesTransformer.apply(super.m_6702_());
        }
    }
}

