/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util.uints;

import folk.sisby.surveyor.util.uints.ArrayUInts;
import folk.sisby.surveyor.util.uints.UInts;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public record UShortArray(short[] value) implements ArrayUInts
{
    public static final int TYPE = 8;

    public static UInts ofInts(int[] ints) {
        short[] value = new short[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            value[i] = (short)ints[i];
        }
        return new UShortArray(value);
    }

    public static UInts ofPacked(int[] ints, int cardinality) {
        int i;
        short[] value = new short[cardinality];
        for (i = 0; i < value.length; i += 2) {
            value[i] = (short)(ints[i / 2] >>> 16);
        }
        for (i = 1; i < value.length; i += 2) {
            value[i] = (short)(ints[i / 2] & 0xFFFF);
        }
        return new UShortArray(value);
    }

    public static UInts fromBuf(FriendlyByteBuf buf, int cardinality) {
        return UShortArray.ofPacked(buf.m_130100_(), cardinality);
    }

    public int[] packToInts() {
        int i;
        int[] packed = new int[this.value.length / 2 + (this.value.length & 1)];
        for (i = 0; i < this.value.length; i += 2) {
            int n = i / 2;
            packed[n] = packed[n] | this.value[i] << 16;
        }
        for (i = 1; i < this.value.length; i += 2) {
            int n = i / 2;
            packed[n] = packed[n] | this.value[i];
        }
        return packed;
    }

    @Override
    public int get(int i) {
        return this.value[i] & 0xFFFF;
    }

    @Override
    public void writeNbt(CompoundTag nbt, String key) {
        nbt.m_128385_(key, this.packToInts());
    }

    @Override
    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_130089_(this.packToInts());
    }

    @Override
    public int getType() {
        return 8;
    }
}

