/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.util.ArrayUtil;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import org.jetbrains.annotations.NotNull;

public class RegistryPalette<T>
implements IntIterable {
    private final Registry<T> registry;
    private final int[] raw;
    private final int[] inverse;
    private final ValueView valueView;
    private int size;

    public RegistryPalette(Registry<T> registry) {
        this.registry = registry;
        this.raw = ArrayUtil.ofSingle(-1, registry.m_13562_());
        this.inverse = ArrayUtil.ofSingle(-1, registry.m_13562_());
        this.size = 0;
        this.valueView = new ValueView();
    }

    public int find(int value) {
        return this.inverse[value];
    }

    private int add(int value) {
        this.raw[this.size] = value;
        this.inverse[value] = this.size++;
        Object object = this.registry.m_7942_(value);
        this.valueView.values.add(object);
        return this.size - 1;
    }

    public int findOrAdd(int value) {
        int index = this.find(value);
        return index == -1 ? this.add(value) : index;
    }

    public int findOrAdd(T value) {
        return this.findOrAdd(this.registry.m_7447_(value));
    }

    public int get(int index) {
        return this.raw[index];
    }

    @NotNull
    public IntIterator iterator() {
        return IntIterators.wrap((int[])this.raw, (int)0, (int)this.size);
    }

    public ValueView view() {
        return this.valueView;
    }

    public class ValueView
    implements IdMap<T> {
        private final T defaultValue;
        private final List<T> values;

        public ValueView() {
            Object object;
            Registry registry = RegistryPalette.this.registry;
            if (registry instanceof DefaultedRegistry) {
                DefaultedRegistry defreg = (DefaultedRegistry)registry;
                object = defreg.m_7745_(defreg.m_122315_());
            } else {
                object = RegistryPalette.this.registry.m_7942_(0);
            }
            this.defaultValue = object;
            this.values = new ArrayList();
        }

        public Registry<T> registry() {
            return RegistryPalette.this.registry;
        }

        public T m_7942_(int index) {
            if (index >= this.values.size()) {
                Surveyor.LOGGER.error("[Surveyor] Palette view access at index {} for palette size {}! Returning garbage!", (Object)index, (Object)this.values.size());
                return this.defaultValue;
            }
            return this.values.get(index);
        }

        public int m_7447_(T value) {
            return this.values.indexOf(value);
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.values.iterator();
        }

        public int m_13562_() {
            return RegistryPalette.this.size;
        }
    }
}

