/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionSupport {
    public static final Map<ResourceKey<Level>, int[]> cache = new HashMap<ResourceKey<Level>, int[]>();

    private static void softAdd(DimensionType dimension, List<Integer> layers, int y) {
        if (dimension.f_156647_() < y && y < dimension.f_156647_() + dimension.f_156648_()) {
            layers.add(y);
        }
    }

    private static int[] getSummaryLayersInternal(Level world) {
        ArrayList<Integer> layers = new ArrayList<Integer>();
        DimensionType dimension = world.m_6042_();
        layers.add(dimension.f_156647_() + dimension.f_156648_() - 1);
        if (dimension.f_63865_() != dimension.f_156648_()) {
            DimensionSupport.softAdd(dimension, layers, dimension.f_156647_() + dimension.f_63865_() - 2);
        }
        if (dimension.f_156647_() + dimension.f_156648_() > 256) {
            DimensionSupport.softAdd(dimension, layers, 256);
        }
        if (dimension.f_223549_()) {
            DimensionSupport.softAdd(dimension, layers, world.m_5736_() - 2);
        }
        if (dimension.f_156647_() < 0) {
            DimensionSupport.softAdd(dimension, layers, 0);
        }
        if (world.m_220362_() == BuiltinDimensionTypes.f_223539_) {
            DimensionSupport.softAdd(dimension, layers, 70);
            DimensionSupport.softAdd(dimension, layers, 40);
        }
        layers.add(dimension.f_156647_());
        layers.sort(Comparator.comparingInt(i -> i).reversed());
        int[] outLayers = new int[layers.size()];
        for (int i2 = 0; i2 < outLayers.length; ++i2) {
            outLayers[i2] = (Integer)layers.get(i2);
        }
        return outLayers;
    }

    public static int[] getSummaryLayers(Level world) {
        return cache.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), k -> DimensionSupport.getSummaryLayersInternal(world));
    }
}

