/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.terrain.LayerSummary;
import folk.sisby.surveyor.terrain.SectionSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.RegistryPalette;
import folk.sisby.surveyor.util.uints.UInts;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public class ChunkSummary {
    public static final int MINIMUM_AIR_DEPTH = 2;
    public static final String KEY_AIR_COUNT = "air";
    public static final String KEY_LAYERS = "layers";
    protected final Integer airCount;
    protected final TreeMap<Integer, @Nullable LayerSummary> layers = new TreeMap();

    public ChunkSummary(Level world, LevelChunk chunk, int[] layerHeights, RegistryPalette<Biome> biomePalette, RegistryPalette<Block> blockPalette, boolean countAir) {
        this.airCount = countAir ? ChunkUtil.airCount((ChunkAccess)chunk) : null;
        LayerSummary.FloorSummary[][] layerFloors = new LayerSummary.FloorSummary[layerHeights.length - 1][256];
        LevelChunkSection[] rawSections = chunk.m_7103_();
        SectionSummary[] sections = new SectionSummary[rawSections.length];
        for (int i = 0; i < rawSections.length; ++i) {
            sections[i] = SectionSummary.ofSection(rawSections[i]);
        }
        int chunkX = chunk.m_7697_().m_45604_();
        int chunkZ = chunk.m_7697_().m_45605_();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int walkspaceHeight = 2;
                int waterDepth = 0;
                Block carpetBlock = null;
                BlockPos carpetPos = new BlockPos(chunkX + x, Integer.MAX_VALUE, chunkZ + z);
                for (int layerIndex = 0; layerIndex < layerHeights.length - 1; ++layerIndex) {
                    LayerSummary.FloorSummary foundFloor = null;
                    for (int y = layerHeights[layerIndex]; y > layerHeights[layerIndex + 1]; --y) {
                        int sectionIndex = chunk.m_151564_(y);
                        SectionSummary section = sections[sectionIndex];
                        if (section == null) {
                            int sectionBottom = SectionPos.m_123223_((int)chunk.m_151568_(sectionIndex));
                            walkspaceHeight += y - sectionBottom + 1;
                            waterDepth = 0;
                            y = sectionBottom;
                            continue;
                        }
                        BlockPos pos = new BlockPos(chunkX + x, y, chunkZ + z);
                        BlockState state = section.getBlockState(x, y, z);
                        Fluid fluid = state.m_60819_().m_76152_();
                        if (!state.m_280555_() && fluid.m_6212_(Fluids.f_76191_)) {
                            waterDepth = 0;
                            if (++walkspaceHeight < 2 || state.m_284242_((BlockGetter)world, pos) == MapColor.f_283808_) continue;
                            carpetPos = pos;
                            carpetBlock = state.m_60734_();
                            continue;
                        }
                        if (fluid.m_6212_((Fluid)Fluids.f_76193_) || fluid.m_6212_((Fluid)Fluids.f_76192_)) {
                            ++waterDepth;
                            continue;
                        }
                        if (foundFloor == null) {
                            if (carpetPos.m_123342_() == y + 1) {
                                foundFloor = new LayerSummary.FloorSummary(carpetPos.m_123342_(), biomePalette.findOrAdd((Biome)section.getBiomeEntry(x, carpetPos.m_123342_(), z, world.m_141937_(), world.m_151558_()).m_203334_()), blockPalette.findOrAdd(carpetBlock), world.m_45517_(LightLayer.BLOCK, carpetPos), waterDepth, waterDepth == 0 ? 0 : world.m_45517_(LightLayer.BLOCK, pos.m_7494_().m_6630_(waterDepth)));
                                if (carpetPos.m_123342_() > layerHeights[layerIndex]) {
                                    if (layerFloors[layerIndex - 1][x * 16 + z] == null) {
                                        layerFloors[layerIndex - 1][x * 16 + z] = foundFloor;
                                    }
                                    foundFloor = null;
                                }
                                walkspaceHeight = 0;
                                waterDepth = 0;
                            } else if (walkspaceHeight >= 2 && state.m_284242_((BlockGetter)world, pos) != MapColor.f_283808_) {
                                foundFloor = new LayerSummary.FloorSummary(y, biomePalette.findOrAdd((Biome)section.getBiomeEntry(x, y, z, world.m_141937_(), world.m_151558_()).m_203334_()), blockPalette.findOrAdd(state.m_60734_()), world.m_45517_(LightLayer.BLOCK, pos.m_7494_()), waterDepth, waterDepth == 0 ? 0 : world.m_45517_(LightLayer.BLOCK, pos.m_7494_().m_6630_(waterDepth)));
                            }
                        }
                        if (state.m_284242_((BlockGetter)world, pos) == MapColor.f_283808_) continue;
                        walkspaceHeight = 0;
                        waterDepth = 0;
                    }
                    layerFloors[layerIndex][x * 16 + z] = foundFloor;
                }
            }
        }
        for (int i = 0; i < layerFloors.length; ++i) {
            this.layers.put(layerHeights[i], LayerSummary.fromSummaries(layerFloors[i], layerHeights[i]));
        }
    }

    public ChunkSummary(CompoundTag nbt) {
        this.airCount = nbt.m_128441_(KEY_AIR_COUNT) ? Integer.valueOf(nbt.m_128451_(KEY_AIR_COUNT)) : null;
        CompoundTag layersCompound = nbt.m_128469_(KEY_LAYERS);
        for (String key : layersCompound.m_128431_()) {
            int layerY = Integer.parseInt(key);
            this.layers.put(layerY, LayerSummary.fromNbt(layersCompound.m_128469_(key)));
        }
    }

    public ChunkSummary(FriendlyByteBuf buf) {
        this.layers.putAll(buf.m_236847_(FriendlyByteBuf::m_130242_, b -> {
            if (b.readByte() == 0) {
                return null;
            }
            return LayerSummary.fromBuf(buf);
        }));
        this.airCount = -1;
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        if (this.airCount != null) {
            nbt.m_128405_(KEY_AIR_COUNT, this.airCount.intValue());
        }
        CompoundTag layersCompound = new CompoundTag();
        this.layers.forEach((layerY, layerSummary) -> {
            CompoundTag layerCompound = new CompoundTag();
            if (layerSummary != null) {
                layerSummary.writeNbt(layerCompound);
            }
            layersCompound.m_128365_(String.valueOf(layerY), (Tag)layerCompound);
        });
        nbt.m_128365_(KEY_LAYERS, (Tag)layersCompound);
        return nbt;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_236831_(this.layers, FriendlyByteBuf::m_130130_, (b, summary) -> {
            if (summary == null) {
                b.writeByte(0);
            } else {
                b.writeByte(1);
                summary.writeBuf(buf);
            }
        });
    }

    public void remap(Map<Integer, Integer> biomeRemap, Map<Integer, Integer> blockRemap) {
        HashMap newLayers = new HashMap();
        this.layers.forEach((y, layer) -> newLayers.put(y, layer == null ? null : new LayerSummary(layer.found, layer.depth, UInts.remap(layer.biome, biomeRemap::get, 0, layer.found.cardinality()), UInts.remap(layer.block, blockRemap::get, 0, layer.found.cardinality()), layer.light, layer.water, layer.glint)));
        this.layers.clear();
        this.layers.putAll(newLayers);
    }

    public Integer getAirCount() {
        return this.airCount;
    }

    @Nullable
    public LayerSummary.Raw toSingleLayer(Integer minY, Integer maxY, int worldHeight) {
        LayerSummary.Raw outRaw = new LayerSummary.Raw(new BitSet(256), new int[256], new int[256], new int[256], new int[256], new int[256], new int[256]);
        this.layers.descendingMap().forEach((y, layer) -> {
            if (layer != null) {
                layer.fillEmptyFloors(worldHeight - y, maxY == null ? Integer.MIN_VALUE : y - maxY, minY == null ? Integer.MAX_VALUE : y - minY, outRaw);
            }
        });
        return outRaw.exists().cardinality() == 0 ? null : outRaw;
    }
}

