/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.FeaturePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class JigsawPieceSummary
extends StructurePieceSummary {
    public static final String KEY_POS = "pos";
    public static final String KEY_DELTA_Y = "deltaY";
    public static final String KEY_ROTATION = "rotation";
    public static final String KEY_JUNCTIONS = "junctions";
    public static final BiMap<String, StructurePoolElementType<?>> TYPE_KEYS = HashBiMap.create(Map.of("single", StructurePoolElementType.f_210542_, "feature", StructurePoolElementType.f_210544_));
    protected final BlockPos pos;
    protected final int deltaY;
    protected final Rotation rotation;
    protected final List<JigsawJunction> junctions;
    protected final StructurePoolElementType<?> elementType;
    protected final ResourceLocation id;

    public JigsawPieceSummary(BlockPos pos, int deltaY, Rotation rotation, StructurePoolElementType<?> elementType, ResourceLocation id, int chainLength, BoundingBox boundingBox, List<JigsawJunction> junctions) {
        super(StructurePieceType.f_210125_, chainLength, boundingBox, new CompoundTag());
        this.pos = pos;
        this.deltaY = deltaY;
        this.rotation = rotation;
        this.elementType = elementType;
        this.id = id;
        this.junctions = junctions;
    }

    public JigsawPieceSummary(CompoundTag nbt) {
        super(nbt);
        this.pos = BlockPos.m_122022_((long)nbt.m_128454_(KEY_POS));
        this.deltaY = nbt.m_128451_(KEY_DELTA_Y);
        this.rotation = Rotation.values()[nbt.m_128451_(KEY_ROTATION)];
        this.junctions = new ArrayList<JigsawJunction>();
        if (nbt.m_128441_(KEY_JUNCTIONS)) {
            int[] junctionArray = nbt.m_128465_(KEY_JUNCTIONS);
            for (int i = 4; i <= junctionArray.length; i += 5) {
                this.junctions.add(new JigsawJunction(junctionArray[i - 4], junctionArray[i - 3], junctionArray[i - 2], junctionArray[i - 1], StructureTemplatePool.Projection.values()[junctionArray[i]]));
            }
        }
        String idKey = TYPE_KEYS.keySet().stream().filter(arg_0 -> ((CompoundTag)nbt).m_128441_(arg_0)).findFirst().orElseThrow();
        this.elementType = (StructurePoolElementType)TYPE_KEYS.get((Object)idKey);
        this.id = new ResourceLocation(nbt.m_128461_(idKey));
    }

    public static List<StructurePieceSummary> tryFromElement(StructurePoolElement poolElement, PoolElementStructurePiece piece) {
        if (poolElement instanceof ListPoolElement) {
            ListPoolElement listElement = (ListPoolElement)poolElement;
            ArrayList<StructurePieceSummary> allSummaries = new ArrayList<StructurePieceSummary>();
            listElement.f_210360_.forEach(e -> allSummaries.addAll(JigsawPieceSummary.tryFromElement(e, piece)));
            return allSummaries;
        }
        if (poolElement instanceof SinglePoolElement) {
            SinglePoolElement singleElement = (SinglePoolElement)poolElement;
            if (singleElement.f_210411_.left().isPresent()) {
                return List.of(new JigsawPieceSummary(piece.m_72646_(), piece.m_72647_(), piece.m_6830_(), StructurePoolElementType.f_210542_, (ResourceLocation)singleElement.f_210411_.left().orElseThrow(), piece.m_73548_(), poolElement.m_214015_(piece.f_226493_, piece.m_72646_(), piece.m_6830_()), piece.m_72648_()));
            }
        }
        if (poolElement instanceof FeaturePoolElement) {
            FeaturePoolElement featureElement = (FeaturePoolElement)poolElement;
            if (featureElement.f_210205_.m_203543_().isPresent()) {
                return List.of(new JigsawPieceSummary(piece.m_72646_(), piece.m_72647_(), piece.m_6830_(), StructurePoolElementType.f_210544_, ((ResourceKey)featureElement.f_210205_.m_203543_().orElseThrow()).m_135782_(), piece.m_73548_(), poolElement.m_214015_(piece.f_226493_, piece.m_72646_(), piece.m_6830_()), piece.m_72648_()));
            }
        }
        return List.of();
    }

    public static List<StructurePieceSummary> tryFromPiece(StructurePiece piece) {
        if (piece instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)piece;
            return JigsawPieceSummary.tryFromElement(poolPiece.m_209918_(), poolPiece);
        }
        return List.of();
    }

    @Override
    public void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        super.m_183620_(context, nbt);
        nbt.m_128356_(KEY_POS, this.pos.m_121878_());
        nbt.m_128405_(KEY_DELTA_Y, this.deltaY);
        nbt.m_128405_(KEY_ROTATION, this.rotation.ordinal());
        String idKey = (String)TYPE_KEYS.inverse().get(this.elementType);
        nbt.m_128359_(idKey, this.id.toString());
        if (!this.junctions.isEmpty()) {
            int[] junctionArray = new int[this.junctions.size() * 5];
            for (int i = 0; i < this.junctions.size(); ++i) {
                JigsawJunction j = this.junctions.get(i);
                junctionArray[i * 5] = j.m_210252_();
                junctionArray[i * 5 + 1] = j.m_210257_();
                junctionArray[i * 5 + 2] = j.m_210258_();
                junctionArray[i * 5 + 3] = j.m_210259_();
                junctionArray[i * 5 + 4] = j.m_210260_().ordinal();
            }
            nbt.m_128385_(KEY_JUNCTIONS, junctionArray);
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public Rotation m_6830_() {
        return this.rotation;
    }

    public StructurePoolElementType<?> getElementType() {
        return this.elementType;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<JigsawJunction> getJunctions() {
        return this.junctions;
    }
}

