/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.util.MapUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;

public record S2CStructuresAddedPacket(boolean shared, Map<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> structures, Map<ResourceKey<Structure>, ResourceKey<StructureType<?>>> types, Multimap<ResourceKey<Structure>, TagKey<Structure>> tags) implements S2CPacket
{
    public static final ResourceLocation ID = new ResourceLocation("surveyor", "s2c_structures_added");

    public static S2CStructuresAddedPacket of(boolean shared, Multimap<ResourceKey<Structure>, ChunkPos> keys, WorldStructureSummary summary) {
        return summary.createUpdatePacket(shared, keys);
    }

    public static S2CStructuresAddedPacket of(boolean shared, ResourceKey<Structure> key, ChunkPos pos, WorldStructureSummary summary) {
        return S2CStructuresAddedPacket.of(shared, MapUtil.asMultiMap(Map.of(key, List.of(pos))), summary);
    }

    public static S2CStructuresAddedPacket read(FriendlyByteBuf buf) {
        return new S2CStructuresAddedPacket(buf.readBoolean(), buf.m_236847_(b -> b.m_236801_(Registries.f_256944_), b -> b.m_236847_(FriendlyByteBuf::m_178383_, b2 -> new StructureStartSummary(b2.m_236845_(b3 -> WorldStructureSummary.readStructurePieceNbt(Objects.requireNonNull(b3.m_130260_())))))), buf.m_236847_(b -> b.m_236801_(Registries.f_256944_), b -> b.m_236801_(Registries.f_256938_)), MapUtil.asMultiMap(buf.m_236847_(b -> b.m_236801_(Registries.f_256944_), b -> b.m_236845_(b2 -> TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)b2.m_130281_())))));
    }

    @Override
    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeBoolean(this.shared);
        buf.m_236831_(this.structures, FriendlyByteBuf::m_236858_, (b, posMap) -> b.m_236831_(posMap, FriendlyByteBuf::m_178341_, (b2, summary) -> b2.m_236828_(summary.getChildren(), (b3, piece) -> b3.m_130079_(piece.toNbt()))));
        buf.m_236831_(this.types, FriendlyByteBuf::m_236858_, FriendlyByteBuf::m_236858_);
        buf.m_236831_(this.tags.asMap(), FriendlyByteBuf::m_236858_, (b, c) -> b.m_236828_(c, (b2, t) -> b2.m_130085_(t.f_203868_())));
    }

    @Override
    public Collection<FriendlyByteBuf> toBufs() {
        ArrayList<FriendlyByteBuf> bufs = new ArrayList<FriendlyByteBuf>();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.writeBuf(buf);
        if (buf.readableBytes() < 0x100000) {
            bufs.add(buf);
        } else {
            Multimap<ResourceKey<Structure>, ChunkPos> keySet = MapUtil.keyMultiMap(this.structures);
            if (keySet.size() == 1) {
                Surveyor.LOGGER.error("Couldn't create a structure update packet for {} - an individual structure would be too large to send!", (Object)((ResourceKey)keySet.keys().stream().findFirst().orElseThrow()).m_135782_());
                return List.of();
            }
            HashMultimap firstHalf = HashMultimap.create();
            HashMultimap secondHalf = HashMultimap.create();
            keySet.forEach((arg_0, arg_1) -> S2CStructuresAddedPacket.lambda$toBufs$14((Multimap)firstHalf, keySet, (Multimap)secondHalf, arg_0, arg_1));
            bufs.addAll(new S2CStructuresAddedPacket(this.shared, MapUtil.splitByKeyMap(this.structures, firstHalf), MapUtil.splitByKeySet(this.types, firstHalf.keySet()), MapUtil.asMultiMap(MapUtil.splitByKeySet(this.tags.asMap(), firstHalf.keySet()))).toBufs());
            bufs.addAll(new S2CStructuresAddedPacket(this.shared, MapUtil.splitByKeyMap(this.structures, secondHalf), MapUtil.splitByKeySet(this.types, secondHalf.keySet()), MapUtil.asMultiMap(MapUtil.splitByKeySet(this.tags.asMap(), secondHalf.keySet()))).toBufs());
        }
        return bufs;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    private static /* synthetic */ void lambda$toBufs$14(Multimap firstHalf, Multimap keySet, Multimap secondHalf, ResourceKey key, ChunkPos pos) {
        if (firstHalf.size() < keySet.size() / 2) {
            firstHalf.put((Object)key, (Object)pos);
        } else {
            secondHalf.put((Object)key, (Object)pos);
        }
    }
}

