/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.NetherPortalLandmark;
import folk.sisby.surveyor.landmark.PlayerDeathLandmark;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.SimplePointOfInterestLandmark;
import folk.sisby.surveyor.util.DispatchMapCodec;
import folk.sisby.surveyor.util.SurveyorCodecs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class Landmarks {
    public static final String KEY_LANDMARKS = "landmarks";
    private static final Map<ResourceLocation, LandmarkType<?>> TYPES = new HashMap();
    public static final Codec<LandmarkType<?>> TYPE_CODEC = ResourceLocation.f_135803_.comapFlatMap(Landmarks::decode, LandmarkType::id);
    public static final Codec<Map<LandmarkType<?>, Map<BlockPos, Landmark<?>>>> CODEC = DispatchMapCodec.of(TYPE_CODEC, Landmarks::typedCodec);

    public static <T extends Landmark<T>> Codec<Map<BlockPos, Landmark<?>>> typedCodec(LandmarkType<T> type) {
        return DispatchMapCodec.of(SurveyorCodecs.STRINGIFIED_BLOCKPOS, pos -> type.createCodec((BlockPos)pos));
    }

    private static DataResult<? extends LandmarkType<?>> decode(ResourceLocation id) {
        return Optional.ofNullable(TYPES.get(id)).map(DataResult::success).orElse(DataResult.error(() -> "No landmark type found with id " + String.valueOf(id)));
    }

    public static boolean containsType(ResourceLocation id) {
        return TYPES.containsKey(id);
    }

    public static CompoundTag writeNbt(Map<LandmarkType<?>, Map<BlockPos, Landmark<?>>> landmarks, CompoundTag nbt) {
        nbt.m_128365_(KEY_LANDMARKS, (Tag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, landmarks).getOrThrow(false, arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)));
        return nbt;
    }

    public static Map<LandmarkType<?>, Map<BlockPos, Landmark<?>>> fromNbt(CompoundTag nbt) {
        return (Map)((Pair)CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_(KEY_LANDMARKS)).getOrThrow(false, arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0))).getFirst();
    }

    public static LandmarkType<?> getType(ResourceLocation id) {
        return TYPES.get(id);
    }

    public static Set<ResourceLocation> keySet() {
        return new HashSet<ResourceLocation>(TYPES.keySet());
    }

    public static void register(LandmarkType<?> type) {
        if (Landmarks.containsType(type.id())) {
            throw new IllegalArgumentException("Multiple landmark types registered to the same ID: %s".formatted(type.id()));
        }
        TYPES.put(type.id(), type);
    }

    static {
        Landmarks.register(SimplePointLandmark.TYPE);
        Landmarks.register(SimplePointOfInterestLandmark.TYPE);
        Landmarks.register(NetherPortalLandmark.TYPE);
        Landmarks.register(PlayerDeathLandmark.TYPE);
    }
}

