/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.C2SPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SurveyorNetworking {
    public static Consumer<C2SPacket> C2S_SENDER = p -> {};

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)C2SKnownTerrainPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownTerrainPacket::read, SurveyorNetworking::handleKnownTerrain));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)C2SKnownStructuresPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownStructuresPacket::read, SurveyorNetworking::handleKnownStructures));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)C2SKnownLandmarksPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownLandmarksPacket::read, SurveyorNetworking::handleKnownLandmarks));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksAddedPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, SyncLandmarksAddedPacket::read, SurveyorNetworking::handleLandmarksAdded));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksRemovedPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, SyncLandmarksRemovedPacket::read, SurveyorNetworking::handleLandmarksRemoved));
    }

    private static void handleKnownTerrain(ServerPlayer player, ServerLevel world, WorldSummary summary, C2SKnownTerrainPacket packet) {
        if (summary.terrain() == null || Surveyor.CONFIG.networking.terrain.atMost(NetworkMode.NONE)) {
            return;
        }
        Map<ChunkPos, BitSet> serverBits = summary.terrain().bitSet(SurveyorExploration.ofShared(player));
        Map<ChunkPos, BitSet> clientBits = packet.regionBits();
        serverBits.forEach((rPos, set) -> {
            if (clientBits.containsKey(rPos)) {
                set.andNot((BitSet)clientBits.get(rPos));
            }
            if (!set.isEmpty()) {
                SurveyorExploration personalExploration = SurveyorExploration.of(player);
                BitSet personalSet = personalExploration.limitTerrainBitset((ResourceKey<Level>)world.m_46472_(), (ChunkPos)rPos, (BitSet)set.clone());
                if (!personalSet.isEmpty()) {
                    S2CUpdateRegionPacket.of(false, rPos, summary.terrain().getRegion((ChunkPos)rPos), personalSet).send(player);
                }
                set.andNot(personalSet);
                if (!set.isEmpty() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.GROUP)) {
                    S2CUpdateRegionPacket.of(true, rPos, summary.terrain().getRegion((ChunkPos)rPos), set).send(player);
                }
            }
        });
    }

    private static void handleKnownStructures(ServerPlayer player, ServerLevel world, WorldSummary summary, C2SKnownStructuresPacket packet) {
        if (summary.structures() == null || Surveyor.CONFIG.networking.structures.atMost(NetworkMode.NONE)) {
            return;
        }
        Multimap<ResourceKey<Structure>, ChunkPos> structures = summary.structures().keySet(SurveyorExploration.ofShared(player));
        packet.structureKeys().forEach((arg_0, arg_1) -> structures.remove(arg_0, arg_1));
        if (structures.isEmpty()) {
            return;
        }
        SurveyorExploration personalExploration = SurveyorExploration.of(player);
        Multimap<ResourceKey<Structure>, ChunkPos> personalStructures = personalExploration.limitStructureKeySet((ResourceKey<Level>)world.m_46472_(), (Multimap<ResourceKey<Structure>, ChunkPos>)HashMultimap.create(structures));
        if (!personalStructures.isEmpty()) {
            S2CStructuresAddedPacket.of(false, personalStructures, summary.structures()).send(player);
        }
        personalStructures.forEach((arg_0, arg_1) -> structures.remove(arg_0, arg_1));
        if (!structures.isEmpty() && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.GROUP)) {
            S2CStructuresAddedPacket.of(true, structures, summary.structures()).send(player);
        }
    }

    private static void handleKnownLandmarks(ServerPlayer player, ServerLevel world, WorldSummary summary, C2SKnownLandmarksPacket packet) {
        if (summary.landmarks() == null || Surveyor.CONFIG.networking.landmarks.atMost(NetworkMode.NONE)) {
            return;
        }
        Multimap<LandmarkType<?>, BlockPos> landmarks = summary.landmarks().keySet(Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.GROUP) ? SurveyorExploration.ofShared(player) : SurveyorExploration.of(player));
        HashMultimap addLandmarks = HashMultimap.create(landmarks);
        packet.landmarks().forEach((arg_0, arg_1) -> ((Multimap)addLandmarks).remove(arg_0, arg_1));
        if (!addLandmarks.isEmpty()) {
            SyncLandmarksAddedPacket.of(addLandmarks, summary.landmarks()).send(player);
        }
        HashMultimap removeLandmarks = HashMultimap.create(packet.landmarks());
        landmarks.forEach((arg_0, arg_1) -> ((Multimap)removeLandmarks).remove(arg_0, arg_1));
        if (!removeLandmarks.isEmpty()) {
            new SyncLandmarksRemovedPacket((Multimap<LandmarkType<?>, BlockPos>)removeLandmarks).send(player);
        }
    }

    private static void handleLandmarksAdded(ServerPlayer player, ServerLevel world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((Level)world, packet, player);
    }

    private static void handleLandmarksRemoved(ServerPlayer player, ServerLevel world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        HashMap changed = new HashMap();
        packet.landmarks().forEach((type, pos) -> {
            if (summary.landmarks().contains((LandmarkType<?>)type, (BlockPos)pos) && Surveyor.getUuid(player).equals(summary.landmarks().get(type, (BlockPos)pos).owner())) {
                summary.landmarks().removeForBatch(changed, (LandmarkType<?>)type, (BlockPos)pos);
            }
        });
        if (!changed.isEmpty()) {
            summary.landmarks().handleChanged((Level)world, changed, false, player);
        }
    }

    private static <T extends C2SPacket> void handleServer(ServerPlayer player, FriendlyByteBuf buf, Function<FriendlyByteBuf, T> reader, ServerPacketHandler<T> handler) {
        C2SPacket packet = (C2SPacket)reader.apply(buf);
        handler.handle(player, player.m_284548_(), WorldSummary.of((Level)player.m_284548_()), packet);
    }

    public static interface ServerPacketHandler<T> {
        public void handle(ServerPlayer var1, ServerLevel var2, WorldSummary var3, T var4);
    }
}

