/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.kaleido.lib.quiltconfig.api.serializers;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.InMemoryCommentedFormat;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ConfigWriter;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import folk.sisby.kaleido.lib.quiltconfig.api.Config;
import folk.sisby.kaleido.lib.quiltconfig.api.Constraint;
import folk.sisby.kaleido.lib.quiltconfig.api.MarshallingUtils;
import folk.sisby.kaleido.lib.quiltconfig.api.Serializer;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ConfigSerializableObject;
import folk.sisby.kaleido.lib.quiltconfig.api.values.TrackedValue;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueKey;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueList;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueMap;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueTreeNode;
import folk.sisby.kaleido.lib.quiltconfig.impl.util.SerializerUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class TomlSerializer
implements Serializer {
    public static final TomlSerializer INSTANCE = new TomlSerializer();
    private final ConfigParser<CommentedConfig> parser = new TomlParser();
    private final ConfigWriter writer = new TomlWriter();

    private TomlSerializer() {
    }

    @Override
    public String getFileExtension() {
        return "toml";
    }

    @Override
    public void serialize(Config config, OutputStream to) {
        this.writer.write((UnmodifiableConfig)TomlSerializer.write(config, TomlSerializer.createCommentedConfig(), config.nodes()), to);
    }

    @Override
    public void deserialize(Config config, InputStream from) {
        CommentedConfig read = this.parser.parse(from);
        for (TrackedValue<?> trackedValue : config.values()) {
            List<ValueKey> keyOptions = SerializerUtils.getPossibleKeys(config, trackedValue);
            for (ValueKey key : keyOptions) {
                String stringKey = key.toString();
                if (!read.contains(stringKey)) continue;
                trackedValue.setValue(MarshallingUtils.coerce(read.get(stringKey), trackedValue.getDefaultValue(), (c, entryConsumer) -> c.entrySet().forEach(e -> entryConsumer.put(e.getKey(), e.getValue()))), false);
            }
        }
    }

    private static List<Object> convertList(List<?> list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object value : list) {
            result.add(TomlSerializer.convertAny(value));
        }
        return result;
    }

    private static UnmodifiableCommentedConfig convertMap(ValueMap<?> map) {
        CommentedConfig result = TomlSerializer.createCommentedConfig();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<String> key = new ArrayList<String>();
            key.add((String)entry.getKey());
            result.add(key, TomlSerializer.convertAny(entry.getValue()));
        }
        return result;
    }

    private static Object convertAny(Object value) {
        if (value instanceof ValueMap) {
            return TomlSerializer.convertMap((ValueMap)value);
        }
        if (value instanceof ValueList) {
            return TomlSerializer.convertList((ValueList)value);
        }
        if (value instanceof ConfigSerializableObject) {
            return TomlSerializer.convertAny(((ConfigSerializableObject)value).getRepresentation());
        }
        return value;
    }

    private static CommentedConfig write(Config config, CommentedConfig commentedConfig, Iterable<ValueTreeNode> nodes) {
        for (ValueTreeNode node : nodes) {
            ArrayList<String> comments = new ArrayList<String>();
            if (node.hasMetadata(Comment.TYPE)) {
                for (String string : node.metadata(Comment.TYPE)) {
                    comments.add(string);
                }
            }
            ValueKey key = SerializerUtils.getSerializedKey(config, node);
            if (node instanceof TrackedValue) {
                TrackedValue value = (TrackedValue)node;
                Object defaultValue = value.getDefaultValue();
                SerializerUtils.createEnumOptionsComment(defaultValue).ifPresent(comments::add);
                for (Constraint constraint : value.constraints()) {
                    comments.add(constraint.getRepresentation());
                }
                Optional<String> defaultValueComment = SerializerUtils.getDefaultValueString(defaultValue);
                defaultValueComment.ifPresent(s -> comments.add("default: " + s));
                commentedConfig.add(TomlSerializer.toNightConfigSerializable(key), TomlSerializer.convertAny(value.getRealValue()));
            } else {
                TomlSerializer.write(config, commentedConfig, (ValueTreeNode.Section)node);
            }
            if (comments.isEmpty()) continue;
            commentedConfig.setComment(TomlSerializer.toNightConfigSerializable(key), " " + String.join((CharSequence)"\n ", comments));
        }
        return commentedConfig;
    }

    private static CommentedConfig createCommentedConfig() {
        return InMemoryCommentedFormat.defaultInstance().createConfig(LinkedHashMap::new);
    }

    private static List<String> toNightConfigSerializable(ValueKey key) {
        ArrayList<String> listKey = new ArrayList<String>();
        key.forEach(listKey::add);
        return listKey;
    }
}

